/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tessboxeditor;

import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.sourceforge.tessboxeditor.GuiWithFont;

public class GuiWithLaF
extends GuiWithFont {
    private static final Logger logger = Logger.getLogger(GuiWithLaF.class.getName());

    public GuiWithLaF() {
        this.initComponents();
    }

    private void initComponents() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray;
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GuiWithLaF.this.updateLaF(actionEvent.getActionCommand());
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels()) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(lookAndFeelInfo.getName());
            jRadioButtonMenuItem.setActionCommand(lookAndFeelInfo.getClassName());
            if (UIManager.getLookAndFeel().getClass().getName().equals(jRadioButtonMenuItem.getActionCommand())) {
                jRadioButtonMenuItem.setSelected(true);
            }
            jRadioButtonMenuItem.addActionListener(actionListener);
            buttonGroup.add(jRadioButtonMenuItem);
            this.jMenuLookAndFeel.add(jRadioButtonMenuItem);
        }
    }

    void updateLaF(String string) {
        try {
            UIManager.setLookAndFeel(string);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, exception.getMessage(), exception);
        }
        for (Window window : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
            window.validate();
        }
    }

    @Override
    void quit() {
        prefs.put("lookAndFeel", UIManager.getLookAndFeel().getClass().getName());
        super.quit();
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GuiWithLaF().setVisible(true);
            }
        });
    }
}

