/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tessboxeditor;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import net.sourceforge.tessboxeditor.Gui;

public class GuiWithMRU
extends Gui {
    private final List<String> mruList = new ArrayList<String>();
    private String strClearRecentFiles;

    @Override
    protected void populateMRUList() {
        String[] stringArray;
        for (String string : stringArray = prefs.get("MruList", "").split(File.pathSeparator)) {
            if (string.equals("")) continue;
            this.mruList.add(string);
        }
        this.updateMRUMenu();
    }

    @Override
    protected void updateMRUList(String string) {
        if (this.mruList.contains(string)) {
            this.mruList.remove(string);
        }
        this.mruList.add(0, string);
        if (this.mruList.size() > 10) {
            this.mruList.remove(10);
        }
        this.updateMRUMenu();
    }

    private void updateMRUMenu() {
        this.jMenuRecentFiles.removeAll();
        if (this.mruList.isEmpty()) {
            this.jMenuRecentFiles.add(this.bundle.getString("No_Recent_Files"));
        } else {
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    String string = jMenuItem.getText();
                    if (string.equals(GuiWithMRU.this.strClearRecentFiles)) {
                        GuiWithMRU.this.mruList.clear();
                        GuiWithMRU.this.jMenuRecentFiles.removeAll();
                        GuiWithMRU.this.jMenuRecentFiles.add(GuiWithMRU.this.bundle.getString("No_Recent_Files"));
                    } else {
                        GuiWithMRU.this.openFile(new File(string));
                    }
                }
            };
            for (String string : this.mruList) {
                JMenuItem jMenuItem = this.jMenuRecentFiles.add(string);
                jMenuItem.addActionListener(abstractAction);
            }
            this.jMenuRecentFiles.addSeparator();
            this.strClearRecentFiles = this.bundle.getString("Clear_Recent_Files");
            JMenuItem jMenuItem = this.jMenuRecentFiles.add(this.strClearRecentFiles);
            jMenuItem.setMnemonic(this.bundle.getString("jMenuItemClear.Mnemonic").charAt(0));
            jMenuItem.addActionListener(abstractAction);
        }
    }

    @Override
    void quit() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.mruList) {
            stringBuilder.append(string).append(File.pathSeparatorChar);
        }
        prefs.put("MruList", stringBuilder.toString());
        super.quit();
    }
}

