/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.app;

import com.apple.mrj.MRJAboutHandler;
import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJPrefsHandler;
import com.apple.mrj.MRJQuitHandler;
import com.cyberfox.util.platform.Platform;
import com.jbidwatcher.auction.EntryCorral;
import com.jbidwatcher.ui.JBidToolBar;
import com.jbidwatcher.ui.JTabManager;
import com.jbidwatcher.ui.util.JMouseAdapter;
import com.jbidwatcher.ui.util.OptionUI;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.xml.XMLElement;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.CompoundBorder;

class MacFriendlyFrame
extends JFrame
implements MRJQuitHandler,
MRJAboutHandler,
MRJPrefsHandler {
    private JLabel mStatusBar;
    private JLabel mPrices;

    public MacFriendlyFrame(JBidToolBar toolBar, String title, JMouseAdapter myFrameAdapter, URL iconURL, JTabManager tabManager) {
        super(title);
        this.setMinimumSize(new Dimension(1000, 320));
        MRJApplicationUtils.registerQuitHandler((MRJQuitHandler)this);
        MRJApplicationUtils.registerAboutHandler((MRJAboutHandler)this);
        MRJApplicationUtils.registerPrefsHandler((MRJPrefsHandler)this);
        this.addMouseListener(myFrameAdapter);
        this.setDefaultCloseOperation(0);
        if (!Platform.isMac()) {
            this.setIconImage(new ImageIcon(iconURL).getImage());
        }
        if (JConfig.queryConfiguration("mac.useMetal", "true").equals("true")) {
            this.getRootPane().putClientProperty("apple.awt.brushMetalLook", "true");
        }
        JPanel headerBar = toolBar.buildHeaderBar(this, tabManager);
        JPanel statusPane = this.buildStatusLine();
        this.getContentPane().add(tabManager.getTabs());
        this.getContentPane().add((Component)statusPane, "South");
        this.getContentPane().add((Component)headerBar, "North");
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowIconified(WindowEvent we) {
                super.windowIconified(we);
                if (Platform.supportsTray() && Platform.isTrayEnabled() && JConfig.queryConfiguration("windows.tray", "true").equals("true") && JConfig.queryConfiguration("windows.minimize", "true").equals("true")) {
                    MQFactory.getConcrete("Swing").enqueue("HIDE");
                }
            }

            @Override
            public void windowClosing(WindowEvent we) {
                super.windowClosing(we);
                MQFactory.getConcrete("Swing").enqueue("QUIT");
            }
        });
    }

    private JPanel buildStatusLine() {
        final JPanel statusPane = new JPanel();
        CompoundBorder myBorder = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2), BorderFactory.createMatteBorder(1, 0, 0, 0, Color.DARK_GRAY)), BorderFactory.createEmptyBorder(1, 5, 1, 5));
        statusPane.setBorder(myBorder);
        statusPane.setLayout(new BoxLayout(statusPane, 0));
        JSeparator vert1 = new JSeparator(1);
        vert1.setForeground(Color.DARK_GRAY);
        vert1.setMinimumSize(new Dimension(10, 5));
        vert1.setMaximumSize(new Dimension(10, 20));
        statusPane.add(vert1);
        this.mStatusBar = new JLabel("Ready!");
        final Dimension statusBarSize = new Dimension(600, 16);
        this.mStatusBar.setMaximumSize(statusBarSize);
        this.mStatusBar.setMinimumSize(statusBarSize);
        this.mStatusBar.setPreferredSize(statusBarSize);
        statusPane.add(this.mStatusBar);
        statusPane.add(Box.createHorizontalGlue());
        JSeparator vert2 = new JSeparator(1);
        vert2.setForeground(Color.DARK_GRAY);
        vert2.setMinimumSize(new Dimension(10, 5));
        vert2.setMaximumSize(new Dimension(10, 20));
        statusPane.add(vert2);
        this.mPrices = new JLabel(" ");
        Dimension priceSize = new Dimension(300, 16);
        this.mPrices.setMinimumSize(priceSize);
        this.mPrices.setPreferredSize(priceSize);
        statusPane.add(this.mPrices);
        statusPane.add(Box.createHorizontalStrut(10));
        int baseSize = 346;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int textWidthAllowed = statusPane.getWidth() - 346;
                statusBarSize.setSize(textWidthAllowed - 15, 16);
                MacFriendlyFrame.this.mStatusBar.setMaximumSize(statusBarSize);
                MacFriendlyFrame.this.mStatusBar.setMinimumSize(statusBarSize);
                MacFriendlyFrame.this.mStatusBar.setPreferredSize(statusBarSize);
            }
        });
        return statusPane;
    }

    public void handleQuit() {
        if (!JConfig.queryConfiguration("prompt.snipe_quit", "false").equals("true") && EntryCorral.snipedCount() != 0) {
            MQFactory.getConcrete("Swing").enqueue("QUIT");
            throw new IllegalStateException("Ne changez pas mains, il viendra bient?t.");
        }
        MQFactory.getConcrete("jbidwatcher").enqueue("EXIT");
    }

    public void handleAbout() {
        MQFactory.getConcrete("user").enqueue("About JBidwatcher");
    }

    public void handlePrefs() {
        MQFactory.getConcrete("user").enqueue("Configure");
    }

    @Override
    public synchronized void addWindowListener(WindowListener listen) {
        super.removeWindowListener(listen);
        super.addWindowListener(listen);
    }

    public void setStatus(String status) {
        this.mStatusBar.setText(XMLElement.decodeString(status));
        this.mStatusBar.paintImmediately(this.mStatusBar.getVisibleRect());
    }

    public void setPrice(String price) {
        this.mPrices.setText(price);
        this.mPrices.paintImmediately(this.mPrices.getVisibleRect());
    }

    public void shutdown() {
        try {
            OptionUI oui;
            int rval;
            if (EntryCorral.snipedCount() != 0 && (rval = (oui = new OptionUI()).promptWithCheckbox(null, "There are outstanding snipes that will not be able to fire while JBidwatcher is not running.  Are you sure you want to quit?", "Pending Snipes confirmation", "prompt.snipe_quit")) == 2) {
                return;
            }
        }
        catch (Exception e) {
            JConfig.log().logDebug("Skipping snipe check due to exception!");
        }
        MQFactory.getConcrete("jbidwatcher").enqueue("EXIT");
    }
}

