/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction;

import com.jbidwatcher.util.db.ActiveRecord;
import com.jbidwatcher.util.db.Table;
import java.util.ArrayList;
import java.util.List;

public class Category
extends ActiveRecord {
    private static ThreadLocal<Table> tDB = new ThreadLocal<Table>(){

        @Override
        protected synchronized Table initialValue() {
            return ActiveRecord.openDB(Category.getTableName());
        }
    };

    public Category() {
    }

    public Category(String name) {
        this.setString("name", name);
    }

    public static Category findFirstByName(String name) {
        return Category.findFirstBy("name", name);
    }

    public static Category findOrCreateByName(String name) {
        Category c = Category.findFirstByName(name);
        if (c == null) {
            c = Category.create(name);
        }
        return c;
    }

    public static Category create(String newCategory) {
        Category c = new Category(newCategory);
        String id = c.saveDB();
        if (id != null) {
            c.setInteger("id", Integer.parseInt(id));
        }
        return c;
    }

    public String getName() {
        return this.getString("name");
    }

    protected static String getTableName() {
        return "categories";
    }

    public static Table getRealDatabase() {
        return tDB.get();
    }

    @Override
    protected Table getDatabase() {
        return Category.getRealDatabase();
    }

    public static Category findFirstBy(String key, String value) {
        return (Category)Category.findFirstBy(Category.class, key, value);
    }

    public static List<Category> all() {
        return Category.findAllBySQL(Category.class, "SELECT * FROM " + Category.getTableName());
    }

    public static List<String> categories() {
        List<? extends ActiveRecord> categories = Category.findAllBySQL(Category.class, "SELECT name FROM " + Category.getTableName());
        if (categories.isEmpty()) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>(categories.size());
        for (Category category : categories) {
            results.add(category.getName());
        }
        return results;
    }
}

