/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.jbidwatcher.ui.util.JContext;
import com.jbidwatcher.util.config.JConfig;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public abstract class JBidContext
extends JContext {
    protected JTable _inTable = null;

    protected JBidContext(JPopupMenu inPop) {
        super(inPop);
    }

    protected JBidContext() {
    }

    public void setTable(JTable initTable) {
        this._inTable = initTable;
    }

    protected int[] getPossibleRows() {
        if (this._inTable == null) {
            return null;
        }
        return this._inTable.getSelectedRows();
    }

    protected Object getIndexedEntry(int i) {
        return this._inTable.getValueAt(i, -1);
    }

    private static Object figureAuction(JTable curTable, int rowPoint) {
        return curTable.getValueAt(rowPoint, -1);
    }

    protected abstract void DoAction(Object var1, String var2, Object var3);

    @Override
    protected void beforePopup(JPopupMenu inPopup, MouseEvent e) {
        super.beforePopup(inPopup, e);
        if (!(e.getComponent() instanceof JComponent)) {
            return;
        }
        JComponent inComponent = (JComponent)e.getComponent();
        if (inComponent instanceof JTable) {
            this._inTable = (JTable)inComponent;
            int row = this._inTable.rowAtPoint(e.getPoint());
            if (!this._inTable.isRowSelected(row)) {
                this._inTable.setRowSelectionInterval(row, row);
            }
        }
    }

    @Override
    protected void internalDoubleClick(MouseEvent e) {
        super.internalDoubleClick(e);
        if (!(e.getComponent() instanceof JComponent)) {
            return;
        }
        JComponent inComponent = (JComponent)e.getComponent();
        if (inComponent instanceof JTable) {
            JTable thisTable = (JTable)inComponent;
            int rowPoint = thisTable.rowAtPoint(new Point(e.getX(), e.getY()));
            Object whichAuction = JBidContext.figureAuction(thisTable, rowPoint);
            this.DoAction(thisTable, JConfig.queryConfiguration("doubleclick.action", "Update"), whichAuction);
        }
    }

    public Object resolvePoint() {
        if (this._inTable == null) {
            return null;
        }
        Point curRow = new Point(this.getPopupX(), this.getPopupY());
        int rowPoint = this._inTable.rowAtPoint(curRow);
        return JBidContext.figureAuction(this._inTable, rowPoint);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        super.actionPerformed(ae);
        Object whichAuction = this.resolvePoint();
        String actionString = ae.getActionCommand();
        this.DoAction(ae.getSource(), actionString, whichAuction);
    }
}

