/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.config;

import com.cyberfox.util.platform.Platform;
import com.jbidwatcher.ui.config.JConfigTab;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.MQFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class JConfigGeneralTab
extends JConfigTab {
    private JCheckBox doVersionUpdateCheckBox;
    private JCheckBox debuggingBox;
    private JCheckBox loggingBox;
    private JCheckBox ignoreDeletedBox;
    private JCheckBox allowConfigUpdateBox;
    private JCheckBox allowArchival;
    private JCheckBox timeSyncBox;
    private JCheckBox disableThumbnailBox;
    private JComboBox allowMetricsReporting;
    private JCheckBox macMetalBox = null;
    private JCheckBox winTrayBox = null;
    private JCheckBox minimizeTrayBox = null;
    private String[] metricsChoices = new String[]{"Ask again later", "Yes", "Pre-release only", "No"};
    private String[] metricsValues = new String[]{"ask", "true", "pre", "false"};
    private JComboBox dclickAction = null;
    private String[] dclick_choices = new String[]{"Update the double-clicked auction", "Open the chosen auction in the browser", "Initiate a snipe on the given auction", "Place a bid on the chosen auction", "Show information about the double-clicked auction", "Make a comment on the auction", "Copy useful information about the selected auction"};
    private String[] dclick_options = new String[]{"Update", "Browse", "Snipe", "Bid", "Information", "Comment", "Copy"};

    @Override
    public String getTabName() {
        return "General";
    }

    @Override
    public void cancel() {
    }

    @Override
    public void apply() {
        int clickAction;
        boolean firstrun = JConfig.queryConfiguration("config.firstrun", "false").equals("true");
        if (!Platform.usingSparkle()) {
            JConfig.setConfiguration("updates.enabled", this.doVersionUpdateCheckBox.isSelected() ? "true" : "false");
        }
        JConfig.setConfiguration("debugging", this.debuggingBox.isSelected() ? "true" : "false");
        JConfig.setConfiguration("logging", this.loggingBox.isSelected() ? "true" : "false");
        if (!this.loggingBox.isSelected()) {
            JConfig.log().closeLog();
        }
        JConfig.setConfiguration("deleted.ignore", this.ignoreDeletedBox.isSelected() ? "true" : "false");
        int metricsChoice = this.allowMetricsReporting.getSelectedIndex();
        if (metricsChoice != -1) {
            JConfig.setConfiguration("metrics.optin", this.metricsValues[metricsChoice]);
        }
        if ((clickAction = this.dclickAction.getSelectedIndex()) != -1) {
            JConfig.setConfiguration("doubleclick.action", this.dclick_options[clickAction]);
        }
        if (!Platform.usingSparkle()) {
            JConfig.setConfiguration("updates.allowConfig", this.allowConfigUpdateBox.isSelected() ? "true" : "false");
        }
        JConfig.setConfiguration("store.auctionHTML", this.allowArchival.isSelected() ? "true" : "false");
        String restartMessage = null;
        String old_timeSyncBox = JConfig.queryConfiguration("timesync.enabled", "true");
        JConfig.setConfiguration("timesync.enabled", this.timeSyncBox.isSelected() ? "true" : "false");
        if (!firstrun && !old_timeSyncBox.equals(JConfig.queryConfiguration("timesync.enabled", "true"))) {
            restartMessage = "You have to close and restart JBidwatcher for the Time Synchronisation\nchange to be recognized, as it requires resetting the user interface.";
        }
        JConfig.setConfiguration("display.thumbnail", this.disableThumbnailBox.isSelected() ? "true" : "false");
        if (Platform.isMac() && this.macMetalBox != null) {
            String old_val = JConfig.queryConfiguration("mac.useMetal", "true");
            JConfig.setConfiguration("mac.useMetal", this.macMetalBox.isSelected() ? "true" : "false");
            String new_val = JConfig.queryConfiguration("mac.useMetal", "true");
            if (!firstrun && !old_val.equals(new_val)) {
                restartMessage = "You have to close and restart JBidwatcher for the Brushed\nMetal change to be recognized, as it requires resetting\nthe user interface.";
            }
        }
        if (Platform.supportsTray()) {
            String oldCfg = JConfig.queryConfiguration("windows.tray");
            JConfig.setConfiguration("windows.tray", this.winTrayBox.isSelected() ? "true" : "false");
            Platform.setTrayEnabled(this.winTrayBox.isSelected());
            JConfig.setConfiguration("windows.minimize", this.minimizeTrayBox.isSelected() ? "true" : "false");
            if (oldCfg == null || !oldCfg.equals(JConfig.queryConfiguration("windows.tray"))) {
                MQFactory.getConcrete("tray").enqueue("TRAY " + (this.winTrayBox.isSelected() ? "on" : "off"));
            }
        }
        if (restartMessage != null) {
            JOptionPane.showMessageDialog(null, restartMessage, "Shut down and restart JBidwatcher", -1);
        }
        if (firstrun) {
            JConfig.setConfiguration("config.firstrun", "false");
        }
    }

    @Override
    public void updateValues() {
        String doUpdates = JConfig.queryConfiguration("updates.enabled", "true");
        String doDebugging = JConfig.queryConfiguration("debugging", "false");
        String doLogging = JConfig.queryConfiguration("logging", "true");
        String doIgnoreDeleted = JConfig.queryConfiguration("deleted.ignore", "true");
        String doAllowConfigUpdates = JConfig.queryConfiguration("updates.allowConfig", "true");
        String doMacMetal = JConfig.queryConfiguration("mac.useMetal", "true");
        String doWinTray = JConfig.queryConfiguration("windows.tray", "true");
        String doMinimize = JConfig.queryConfiguration("windows.minimize", "true");
        String doArchival = JConfig.queryConfiguration("store.auctionHTML", "true");
        String doTimeSync = JConfig.queryConfiguration("timesync.enabled", "true");
        String doDisableThumbnails = JConfig.queryConfiguration("display.thumbnail", "true");
        if (!Platform.usingSparkle()) {
            this.doVersionUpdateCheckBox.setSelected(doUpdates.equals("true"));
        }
        this.debuggingBox.setSelected(doDebugging.equals("true"));
        this.loggingBox.setSelected(doLogging.equals("true"));
        this.ignoreDeletedBox.setSelected(doIgnoreDeleted.equals("true"));
        if (!Platform.usingSparkle()) {
            this.allowConfigUpdateBox.setSelected(doAllowConfigUpdates.equals("true"));
        }
        this.allowArchival.setSelected(doArchival.equals("true"));
        this.timeSyncBox.setSelected(doTimeSync.equals("true"));
        this.disableThumbnailBox.setSelected(doDisableThumbnails.equals("true"));
        if (Platform.supportsTray() && this.winTrayBox != null) {
            this.winTrayBox.setSelected(doWinTray.equals("true"));
            this.minimizeTrayBox.setEnabled(doWinTray.equals("true"));
            this.minimizeTrayBox.setSelected(doMinimize.equals("true"));
        }
        if (Platform.isMac() && this.macMetalBox != null) {
            this.macMetalBox.setSelected(doMacMetal.equals("true"));
        }
    }

    private JPanel buildCheckboxPanel() {
        JPanel tp = new JPanel();
        tp.setBorder(BorderFactory.createTitledBorder("General Options"));
        tp.setLayout(new GridLayout(0, 2));
        if (!Platform.usingSparkle()) {
            this.doVersionUpdateCheckBox = new JCheckBox("Regularly check for new versions");
            this.doVersionUpdateCheckBox.setToolTipText("Once a day check for updates, config changes or notices necessary to keep JBidwatcher running smoothly.");
            tp.add(this.doVersionUpdateCheckBox);
            this.allowConfigUpdateBox = new JCheckBox("Allow live configuration updates");
            this.allowConfigUpdateBox.setToolTipText("<html><body>Some eBay changes may be fixable with simple updates to configuration values,<br>or search strings.  This option allows JBidwatcher to look for those updates<br>during the new version check.  This only works if 'Regularly check for new versions'<br>is enabled.  This is <b>strongly</b> recommended.</body></html>");
            tp.add(this.allowConfigUpdateBox);
            this.doVersionUpdateCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JConfigGeneralTab.this.allowConfigUpdateBox.setEnabled(JConfigGeneralTab.this.doVersionUpdateCheckBox.isSelected());
                }
            });
        }
        this.debuggingBox = new JCheckBox("Debugging");
        this.debuggingBox.setToolTipText("Enable tracking a lot more information about the state of the program as it's working.");
        tp.add(this.debuggingBox);
        this.loggingBox = new JCheckBox("Logging");
        this.loggingBox.setToolTipText("Enable logging to error[.###].log files in the JBidwatcher home directory.");
        tp.add(this.loggingBox);
        this.ignoreDeletedBox = new JCheckBox("Ignore deleted items in search results");
        this.ignoreDeletedBox.setToolTipText("<html><body>Ignore previously deleted items when loading in the results from a search.<br>This prevents having to delete the same items repeatedly, every time a search executes.<br>STRONGLY recommended.</body></html>");
        tp.add(this.ignoreDeletedBox);
        this.allowArchival = new JCheckBox("Allow archival storage of auctions");
        this.allowArchival.setToolTipText("JBidwatcher will save auctions in compressed format, readable even after eBay has removed the item.");
        tp.add(this.allowArchival);
        this.timeSyncBox = new JCheckBox("Time Synchronisation");
        this.timeSyncBox.setToolTipText("Enable/disable time synchronisation");
        tp.add(this.timeSyncBox);
        this.disableThumbnailBox = new JCheckBox("Display Thumbnails");
        this.disableThumbnailBox.setToolTipText("Display thumbnails when the cursor hovers over an item.");
        tp.add(this.disableThumbnailBox);
        if (Platform.isMac()) {
            this.macMetalBox = new JCheckBox("Use Brushed Metal UI");
            this.macMetalBox.setToolTipText("Turn on / off brushed metal look under MacOSX.");
            tp.add(this.macMetalBox);
        }
        if (Platform.supportsTray()) {
            this.winTrayBox = new JCheckBox("Use System Tray");
            this.winTrayBox.setToolTipText("Allow JBidwatcher to put an icon in the system tray with some statistics on hover and some messages will use balloon-style popups.");
            tp.add(this.winTrayBox);
            this.minimizeTrayBox = new JCheckBox("Minimize to System Tray");
            this.minimizeTrayBox.setToolTipText("If checked, minimizing the window will send JBidwatcher to the tray instead of the task bar.");
            this.winTrayBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JConfigGeneralTab.this.minimizeTrayBox.setEnabled(JConfigGeneralTab.this.winTrayBox.isSelected());
                }
            });
            tp.add(this.minimizeTrayBox);
        }
        if (tp.getComponentCount() % 2 == 1) {
            tp.add(new JLabel(""));
        }
        String curMetricsChoice = JConfig.queryConfiguration("metrics.optin", "ask");
        int curIndex = Arrays.asList(this.metricsValues).indexOf(curMetricsChoice);
        this.allowMetricsReporting = new JComboBox<String>(this.metricsChoices);
        this.allowMetricsReporting.setSelectedIndex(curIndex);
        JLabel metricsLabel = new JLabel("Report anonymized usage");
        String metricsTooltip = "Reports anonymized usage statistics to me, to be used for improving the software.  Usage data is for statistical purposes only.";
        metricsLabel.setToolTipText(metricsTooltip);
        this.allowMetricsReporting.setToolTipText(metricsTooltip);
        tp.add(JConfigGeneralTab.makeLine(metricsLabel, this.allowMetricsReporting));
        this.updateValues();
        return tp;
    }

    private JPanel buildDropdownPanel() {
        JPanel tp = new JPanel();
        tp.setBorder(BorderFactory.createTitledBorder("Doubleclick setting"));
        tp.setLayout(new BorderLayout());
        String curClickAction = JConfig.queryConfiguration("doubleclick.action", "Update");
        this.dclickAction = new JComboBox<String>(this.dclick_choices);
        for (int i = 0; i < this.dclick_options.length; ++i) {
            if (!curClickAction.equals(this.dclick_options[i])) continue;
            this.dclickAction.setSelectedIndex(i);
        }
        tp.add((Component)JConfigGeneralTab.makeLine(new JLabel("Action: "), this.dclickAction), "North");
        return tp;
    }

    public JConfigGeneralTab() {
        super.setLayout(new BorderLayout());
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.add((Component)JConfigGeneralTab.panelPack(this.buildCheckboxPanel()), "North");
        jp.add((Component)JConfigGeneralTab.panelPack(this.buildDropdownPanel()), "Center");
        super.add((Component)jp, "North");
    }
}

