/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.util;

import com.jbidwatcher.ui.util.Hyperactive;
import com.jbidwatcher.ui.util.JBEditorPane;
import com.jbidwatcher.ui.util.JBidFrame;
import com.jbidwatcher.ui.util.JMouseAdapter;
import com.jbidwatcher.util.config.JConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class OptionUI {
    public static Object showInputDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) throws HeadlessException {
        JOptionPane pane = new JOptionPane(message, messageType, 2, icon, null, null);
        pane.setWantsInput(true);
        pane.setSelectionValues(selectionValues);
        pane.setInitialSelectionValue(initialSelectionValue);
        pane.setComponentOrientation((parentComponent == null ? JOptionPane.getRootFrame() : parentComponent).getComponentOrientation());
        JDialog dialog = pane.createDialog(parentComponent, title);
        dialog.setResizable(true);
        pane.selectInitialValue();
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
        Object value = pane.getInputValue();
        if (value == JOptionPane.UNINITIALIZED_VALUE) {
            return null;
        }
        return value;
    }

    public String promptString(Component parent, String prePrompt, String preTitle, String preFill) {
        return (String)OptionUI.showInputDialog(parent, prePrompt, preTitle, -1, null, null, preFill);
    }

    public JBEditorPane getBasicEditor(StringBuffer sb, Dimension inSize, boolean fixed, boolean html) {
        JBEditorPane jep = new JBEditorPane(html ? "text/html" : "text/plain", sb.toString());
        jep.setEditable(false);
        jep.addHyperlinkListener(new Hyperactive(jep));
        if (fixed) {
            jep.setPreferredSize(inSize);
            jep.setMaximumSize(inSize);
            jep.setMinimumSize(inSize);
        }
        return jep;
    }

    public static JBEditorPane getHTMLLabel(String s) {
        JBEditorPane jep = new JBEditorPane("text/html", s);
        jep.setEditable(false);
        jep.setOpaque(false);
        jep.addHyperlinkListener(new Hyperactive(jep));
        return jep;
    }

    public Point getCenter(Dimension inSize) {
        Rectangle centerBounds = OptionUI.findCenterBounds(inSize);
        Point screenCenter = new Point(centerBounds.width / 2 + centerBounds.x, centerBounds.height / 2 + centerBounds.y);
        screenCenter.x -= inSize.width / 2;
        screenCenter.y -= inSize.height / 2;
        return screenCenter;
    }

    public static Rectangle findCenterBounds(Dimension componentSize) {
        return OptionUI.findCenterBounds(JMouseAdapter.getCurrentGraphicsConfiguration(), componentSize);
    }

    private static Rectangle findCenterBounds(GraphicsConfiguration gconf, Dimension componentSize) {
        if (gconf == null) {
            gconf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle bounds = gconf.getBounds();
        return new Rectangle(bounds.x + (bounds.width - componentSize.width) / 2, bounds.y + (bounds.height - componentSize.height) / 2, componentSize.width, componentSize.height);
    }

    public JFrame showHTMLDisplay(StringBuffer inSB, Dimension inSize, String frameName) {
        JBidFrame otherFrame = this.getTextDisplay(inSB, inSize, frameName, true);
        otherFrame.pack();
        otherFrame.setSize(inSize.width, inSize.height);
        otherFrame.setVisible(true);
        return otherFrame;
    }

    public JBidFrame getTextDisplay(StringBuffer inSB, Dimension inSize, String frameName, boolean isHTML) {
        JBEditorPane jep = this.getBasicEditor(inSB, inSize, false, isHTML);
        JBidFrame otherFrame = new JBidFrame(frameName);
        JScrollPane jsp = new JScrollPane(jep);
        jsp.getVerticalScrollBar().setValue(0);
        otherFrame.getContentPane().add(jsp);
        jep.setCaretPosition(0);
        otherFrame.setLocation(this.getCenter(inSize));
        otherFrame.setEditor(jep);
        return otherFrame;
    }

    public JFrame showTextDisplayWithButtons(StringBuffer inSB, Dimension inSize, String frameName, final String config, final String buttonText1, final String value1, final String buttonText2, final String value2) {
        JBEditorPane jep = this.getBasicEditor(inSB, inSize, false, true);
        final JBidFrame otherFrame = new JBidFrame(frameName);
        otherFrame.setUndecorated(true);
        otherFrame.getRootPane().setWindowDecorationStyle(7);
        otherFrame.getContentPane().setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JButton button1 = new JButton(buttonText1);
        button1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(buttonText1)) {
                    JConfig.setConfiguration(config, value1);
                    otherFrame.setVisible(false);
                }
            }
        });
        JButton button2 = new JButton(buttonText2);
        button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(buttonText2)) {
                    JConfig.setConfiguration(config, value2);
                    otherFrame.setVisible(false);
                }
            }
        });
        buttonPanel.add((Component)button1, "West");
        buttonPanel.add((Component)button2, "East");
        otherFrame.getContentPane().add((Component)buttonPanel, "South");
        JScrollPane jsp = new JScrollPane(jep);
        jsp.getVerticalScrollBar().setValue(0);
        otherFrame.getContentPane().add((Component)jsp, "Center");
        jep.setCaretPosition(0);
        otherFrame.setLocation(this.getCenter(inSize));
        otherFrame.pack();
        otherFrame.setSize(inSize.width, inSize.height);
        otherFrame.setVisible(true);
        return otherFrame;
    }

    public JFrame showChoiceTextDisplay(StringBuffer inSB, Dimension inSize, String frameName, List<String> choices, String borderTitle, ActionListener al) {
        JEditorPane jep = new JEditorPane();
        HTMLEditorKit hek = new HTMLEditorKit();
        jep.setEditable(false);
        jep.setEditorKit(hek);
        jep.addHyperlinkListener(new Hyperactive(jep));
        jep.setPreferredSize(inSize);
        jep.setMaximumSize(inSize);
        jep.setMinimumSize(inSize);
        JBidFrame otherFrame = new JBidFrame(frameName);
        JPanel insidePanel = new JPanel(new BorderLayout());
        JScrollPane jsp = new JScrollPane(jep);
        StyleSheet sheet = hek.getStyleSheet();
        sheet.addRule(".smaller { font-size: 85%; }");
        sheet.addRule(".banner { font-size: 110%; }");
        sheet.addRule("body { font-family: Verdana, Geneva, Tahoma, sans-serif; }");
        sheet.addRule("ul li { margin-bottom: 4px; }");
        sheet.addRule(".changelog { color: #333333; margin-left: 20px; padding-left: 3px; background-color: #eeeeee; }");
        sheet.addRule(".changelog h1 { font-size: 110%; }");
        jep.setDocument(hek.createDefaultDocument());
        jep.setText(inSB.toString());
        jsp.getVerticalScrollBar().setValue(0);
        otherFrame.setPreferredSize(inSize);
        otherFrame.setMaximumSize(inSize);
        otherFrame.setMinimumSize(inSize);
        otherFrame.getContentPane().add(insidePanel);
        insidePanel.add((Component)jsp, "Center");
        if (borderTitle != null) {
            insidePanel.setBorder(BorderFactory.createTitledBorder(borderTitle));
        } else {
            insidePanel.setBorder(BorderFactory.createEmptyBorder());
        }
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        boolean isFirst = true;
        JComponent firstButton = null;
        for (String info : choices) {
            if (info.startsWith("CHECK")) {
                JCheckBox tmpCheck = new JCheckBox(info.substring(6));
                tmpCheck.addActionListener(al);
                bottomPanel.add(tmpCheck);
                continue;
            }
            if (info.startsWith("TEXT")) {
                JLabel tmpLabel = new JLabel(info.substring(5));
                bottomPanel.add(tmpLabel);
                continue;
            }
            JButton step_button = new JButton(info);
            step_button.addActionListener(al);
            bottomPanel.add(step_button);
            if (!isFirst) continue;
            isFirst = false;
            firstButton = step_button;
        }
        insidePanel.add((Component)bottomPanel, "South");
        jep.setCaretPosition(0);
        otherFrame.setLocation(this.getCenter(inSize));
        otherFrame.pack();
        otherFrame.setVisible(true);
        if (firstButton != null) {
            firstButton.requestFocusInWindow();
        }
        return otherFrame;
    }

    public int promptWithCheckbox(Component parent, String message, String title, String tf_config, int optionType, int defaultOption) {
        return this.promptWithCheckbox(parent, message, title, tf_config, null, optionType, defaultOption);
    }

    public int promptWithCheckbox(Component parent, String message, String title, String tf_config) {
        return this.promptWithCheckbox(parent, message, title, tf_config, null, 2, 0);
    }

    public int promptWithCheckbox(Component parent, String message, String title, String tf_config, String val_config, int optionType, int defaultOption) {
        if (JConfig.queryConfiguration(tf_config, "false").equals("true")) {
            String cfg_val;
            if (val_config != null && (cfg_val = JConfig.queryConfiguration(val_config, null)) != null) {
                return Integer.parseInt(cfg_val);
            }
            return defaultOption;
        }
        JCheckBox dontShowBox = new JCheckBox("Don't show this dialog again.");
        Object[] myComponents = new Object[]{message, dontShowBox};
        JOptionPane jopPrompt = new JOptionPane(myComponents, 3, optionType);
        JDialog jdInput = jopPrompt.createDialog(parent, title);
        jdInput.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent ev) {
                ev.getWindow().toFront();
            }
        });
        jdInput.setVisible(true);
        Object result = jopPrompt.getValue();
        Integer buttonChoiceObject = result == null || result.toString().equals("") || result.equals(JOptionPane.UNINITIALIZED_VALUE) ? Integer.valueOf(2) : new Integer(result.toString());
        if (tf_config != null) {
            JConfig.setConfiguration(tf_config, dontShowBox.isSelected() ? "true" : "false");
        }
        if (val_config != null) {
            JConfig.setConfiguration(val_config, buttonChoiceObject.toString());
        }
        return buttonChoiceObject;
    }
}

