/*
 * Decompiled with CFR 0.152.
 */
package com.orbus.mahalo.dns;

import com.orbus.mahalo.dns.DNSQuestion;
import com.orbus.mahalo.dns.DNSRecord;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNSPacket {
    public static final int MAX_MSG_ABSOLUTE = 8972;
    public static final String MDNS_GROUP = "224.0.0.251";
    public static final int MDNS_PORT = 5353;
    private static final int FLAGS_QR_MASK = 32768;
    private static final int FLAGS_QR_QUERY = 0;
    private static final int FLAGS_QR_RESPONSE = 32768;
    private static final int FLAGS_AA = 1024;
    private static final int FLAGS_TC = 512;
    private static final int FLAGS_RD = 256;
    private static final int FLAGS_RA = 32768;
    private long _iTimeRecieved = System.currentTimeMillis();
    private int _iMessageId;
    private int _iFlags;
    private List<DNSQuestion> _Questions;
    private List<DNSRecord> _Answers;

    public long getRecieved() {
        return this._iTimeRecieved;
    }

    public boolean isQuery() {
        return (this._iFlags & 0x8000) == 0;
    }

    public boolean isTruncated() {
        return (this._iFlags & 0x200) != 0;
    }

    public boolean isResponse() {
        return (this._iFlags & 0x8000) == 32768;
    }

    public boolean isAuthoritativeAnswer() {
        return (this._iFlags & 0x400) != 0;
    }

    public void setAuthoritativeAnswer(boolean abValue) {
        this._iFlags = abValue ? (this._iFlags |= 0x400) : (this._iFlags &= 0xFFFFFBFF);
    }

    public final List<DNSRecord> getAnswers() {
        return this._Answers;
    }

    public List<DNSQuestion> getQuestions() {
        return this._Questions;
    }

    public DNSPacket(boolean abResponce) {
        if (abResponce) {
            this._iFlags = 32768;
        }
        this._Questions = new ArrayList<DNSQuestion>();
        this._Answers = new ArrayList<DNSRecord>();
    }

    public void addAnswer(DNSRecord rec) {
        this._Answers.add(rec);
    }

    public void addQuestion(DNSQuestion rec) {
        this._Questions.add(rec);
    }

    public DNSPacket createResponce(boolean abMulticast) {
        DNSPacket responce = new DNSPacket(true);
        responce._iMessageId = this._iMessageId;
        if (!abMulticast) {
            responce._Questions.addAll(this._Questions);
        }
        return responce;
    }

    public ByteBuffer[] write() {
        LinkedList<ByteBuffer> bufferList = new LinkedList<ByteBuffer>();
        ByteBuffer currentBuffer = ByteBuffer.allocate(8972);
        bufferList.add(currentBuffer);
        currentBuffer.put(new byte[12]);
        int iquestionsRead = 0;
        int iquestionsWritten = 0;
        int ianswersRead = 0;
        int ianswersWritten = 0;
        while (iquestionsRead < this._Questions.size()) {
            try {
                DNSQuestion question = this._Questions.get(iquestionsRead);
                question.write(currentBuffer);
                ++iquestionsRead;
                ++iquestionsWritten;
            }
            catch (BufferOverflowException e) {
                iquestionsWritten = 0;
                this.writeMessageHeader(currentBuffer, true, iquestionsWritten, ianswersWritten);
                currentBuffer = ByteBuffer.allocate(8972);
                bufferList.add(currentBuffer);
            }
        }
        while (ianswersRead < this._Answers.size()) {
            try {
                DNSRecord record = this._Answers.get(ianswersRead);
                record.write(currentBuffer);
                ++ianswersRead;
                ++ianswersWritten;
            }
            catch (BufferOverflowException e) {
                ianswersWritten = 0;
                this.writeMessageHeader(currentBuffer, true, iquestionsWritten, ianswersWritten);
                currentBuffer = ByteBuffer.allocate(8972);
                bufferList.add(currentBuffer);
            }
        }
        this.writeMessageHeader(currentBuffer, false, iquestionsWritten, ianswersWritten);
        ByteBuffer[] retBuffers = new ByteBuffer[bufferList.size()];
        return bufferList.toArray(retBuffers);
    }

    private void writeMessageHeader(ByteBuffer aBuffer, boolean abTruncated, int aiQuestions, int aiAnswers) {
        aBuffer.putShort(0, (short)this._iMessageId);
        if (abTruncated) {
            aBuffer.putShort(2, (short)(this._iFlags | 0x200));
        } else {
            aBuffer.putShort(2, (short)this._iFlags);
        }
        aBuffer.putShort(4, (short)aiQuestions);
        aBuffer.putShort(6, (short)aiAnswers);
        aBuffer.putShort(8, (short)0);
        aBuffer.putShort(10, (short)0);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("DNSPacket[");
        buf.append(this.isQuery() ? "Query" : "Responce");
        if (this.isAuthoritativeAnswer()) {
            buf.append(" Authoratative");
        }
        if (this.isTruncated()) {
            buf.append(" Truncated");
        }
        buf.append(" Q:" + this._Questions.size());
        buf.append(" A:" + this._Answers.size());
        buf.append("]\n");
        if (this._Questions.size() > 0) {
            buf.append("---- Questions ----\n");
            for (DNSQuestion question : this._Questions) {
                buf.append(question + "\n");
            }
        }
        if (this._Answers.size() > 0) {
            buf.append("---- Answers -----\n");
            for (DNSRecord rec : this._Answers) {
                buf.append(rec + "\n");
            }
        }
        return buf.toString();
    }

    public static DNSPacket Parse(ByteBuffer aBuffer) throws IOException {
        int i;
        DNSPacket thePacket = new DNSPacket(false);
        thePacket._iMessageId = aBuffer.getShort();
        thePacket._iFlags = aBuffer.getShort();
        int numQuestions = aBuffer.getShort();
        int numAnswers = aBuffer.getShort();
        short numAuthorities = aBuffer.getShort();
        short numAdditionals = aBuffer.getShort();
        for (i = 0; i < numQuestions; ++i) {
            DNSQuestion question = DNSQuestion.Parse(aBuffer);
            thePacket._Questions.add(question);
        }
        numAnswers += numAuthorities + numAdditionals;
        for (i = 0; i < numAnswers; ++i) {
            DNSRecord record = DNSRecord.Parse(aBuffer);
            if (record == null) continue;
            thePacket._Answers.add(record);
        }
        return thePacket;
    }
}

