/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.cli;

import com.itextpdf.text.DocumentException;
import java.io.IOException;
import jpdftweak.cli.CommandOption;
import jpdftweak.core.PdfInputFile;
import jpdftweak.core.PdfTweak;

public class CropOption
implements CommandOption {
    private PdfTweak.PageBox cropTo;

    public boolean supportsOption(String string) {
        return string.equals("-crop");
    }

    public boolean setOption(String string, String string2) {
        if (this.cropTo != null) {
            System.err.println("Error: more than one -crop option used.");
            return false;
        }
        try {
            this.cropTo = PdfTweak.PageBox.valueOf(string2);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Unknown crop box: " + string2);
            return false;
        }
    }

    public void run(PdfTweak pdfTweak, PdfInputFile pdfInputFile) throws DocumentException, IOException {
        if (this.cropTo != null) {
            pdfTweak.cropPages(this.cropTo);
        }
    }

    public String getSummary() {
        return " -crop                   Crop pages to the given page box.\n";
    }

    public String getHelp(String string) {
        return " -crop {BOXNAME}\n    Crop all pages to the given page box.\n    Valid box names are:\n    MediaBox, CropBox, BleedBox, TrimBox, ArtBox";
    }
}

