/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.core;

import com.jmupdf.Page;
import com.jmupdf.PageRenderer;
import com.jmupdf.pdf.PdfDocument;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.imageio.ImageIO;

public class PdfToImage {
    private int colorMode;
    private int compressionType;
    private int quality;
    private int transparent;
    private ImageType imageType;
    boolean burstImages;

    public PdfToImage(boolean bl, ColorMode colorMode, ImageType imageType, TiffCompression tiffCompression, int n, boolean bl2) throws IOException {
        this.colorMode = colorMode.getCode();
        this.compressionType = tiffCompression.getCode();
        this.burstImages = bl;
        this.imageType = imageType;
        this.transparent = this.matchTransparency(bl2);
        this.quality = n;
    }

    private int matchTransparency(boolean bl) {
        if (bl) {
            return 1;
        }
        return 0;
    }

    public boolean shouldExecute() {
        return this.burstImages;
    }

    public void convertToImage(byte[] byArray, String string) throws IOException {
        try {
            PdfDocument pdfDocument = new PdfDocument(byArray);
            Page page = pdfDocument.getPage(1);
            String string2 = string.substring(0, string.lastIndexOf(".") + 1) + this.imageType.toString().toLowerCase();
            if (this.imageType == ImageType.JPG || this.imageType == ImageType.PNG || this.imageType == ImageType.PAM || this.imageType == ImageType.PNM || this.imageType == ImageType.TIFF) {
                this.exportUsingJmuPdf(pdfDocument, string2);
            } else if (this.imageType == ImageType.GIF || this.imageType == ImageType.BMP) {
                this.exportUsingImageIO(this.renderPage(page), string2);
            }
            pdfDocument.dispose();
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.toString());
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public void convertToMultiTiff(byte[] byArray, String string) throws IOException {
        try {
            PdfDocument pdfDocument = new PdfDocument(byArray);
            String string2 = string.substring(0, string.lastIndexOf(".") + 1) + "tiff";
            for (int i = 0; i < pdfDocument.getPageCount(); ++i) {
                pdfDocument.saveAsTif(i + 1, string2, 1.0f, this.transparent, this.colorMode, this.compressionType, 1, this.quality);
            }
            pdfDocument.dispose();
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.toString());
            iOException.initCause(exception);
            throw iOException;
        }
    }

    private void exportUsingJmuPdf(PdfDocument pdfDocument, String string) {
        switch (this.imageType) {
            case JPG: {
                pdfDocument.saveAsJPeg(1, string, 1.0f, this.colorMode, this.quality);
                break;
            }
            case PNG: {
                pdfDocument.saveAsPng(1, string, 1.0f, this.transparent, this.colorMode);
                break;
            }
            case PAM: {
                pdfDocument.saveAsPam(1, string, 1.0f, this.transparent, this.colorMode);
                break;
            }
            case PNM: {
                pdfDocument.saveAsPnm(1, string, 1.0f, this.colorMode);
                break;
            }
            case TIFF: {
                pdfDocument.saveAsTif(1, string, 1.0f, this.transparent, this.colorMode, this.compressionType, 1, this.quality);
                break;
            }
        }
    }

    private void exportUsingImageIO(BufferedImage bufferedImage, String string) throws IOException {
        ImageIO.write((RenderedImage)bufferedImage, this.imageType.toString(), new File(string));
    }

    private BufferedImage renderPage(Page page) {
        PageRenderer pageRenderer = new PageRenderer(page, 1.0f, -1, this.colorMode);
        pageRenderer.render(true);
        BufferedImage bufferedImage = pageRenderer.getImage();
        pageRenderer.dispose();
        return bufferedImage;
    }

    public static String getJarFolder() {
        String string;
        String string2 = System.getProperty("java.class.path");
        if (string2.contains(string = File.pathSeparator)) {
            String[] stringArray;
            for (String string3 : stringArray = string2.split(string)) {
                if (!string3.contains("lib")) continue;
                return string3.substring(0, string3.lastIndexOf("lib") + 3);
            }
        } else {
            string2 = new File(string2).getAbsoluteFile().getParentFile().getPath();
        }
        return string2;
    }

    public static void setJavaLibraryPath() throws NoSuchFieldException, IllegalAccessException {
        System.setProperty("java.library.path", PdfToImage.getJarFolder());
        Field field = ClassLoader.class.getDeclaredField("sys_paths");
        field.setAccessible(true);
        field.set(null, null);
    }

    public static boolean is64bit() {
        String string = System.getProperty("sun.arch.data.model");
        return string.equals("64");
    }

    public static String checkForLibraries() {
        try {
            Class.forName("com.jmupdf.util.Util");
        }
        catch (Throwable throwable) {
            return "nojmupdf";
        }
        String string = null;
        string = PdfToImage.is64bit() ? (File.pathSeparatorChar == ';' ? "jmupdf64.dll" : "libjmupdf64.so") : (File.pathSeparatorChar == ';' ? "jmupdf32.dll" : "libjmupdf32.so");
        File file = new File(PdfToImage.getJarFolder(), string);
        if (file.exists()) {
            return null;
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageType {
        PDF,
        JPG,
        PNG,
        GIF,
        PAM,
        PNM,
        BMP,
        TIFF;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TiffCompression {
        NONE(1),
        LZW(5),
        JPEG(7),
        ZLIB(8),
        PACKBITS(32773),
        DEFLATE(32946);

        private int code;

        private TiffCompression(int n2) {
            this.code = n2;
        }

        public int getCode() {
            return this.code;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColorMode {
        RGB(1, "RGB"),
        GRAY(10, "Grayscale"),
        BNW(12, "Black and White"),
        BNWI(121, "Black and White Indexed");

        private int code;
        private String name;

        private ColorMode(int n2, String string2) {
            this.code = n2;
            this.name = string2;
        }

        public int getCode() {
            return this.code;
        }

        public String toString() {
            return this.name;
        }
    }
}

