/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.core;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PRAcroForm;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfPageLabels;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfSmartCopy;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfTransition;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.SimpleBookmark;
import com.itextpdf.text.pdf.interfaces.PdfEncryptionSettings;
import com.itextpdf.text.pdf.internal.PdfViewerPreferencesImp;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jpdftweak.core.PdfBookmark;
import jpdftweak.core.PdfInputFile;
import jpdftweak.core.PdfPageRange;
import jpdftweak.core.PdfToImage;
import jpdftweak.core.ShuffleRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfTweak {
    private static final PdfName[] INFO_NAMES = new PdfName[]{PdfName.TITLE, PdfName.SUBJECT, PdfName.KEYWORDS, PdfName.AUTHOR, PdfName.CREATOR, PdfName.PRODUCER, PdfName.CREATIONDATE, PdfName.MODDATE};
    public static final int[] permissionBits = new int[]{4, 8, 16, 32, 256, 512, 1024, 2048};
    public static final String[] permissionTexts = new String[]{"Printing", "ModifyContents", "Copy", "ModifyAnnotations", "FillIn", "ScreenReaders", "Assembly", "HQPrinting"};
    public static final String[] TRANSITION_NAMES = new String[]{"None", "Out Vertical Split", "Out Horizontal Split", "In Vertical Split", "In Horizontal Split", "Vertical Blinds", "Vertical Blinds", "Inward Box", "Outward Box", "Left-Right Wipe", "Right-Left Wipe", "Bottom-Top Wipe", "Top-Bottom Wipe", "Dissolve", "Left-Right Glitter", "Top-Bottom Glitter", "Diagonal Glitter"};
    private static final String PDFTK_PAGE_MARKER = "pdftk_PageNum";
    private PdfReader currentReader;
    private int encryptionMode = -1;
    private int encryptionPermissions = -1;
    private byte[] userPassword = null;
    private byte[] ownerPassword = null;
    private int[][] transitionValues;
    private Map<PdfName, PdfObject> optionalViewerPreferences;
    private int simpleViewerPreferences;
    private List<File> attachments = null;
    private PrivateKey key = null;
    private Certificate[] certChain = null;
    private int certificationLevel = 0;
    private boolean sigVisible = false;
    private final String inputFilePath;
    private final String inputFileName;
    private final String inputFileFullName;
    private boolean preserveHyperlinks;
    private File tempfile1 = null;
    private File tempfile2 = null;
    private List<File> inputFiles = new ArrayList<File>();
    private PdfToImage pdfImages;

    public static String[] getKnownInfoNames() {
        String[] stringArray = new String[INFO_NAMES.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = INFO_NAMES[i].toString().substring(1);
        }
        return stringArray;
    }

    public PdfTweak(PdfInputFile pdfInputFile, boolean bl) throws IOException {
        if (bl) {
            this.tempfile1 = File.createTempFile("~jpdftweak", ".tmp").getAbsoluteFile();
            this.tempfile2 = File.createTempFile("~jpdftweak", ".tmp").getAbsoluteFile();
            this.tempfile1.deleteOnExit();
            this.tempfile2.deleteOnExit();
        }
        this.currentReader = pdfInputFile.getReader();
        File file = pdfInputFile.getFile();
        this.inputFilePath = file.getAbsoluteFile().getParentFile().getAbsolutePath();
        this.inputFileFullName = file.getName();
        int n = this.inputFileFullName.lastIndexOf(46);
        this.inputFileName = n == -1 ? this.inputFileFullName : this.inputFileFullName.substring(0, n);
        this.inputFiles.add(file.getCanonicalFile());
    }

    public PdfTweak(PdfInputFile pdfInputFile, List<PdfPageRange> list, boolean bl, int n) throws IOException, DocumentException {
        this(pdfInputFile, bl);
        PRAcroForm pRAcroForm;
        OutputStream outputStream = this.createTempOutputStream();
        PdfReader pdfReader = pdfInputFile.getReader();
        Document document = new Document(pdfReader.getPageSizeWithRotation(1));
        PdfCopy pdfCopy = new PdfCopy(document, outputStream);
        document.open();
        if (n == 0) {
            int n2 = 0;
            for (PdfPageRange pdfPageRange : list) {
                int[] nArray = pdfPageRange.getPages(n2);
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == -1) {
                        pdfCopy.addPage(pdfPageRange.getInputFile().getPageSize(1), 0);
                        continue;
                    }
                    PdfImportedPage pdfImportedPage = pdfPageRange.getInputFile().getImportedPage((PdfWriter)pdfCopy, nArray[i]);
                    pdfCopy.addPage(pdfImportedPage);
                }
                n2 += nArray.length;
                File file = pdfPageRange.getInputFile().getFile().getCanonicalFile();
                if (this.inputFiles.contains(file)) continue;
                this.inputFiles.add(file);
            }
        } else {
            int n3;
            int[][] nArrayArray = new int[list.size()][];
            int n4 = 0;
            for (n3 = 0; n3 < nArrayArray.length; ++n3) {
                PdfPageRange pdfPageRange = list.get(n3);
                nArrayArray[n3] = pdfPageRange.getPages(0);
                if (nArrayArray[n3].length <= n4) continue;
                n4 = nArrayArray[n3].length;
            }
            n3 = (n4 + n - 1) / n;
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < list.size(); ++j) {
                    PdfPageRange pdfPageRange = list.get(j);
                    int[] nArray = nArrayArray[j];
                    for (int k = 0; k < n; ++k) {
                        int n5;
                        int n6 = i * n + k;
                        int n7 = n5 = n6 < nArray.length ? nArray[n6] : -1;
                        if (n5 == -1) {
                            pdfCopy.addPage(pdfPageRange.getInputFile().getPageSize(1), 0);
                            continue;
                        }
                        PdfImportedPage pdfImportedPage = pdfPageRange.getInputFile().getImportedPage((PdfWriter)pdfCopy, n5);
                        pdfCopy.addPage(pdfImportedPage);
                    }
                }
            }
        }
        if ((pRAcroForm = pdfReader.getAcroForm()) != null) {
            pdfCopy.copyAcroForm(pdfReader);
        }
        this.copyXMPMetadata(pdfReader, (PdfWriter)pdfCopy);
        document.close();
        this.currentReader = this.getTempPdfReader(outputStream);
        this.copyInformation(pdfReader, this.currentReader);
    }

    public void setPdfImages(PdfToImage pdfToImage) {
        this.pdfImages = pdfToImage;
    }

    public PdfToImage getPdfImages() {
        return this.pdfImages;
    }

    private void copyXMPMetadata(PdfReader pdfReader, PdfWriter pdfWriter) throws IOException {
        PdfObject pdfObject = PdfReader.getPdfObject((PdfObject)pdfReader.getCatalog().get(PdfName.METADATA));
        if (pdfObject != null && pdfObject.isStream()) {
            byte[] byArray = PdfReader.getStreamBytesRaw((PRStream)((PRStream)pdfObject));
            pdfWriter.setXmpMetadata(byArray);
        }
    }

    private OutputStream createTempOutputStream() throws IOException {
        if (this.tempfile1 != null) {
            File file = this.tempfile1;
            this.tempfile1 = this.tempfile2;
            this.tempfile2 = file;
            if (!this.tempfile1.delete()) {
                throw new IOException("Cannot delete " + this.tempfile1);
            }
            return new FileOutputStream(this.tempfile1);
        }
        return new ByteArrayOutputStream();
    }

    private PdfReader getTempPdfReader(OutputStream outputStream) throws IOException {
        if (this.tempfile1 != null) {
            return new PdfReader(new RandomAccessFileOrArray(this.tempfile1.getPath(), false, true), null);
        }
        byte[] byArray = ((ByteArrayOutputStream)outputStream).toByteArray();
        return new PdfReader(byArray);
    }

    public void cleanup() {
        if (this.tempfile1 != null) {
            this.tempfile1.delete();
        }
        if (this.tempfile2 != null) {
            this.tempfile2.delete();
        }
    }

    private void cargoCult() {
        this.currentReader.consolidateNamedDestinations();
        this.currentReader.removeUnusedObjects();
        this.currentReader.shuffleSubsetNames();
    }

    public void updateInfoDictionary(Map<String, String> map) {
        PdfObject pdfObject;
        PdfDictionary pdfDictionary = this.currentReader.getTrailer();
        if (pdfDictionary != null && pdfDictionary.isDictionary() && (pdfObject = PdfReader.getPdfObject((PdfObject)pdfDictionary.get(PdfName.INFO))) != null && pdfObject.isDictionary()) {
            PdfDictionary pdfDictionary2 = (PdfDictionary)pdfObject;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getValue().length() == 0) {
                    pdfDictionary2.remove(new PdfName(entry.getKey()));
                    continue;
                }
                pdfDictionary2.put(new PdfName(entry.getKey()), (PdfObject)new PdfString(entry.getValue(), "UnicodeBig"));
            }
        }
        this.currentReader.getCatalog().remove(PdfName.METADATA);
    }

    private void copyInformation(PdfReader pdfReader, PdfReader pdfReader2) {
        PdfDictionary pdfDictionary = pdfReader.getTrailer();
        PdfDictionary pdfDictionary2 = pdfReader2.getTrailer();
        if (pdfDictionary != null && pdfDictionary.isDictionary() && pdfDictionary2 != null && pdfDictionary2.isDictionary()) {
            PdfObject pdfObject = PdfReader.getPdfObject((PdfObject)pdfDictionary.get(PdfName.INFO));
            PdfObject pdfObject2 = PdfReader.getPdfObject((PdfObject)pdfDictionary2.get(PdfName.INFO));
            if (pdfObject != null && pdfObject.isDictionary() && pdfObject2 != null && pdfObject2.isDictionary()) {
                PdfDictionary pdfDictionary3 = (PdfDictionary)pdfObject;
                PdfDictionary pdfDictionary4 = (PdfDictionary)pdfObject2;
                Iterator iterator = pdfDictionary3.getKeys().iterator();
                while (iterator.hasNext()) {
                    PdfName pdfName;
                    PdfName pdfName2 = pdfName = (PdfName)iterator.next();
                    PdfObject pdfObject3 = pdfDictionary3.get(pdfName2);
                    pdfDictionary4.put(pdfName2, pdfObject3);
                }
            }
        }
        pdfReader.close();
    }

    public void setEncryption(int n, int n2, byte[] byArray, byte[] byArray2) throws IOException {
        this.encryptionMode = n;
        this.encryptionPermissions = n2;
        this.userPassword = byArray2;
        this.ownerPassword = byArray;
        if (byArray.length == 0) {
            throw new IOException("Owner password may not be empty");
        }
    }

    private void setEncryptionSettings(PdfEncryptionSettings pdfEncryptionSettings) throws DocumentException {
        if (this.encryptionMode != -1) {
            pdfEncryptionSettings.setEncryption(this.userPassword, this.ownerPassword, this.encryptionPermissions, this.encryptionMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOutput(String object, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws IOException, DocumentException {
        Object object2;
        PdfCopy pdfCopy;
        PdfImportedPage pdfImportedPage;
        Object object4;
        Object object5;
        File file;
        if (!((String)object).contains(File.separator)) {
            file = new File((String)object);
            object = file.getAbsolutePath();
        }
        if (bl4) {
            file = new Document(this.currentReader.getPageSizeWithRotation(1));
            object5 = this.createTempOutputStream();
            object4 = new PdfSmartCopy((Document)file, (OutputStream)object5);
            file.open();
            for (int i = 0; i < this.currentReader.getNumberOfPages(); ++i) {
                PdfImportedPage object32 = object4.getImportedPage(this.currentReader, i + 1);
                object4.addPage(object32);
            }
            pdfImportedPage = this.currentReader.getAcroForm();
            if (pdfImportedPage != null) {
                object4.copyAcroForm(this.currentReader);
            }
            object4.setOutlines(SimpleBookmark.getBookmark((PdfReader)this.currentReader));
            PdfViewerPreferencesImp.getViewerPreferences((PdfDictionary)this.currentReader.getCatalog()).addToCatalog(object4.getExtraCatalog());
            this.copyXMPMetadata(this.currentReader, (PdfWriter)object4);
            pdfCopy = PdfPageLabels.getPageLabelFormats((PdfReader)this.currentReader);
            if (pdfCopy != null) {
                object2 = new PdfPageLabels();
                for (Object object3 : pdfCopy) {
                    object2.addPageLabel((PdfPageLabels.PdfPageLabelFormat)object3);
                }
                object4.setPageLabels(object2);
            }
            file.close();
            this.currentReader = this.getTempPdfReader((OutputStream)object5);
            this.copyInformation(this.currentReader, this.currentReader);
        }
        object = ((String)object).replace("<F>", this.inputFileName);
        object = ((String)object).replace("<FX>", this.inputFileFullName);
        if (((String)(object = ((String)object).replace("<P>", this.inputFilePath))).contains("<#>")) {
            int n = 1;
            while (true) {
                if (!new File((String)(object5 = ((String)object).replace("<#>", "" + n))).exists()) {
                    object = object5;
                    break;
                }
                ++n;
            }
        }
        if (!bl2 && this.inputFiles.contains(new File((String)object).getCanonicalFile())) {
            throw new IOException("Output file must be different from input file(s)");
        }
        this.cargoCult();
        try {
            if (bl3 && this.pdfImages == null) {
                Document.compress = false;
            }
            int n = this.currentReader.getNumberOfPages();
            if (bl) {
                if (((String)object).indexOf(42) != -1) {
                    throw new IOException("TIFF multipage filename should not contain *");
                }
                object5 = new Document(this.currentReader.getPageSizeWithRotation(1));
                object4 = new ByteArrayOutputStream();
                PdfCopy pdfCopy2 = new PdfCopy((Document)object5, (OutputStream)object4);
                object5.open();
                for (int i = 1; i <= this.currentReader.getNumberOfPages(); ++i) {
                    pdfImportedPage = pdfCopy2.getImportedPage(this.currentReader, i);
                    pdfCopy2.addPage(pdfImportedPage);
                }
                PRAcroForm pRAcroForm = this.currentReader.getAcroForm();
                if (pRAcroForm != null) {
                    pdfCopy2.copyAcroForm(this.currentReader);
                }
                object5.close();
                this.pdfImages.convertToMultiTiff(((ByteArrayOutputStream)object4).toByteArray(), (String)object);
            } else if (bl2) {
                object5 = object;
                if (((String)object5).indexOf(42) == -1) {
                    throw new IOException("Output filename does not contain *");
                }
                object4 = ((String)object5).substring(0, ((String)object5).indexOf(42));
                String string = ((String)object5).substring(((String)object5).indexOf(42) + 1);
                pdfImportedPage = PdfPageLabels.getPageLabels((PdfReader)this.currentReader);
                pdfCopy = null;
                object2 = null;
                for (int i = 1; i <= this.currentReader.getNumberOfPages(); ++i) {
                    Object object3;
                    Document document = new Document(this.currentReader.getPageSizeWithRotation(1));
                    String string2 = "" + i;
                    if (pdfImportedPage != null && i <= ((PdfImportedPage)pdfImportedPage).length) {
                        string2 = pdfImportedPage[i - 1];
                    }
                    if (this.inputFiles.contains(((File)(object3 = new File((String)object4 + string2 + string))).getCanonicalFile())) {
                        throw new IOException("Output file must be different from input file(s)");
                    }
                    if (!((File)object3).getParentFile().isDirectory()) {
                        ((File)object3).getParentFile().mkdirs();
                    }
                    if (this.pdfImages.shouldExecute()) {
                        object2 = new ByteArrayOutputStream();
                        pdfCopy = new PdfCopy(document, (OutputStream)object2);
                    } else {
                        pdfCopy = new PdfCopy(document, (OutputStream)new FileOutputStream((File)object3));
                        this.setEncryptionSettings((PdfEncryptionSettings)pdfCopy);
                        if (bl5) {
                            pdfCopy.setFullCompression();
                        }
                    }
                    document.open();
                    PdfImportedPage pdfImportedPage2 = pdfCopy.getImportedPage(this.currentReader, i);
                    pdfCopy.addPage(pdfImportedPage2);
                    PRAcroForm pRAcroForm = this.currentReader.getAcroForm();
                    if (pRAcroForm != null) {
                        pdfCopy.copyAcroForm(this.currentReader);
                    }
                    document.close();
                    if (!this.pdfImages.shouldExecute()) continue;
                    this.pdfImages.convertToImage(((ByteArrayOutputStream)object2).toByteArray(), (String)object4 + string2 + string);
                }
            } else {
                int n2;
                if (this.key != null) {
                    object5 = PdfStamper.createSignature((PdfReader)this.currentReader, (OutputStream)new FileOutputStream((String)object), (char)'\u0000', null, (boolean)true);
                    object4 = object5.getSignatureAppearance();
                    object4.setCrypto(this.key, this.certChain, null, PdfSignatureAppearance.WINCER_SIGNED);
                    object4.setCertificationLevel(this.certificationLevel);
                    if (this.sigVisible) {
                        object4.setVisibleSignature(new Rectangle(100.0f, 100.0f, 200.0f, 200.0f), 1, null);
                    }
                } else {
                    object5 = new PdfStamper(this.currentReader, (OutputStream)new FileOutputStream((String)object));
                }
                this.setEncryptionSettings((PdfEncryptionSettings)object5);
                if (bl5) {
                    object5.setFullCompression();
                }
                for (n2 = 1; n2 <= n; ++n2) {
                    this.currentReader.setPageContent(n2, this.currentReader.getPageContent(n2));
                }
                if (this.transitionValues != null) {
                    for (n2 = 0; n2 < n; ++n2) {
                        PdfTransition pdfTransition = this.transitionValues[n2][0] == 0 ? null : new PdfTransition(this.transitionValues[n2][0], this.transitionValues[n2][1]);
                        object5.setTransition(pdfTransition, n2 + 1);
                        object5.setDuration(this.transitionValues[n2][2], n2 + 1);
                    }
                }
                if (this.optionalViewerPreferences != null) {
                    object5.setViewerPreferences(this.simpleViewerPreferences);
                    for (Map.Entry<PdfName, PdfObject> entry : this.optionalViewerPreferences.entrySet()) {
                        object5.addViewerPreference(entry.getKey(), entry.getValue());
                    }
                }
                if (this.attachments != null) {
                    for (File file2 : this.attachments) {
                        object5.addFileAttachment(file2.getName(), null, file2.getAbsolutePath(), file2.getName());
                    }
                }
                object5.close();
            }
        }
        finally {
            Document.compress = true;
        }
        this.currentReader.close();
        this.currentReader = null;
        if (this.tempfile1 != null && !this.tempfile1.delete()) {
            throw new IOException("Cannot delete " + this.tempfile1);
        }
        if (this.tempfile2 != null && !this.tempfile2.delete()) {
            throw new IOException("Cannot delete " + this.tempfile2);
        }
        this.tempfile2 = null;
        this.tempfile1 = null;
    }

    public void cropPages(PageBox pageBox) throws IOException, DocumentException {
        PageBox pageBox2;
        int n;
        OutputStream outputStream = this.createTempOutputStream();
        Document document = new Document();
        PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        PdfContentByte pdfContentByte = null;
        int[] nArray = new int[this.currentReader.getNumberOfPages()];
        for (n = 1; n <= this.currentReader.getNumberOfPages(); ++n) {
            pageBox2 = pageBox;
            Rectangle rectangle = this.currentReader.getPageSize(n);
            Rectangle rectangle2 = null;
            while (pageBox2 != null && (rectangle2 = this.currentReader.getBoxSize(n, pageBox2.getBoxName())) == null) {
                pageBox2 = pageBox2.defaultBox;
            }
            if (rectangle2 == null) {
                rectangle2 = rectangle;
            }
            document.setMargins(0.0f, 0.0f, 0.0f, 0.0f);
            document.setPageSize(new Rectangle(rectangle2.getWidth(), rectangle2.getHeight()));
            if (pdfContentByte == null) {
                document.open();
                pdfContentByte = pdfWriter.getDirectContent();
            } else {
                document.newPage();
            }
            nArray[n - 1] = this.currentReader.getPageRotation(n);
            PdfImportedPage pdfImportedPage = pdfWriter.getImportedPage(this.currentReader, n);
            pdfContentByte.addTemplate((PdfTemplate)pdfImportedPage, rectangle.getLeft() - rectangle2.getLeft(), rectangle.getBottom() - rectangle2.getBottom());
            if (!this.preserveHyperlinks) continue;
            ArrayList arrayList = this.currentReader.getLinks(n);
            for (int i = 0; i < arrayList.size(); ++i) {
                PdfAnnotation.PdfImportedLink pdfImportedLink = (PdfAnnotation.PdfImportedLink)arrayList.get(i);
                if (pdfImportedLink.isInternal()) {
                    pdfImportedLink.transformDestination(1.0f, 0.0f, 0.0f, 1.0f, rectangle.getLeft() - rectangle2.getLeft(), rectangle.getBottom() - rectangle2.getBottom());
                }
                pdfImportedLink.transformRect(1.0f, 0.0f, 0.0f, 1.0f, rectangle.getLeft() - rectangle2.getLeft(), rectangle.getBottom() - rectangle2.getBottom());
                pdfWriter.addAnnotation(pdfImportedLink.createAnnotation(pdfWriter));
            }
        }
        this.copyXMPMetadata(this.currentReader, pdfWriter);
        document.close();
        this.currentReader = this.getTempPdfReader(outputStream);
        this.copyInformation(this.currentReader, this.currentReader);
        for (n = 1; n <= this.currentReader.getNumberOfPages(); ++n) {
            pageBox2 = this.currentReader.getPageN(n);
            pageBox2.put(PdfName.ROTATE, (PdfObject)new PdfNumber(nArray[n - 1]));
        }
    }

    public void rotatePages(int n, int n2) {
        for (int i = 1; i <= this.currentReader.getNumberOfPages(); ++i) {
            int n3 = this.currentReader.getPageRotation(i);
            Rectangle rectangle = this.currentReader.getPageSizeWithRotation(i);
            int n4 = rectangle.getWidth() > rectangle.getHeight() ? n2 : n;
            n3 = (n3 + 90 * n4) % 360;
            PdfDictionary pdfDictionary = this.currentReader.getPageN(i);
            pdfDictionary.put(PdfName.ROTATE, (PdfObject)new PdfNumber(n3));
        }
    }

    public void removeRotation() throws DocumentException, IOException {
        boolean bl = false;
        for (int i = 1; i <= this.currentReader.getNumberOfPages(); ++i) {
            if (this.currentReader.getPageRotation(i) == 0) continue;
            bl = true;
        }
        if (!bl) {
            return;
        }
        OutputStream outputStream = this.createTempOutputStream();
        Document document = new Document();
        PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        PdfContentByte pdfContentByte = null;
        for (int i = 1; i <= this.currentReader.getNumberOfPages(); ++i) {
            float f;
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            Rectangle rectangle = this.currentReader.getPageSizeWithRotation(i);
            rectangle = new Rectangle(rectangle.getWidth(), rectangle.getHeight());
            document.setPageSize(rectangle);
            if (pdfContentByte == null) {
                document.open();
                pdfContentByte = pdfWriter.getDirectContent();
            } else {
                document.newPage();
            }
            int n = this.currentReader.getPageRotation(i);
            PdfImportedPage pdfImportedPage = pdfWriter.getImportedPage(this.currentReader, i);
            if (n == 0) {
                f6 = 1.0f;
                f5 = 0.0f;
                f4 = 0.0f;
                f3 = 1.0f;
                f2 = 0.0f;
                f = 0.0f;
            } else if (n == 90) {
                f6 = 0.0f;
                f5 = -1.0f;
                f4 = 1.0f;
                f3 = 0.0f;
                f2 = 0.0f;
                f = rectangle.getHeight();
            } else if (n == 180) {
                f6 = -1.0f;
                f5 = 0.0f;
                f4 = 0.0f;
                f3 = -1.0f;
                f2 = rectangle.getWidth();
                f = rectangle.getHeight();
            } else if (n == 270) {
                f6 = 0.0f;
                f5 = 1.0f;
                f4 = -1.0f;
                f3 = 0.0f;
                f2 = rectangle.getWidth();
                f = 0.0f;
            } else {
                throw new IOException("Unparsable rotation value: " + n);
            }
            pdfContentByte.addTemplate((PdfTemplate)pdfImportedPage, f6, f5, f4, f3, f2, f);
            if (!this.preserveHyperlinks) continue;
            ArrayList arrayList = this.currentReader.getLinks(i);
            for (int j = 0; j < arrayList.size(); ++j) {
                PdfAnnotation.PdfImportedLink pdfImportedLink = (PdfAnnotation.PdfImportedLink)arrayList.get(j);
                if (pdfImportedLink.isInternal()) {
                    float f7;
                    float f8;
                    float f9;
                    float f10;
                    float f11;
                    float f12;
                    int n2 = pdfImportedLink.getDestinationPage();
                    int n3 = this.currentReader.getPageRotation(n2);
                    Rectangle rectangle2 = this.currentReader.getPageSizeWithRotation(n2);
                    if (n3 == 0) {
                        f12 = 1.0f;
                        f11 = 0.0f;
                        f10 = 0.0f;
                        f9 = 1.0f;
                        f8 = 0.0f;
                        f7 = 0.0f;
                    } else if (n3 == 90) {
                        f12 = 0.0f;
                        f11 = -1.0f;
                        f10 = 1.0f;
                        f9 = 0.0f;
                        f8 = 0.0f;
                        f7 = rectangle2.getHeight();
                    } else if (n3 == 180) {
                        f12 = -1.0f;
                        f11 = 0.0f;
                        f10 = 0.0f;
                        f9 = -1.0f;
                        f8 = rectangle2.getWidth();
                        f7 = rectangle2.getHeight();
                    } else if (n3 == 270) {
                        f12 = 0.0f;
                        f11 = 1.0f;
                        f10 = -1.0f;
                        f9 = 0.0f;
                        f8 = rectangle2.getWidth();
                        f7 = 0.0f;
                    } else {
                        throw new IOException("Unparsable rotation value: " + n3);
                    }
                    pdfImportedLink.setDestinationPage(n2);
                    pdfImportedLink.transformDestination(f12, f11, f10, f9, f8, f7);
                }
                pdfImportedLink.transformRect(f6, f5, f4, f3, f2, f);
                pdfWriter.addAnnotation(pdfImportedLink.createAnnotation(pdfWriter));
            }
        }
        this.copyXMPMetadata(this.currentReader, pdfWriter);
        document.close();
        this.currentReader = this.getTempPdfReader(outputStream);
        this.copyInformation(this.currentReader, this.currentReader);
    }

    public void scalePages(float f, float f2, boolean bl, boolean bl2) throws DocumentException, IOException {
        this.removeRotation();
        OutputStream outputStream = this.createTempOutputStream();
        Rectangle rectangle = new Rectangle(f, f2);
        Document document = new Document(rectangle, 0.0f, 0.0f, 0.0f, 0.0f);
        PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        document.open();
        PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
        for (int i = 1; i <= this.currentReader.getNumberOfPages(); ++i) {
            document.newPage();
            Rectangle rectangle2 = this.currentReader.getPageSizeWithRotation(i);
            if (this.currentReader.getPageRotation(i) != 0) {
                throw new RuntimeException("" + this.currentReader.getPageRotation(i));
            }
            float f3 = rectangle.getWidth() / rectangle2.getWidth();
            float f4 = rectangle.getHeight() / rectangle2.getHeight();
            if (bl) {
                if (f3 > 1.0f) {
                    f3 = 1.0f;
                }
                if (f4 > 1.0f) {
                    f4 = 1.0f;
                }
            }
            if (bl2) {
                f4 = f3 = Math.min(f3, f4);
            }
            float f5 = (rectangle.getWidth() - rectangle2.getWidth() * f3) / 2.0f;
            float f6 = (rectangle.getHeight() - rectangle2.getHeight() * f4) / 2.0f;
            PdfImportedPage pdfImportedPage = pdfWriter.getImportedPage(this.currentReader, i);
            pdfContentByte.addTemplate((PdfTemplate)pdfImportedPage, f3, 0.0f, 0.0f, f4, f5, f6);
            if (!this.preserveHyperlinks) continue;
            ArrayList arrayList = this.currentReader.getLinks(i);
            for (int j = 0; j < arrayList.size(); ++j) {
                PdfAnnotation.PdfImportedLink pdfImportedLink = (PdfAnnotation.PdfImportedLink)arrayList.get(j);
                if (pdfImportedLink.isInternal()) {
                    int n = pdfImportedLink.getDestinationPage();
                    Rectangle rectangle3 = this.currentReader.getPageSizeWithRotation(n);
                    float f7 = rectangle.getWidth() / rectangle3.getWidth();
                    float f8 = rectangle.getHeight() / rectangle3.getHeight();
                    if (bl) {
                        if (f7 > 1.0f) {
                            f7 = 1.0f;
                        }
                        if (f8 > 1.0f) {
                            f8 = 1.0f;
                        }
                    }
                    if (bl2) {
                        f8 = f7 = Math.min(f7, f8);
                    }
                    float f9 = (rectangle.getWidth() - rectangle3.getWidth() * f7) / 2.0f;
                    float f10 = (rectangle.getHeight() - rectangle3.getHeight() * f8) / 2.0f;
                    pdfImportedLink.setDestinationPage(n);
                    pdfImportedLink.transformDestination(f7, 0.0f, 0.0f, f8, f9, f10);
                }
                pdfImportedLink.transformRect(f3, 0.0f, 0.0f, f4, f5, f6);
                pdfWriter.addAnnotation(pdfImportedLink.createAnnotation(pdfWriter));
            }
        }
        this.copyXMPMetadata(this.currentReader, pdfWriter);
        document.close();
        this.currentReader = this.getTempPdfReader(outputStream);
        this.copyInformation(this.currentReader, this.currentReader);
    }

    public void shufflePages(int n, int n2, ShuffleRule[] shuffleRuleArray) throws DocumentException, IOException {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        this.removeRotation();
        OutputStream outputStream = this.createTempOutputStream();
        Rectangle rectangle = this.currentReader.getPageSize(1);
        for (int i = 1; i <= this.currentReader.getNumberOfPages(); ++i) {
            if (this.currentReader.getPageSize(i).getWidth() != rectangle.getWidth() || this.currentReader.getPageSize(i).getHeight() != rectangle.getHeight()) {
                throw new IOException("Pages must have equals sizes to be shuffled. Use the Scale option on the PageSize tab first.");
            }
            if (this.currentReader.getPageRotation(i) == 0) continue;
            throw new RuntimeException();
        }
        Document document = new Document(rectangle, 0.0f, 0.0f, 0.0f, 0.0f);
        PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        document.open();
        PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
        int n9 = Math.abs(n);
        int n10 = this.currentReader.getNumberOfPages();
        int n11 = n2 == 0 ? 1 : (n10 + n2 - 1) / n2;
        int[] nArray = null;
        ShuffleRule[] shuffleRuleArray2 = null;
        if (this.preserveHyperlinks) {
            nArray = new int[n10 + 1];
            shuffleRuleArray2 = new ShuffleRule[n10 + 1];
            n8 = 0;
            for (n7 = 0; n7 < n11; ++n7) {
                n6 = n7 == n11 - 1 ? n10 - n7 * n2 : n2;
                n5 = (n6 + (n9 - 1)) / n9 * n9;
                for (n4 = 0; n4 < n6; n4 += n9) {
                    n3 = n4;
                    int n12 = n5 - n3 - n9;
                    if (n < 0) {
                        n3 = n4 / 2;
                        n12 = n5 - n3 - n9;
                    }
                    n3 += n7 * n2;
                    n12 += n7 * n2;
                    ShuffleRule[] shuffleRuleArray3 = shuffleRuleArray;
                    int n13 = shuffleRuleArray3.length;
                    for (int i = 0; i < n13; ++i) {
                        ShuffleRule shuffleRule = shuffleRuleArray3[i];
                        if (shuffleRule.isNewPageBefore()) {
                            ++n8;
                        }
                        int n14 = shuffleRule.getPageNumber();
                        if (shuffleRule.getPageBase() == ShuffleRule.PageBase.BEGINNING) {
                            n14 += n3;
                        } else if (shuffleRule.getPageBase() == ShuffleRule.PageBase.END) {
                            n14 += n12;
                        }
                        if (n14 < 1) {
                            throw new IOException("Invalid page number. Check your n-up rules.");
                        }
                        if (n14 > n10) continue;
                        nArray[n14] = n8;
                        shuffleRuleArray2[n14] = shuffleRule;
                    }
                }
            }
        }
        for (n8 = 0; n8 < n11; ++n8) {
            n7 = n8 == n11 - 1 ? n10 - n8 * n2 : n2;
            n6 = (n7 + (n9 - 1)) / n9 * n9;
            for (n5 = 0; n5 < n7; n5 += n9) {
                n4 = n5;
                n3 = n6 - n4 - n9;
                if (n < 0) {
                    n4 = n5 / 2;
                    n3 = n6 - n4 - n9;
                }
                n4 += n8 * n2;
                n3 += n8 * n2;
                for (ShuffleRule shuffleRule : shuffleRuleArray) {
                    float f;
                    float f2;
                    float f3;
                    float f4;
                    float f5;
                    float f6;
                    if (shuffleRule.isNewPageBefore()) {
                        document.newPage();
                    }
                    float f7 = (float)shuffleRule.getScale();
                    float f8 = (float)shuffleRule.getOffsetX();
                    float f9 = (float)shuffleRule.getOffsetY();
                    if (shuffleRule.isOffsetXPercent()) {
                        f8 = f8 * rectangle.getWidth() / 100.0f;
                    }
                    if (shuffleRule.isOffsetXPercent()) {
                        f9 = f9 * rectangle.getHeight() / 100.0f;
                    }
                    switch (shuffleRule.getRotate()) {
                        case 'N': {
                            f6 = f7;
                            f5 = 0.0f;
                            f4 = 0.0f;
                            f3 = f7;
                            f2 = f8 * f7;
                            f = f9 * f7;
                            break;
                        }
                        case 'R': {
                            f6 = 0.0f;
                            f5 = -f7;
                            f4 = f7;
                            f3 = 0.0f;
                            f2 = f9 * f7;
                            f = -f8 * f7;
                            break;
                        }
                        case 'U': {
                            f6 = -f7;
                            f5 = 0.0f;
                            f4 = 0.0f;
                            f3 = -f7;
                            f2 = -f8 * f7;
                            f = -f9 * f7;
                            break;
                        }
                        case 'L': {
                            f6 = 0.0f;
                            f5 = f7;
                            f4 = -f7;
                            f3 = 0.0f;
                            f2 = -f9 * f7;
                            f = f8 * f7;
                            break;
                        }
                        default: {
                            throw new RuntimeException("" + shuffleRule.getRotate());
                        }
                    }
                    int n15 = shuffleRule.getPageNumber();
                    if (shuffleRule.getPageBase() == ShuffleRule.PageBase.BEGINNING) {
                        n15 += n4;
                    } else if (shuffleRule.getPageBase() == ShuffleRule.PageBase.END) {
                        n15 += n3;
                    }
                    if (n15 < 1) {
                        throw new IOException("Invalid page number. Check your n-up rules.");
                    }
                    if (n15 <= n10) {
                        PdfImportedPage pdfImportedPage = pdfWriter.getImportedPage(this.currentReader, n15);
                        pdfContentByte.addTemplate((PdfTemplate)pdfImportedPage, f6, f5, f4, f3, f2, f);
                        if (this.preserveHyperlinks) {
                            ArrayList arrayList = this.currentReader.getLinks(n15);
                            for (int i = 0; i < arrayList.size(); ++i) {
                                PdfAnnotation.PdfImportedLink pdfImportedLink = (PdfAnnotation.PdfImportedLink)arrayList.get(i);
                                if (pdfImportedLink.isInternal()) {
                                    float f10;
                                    float f11;
                                    float f12;
                                    float f13;
                                    float f14;
                                    float f15;
                                    int n16 = pdfImportedLink.getDestinationPage();
                                    ShuffleRule shuffleRule2 = shuffleRuleArray2[n16];
                                    float f16 = (float)shuffleRule2.getScale();
                                    float f17 = (float)shuffleRule2.getOffsetX();
                                    float f18 = (float)shuffleRule2.getOffsetY();
                                    if (shuffleRule2.isOffsetXPercent()) {
                                        f17 = f17 * rectangle.getWidth() / 100.0f;
                                    }
                                    if (shuffleRule2.isOffsetXPercent()) {
                                        f18 = f18 * rectangle.getHeight() / 100.0f;
                                    }
                                    switch (shuffleRule2.getRotate()) {
                                        case 'N': {
                                            f15 = f16;
                                            f14 = 0.0f;
                                            f13 = 0.0f;
                                            f12 = f16;
                                            f11 = f17 * f16;
                                            f10 = f18 * f16;
                                            break;
                                        }
                                        case 'R': {
                                            f15 = 0.0f;
                                            f14 = -f16;
                                            f13 = f16;
                                            f12 = 0.0f;
                                            f11 = f18 * f16;
                                            f10 = -f17 * f16;
                                            break;
                                        }
                                        case 'U': {
                                            f15 = -f16;
                                            f14 = 0.0f;
                                            f13 = 0.0f;
                                            f12 = -f16;
                                            f11 = -f17 * f16;
                                            f10 = -f18 * f16;
                                            break;
                                        }
                                        case 'L': {
                                            f15 = 0.0f;
                                            f14 = f16;
                                            f13 = -f16;
                                            f12 = 0.0f;
                                            f11 = -f18 * f16;
                                            f10 = f17 * f16;
                                            break;
                                        }
                                        default: {
                                            throw new RuntimeException("" + shuffleRule.getRotate());
                                        }
                                    }
                                    pdfImportedLink.setDestinationPage(nArray[n16]);
                                    pdfImportedLink.transformDestination(f15, f14, f13, f12, f11, f10);
                                }
                                pdfImportedLink.transformRect(f6, f5, f4, f3, f2, f);
                                pdfWriter.addAnnotation(pdfImportedLink.createAnnotation(pdfWriter));
                            }
                        }
                        if (!(shuffleRule.getFrameWidth() > 0.0)) continue;
                        pdfContentByte.setLineWidth((float)shuffleRule.getFrameWidth());
                        pdfContentByte.rectangle(f2, f, f6 * rectangle.getWidth() + f4 * rectangle.getHeight(), f5 * rectangle.getWidth() + f3 * rectangle.getHeight());
                        pdfContentByte.stroke();
                        continue;
                    }
                    pdfWriter.setPageEmpty(false);
                }
            }
        }
        this.copyXMPMetadata(this.currentReader, pdfWriter);
        document.close();
        this.currentReader = this.getTempPdfReader(outputStream);
        this.copyInformation(this.currentReader, this.currentReader);
    }

    public void addPageMarks() {
        int n = this.currentReader.getNumberOfPages();
        for (int i = 1; i <= n; ++i) {
            PdfDictionary pdfDictionary = this.currentReader.getPageN(i);
            if (pdfDictionary == null || !pdfDictionary.isDictionary()) continue;
            pdfDictionary.put(new PdfName(PDFTK_PAGE_MARKER), (PdfObject)new PdfNumber(i));
        }
    }

    public void removePageMarks() {
        int n = this.currentReader.getNumberOfPages();
        for (int i = 1; i <= n; ++i) {
            PdfDictionary pdfDictionary = this.currentReader.getPageN(i);
            if (pdfDictionary == null || !pdfDictionary.isDictionary()) continue;
            pdfDictionary.remove(new PdfName(PDFTK_PAGE_MARKER));
        }
    }

    public void updateBookmarks(PdfBookmark[] pdfBookmarkArray) throws DocumentException, IOException {
        OutputStream outputStream = this.createTempOutputStream();
        PdfStamper pdfStamper = new PdfStamper(this.currentReader, outputStream);
        pdfStamper.setOutlines(PdfBookmark.makeBookmarks(pdfBookmarkArray));
        pdfStamper.close();
        this.currentReader = this.getTempPdfReader(outputStream);
    }

    public void addWatermark(PdfInputFile pdfInputFile, String string, int n, float f, Color color, int n2, boolean bl, int n3, float f2, float f3, String string2) throws DocumentException, IOException {
        int n4;
        OutputStream outputStream = this.createTempOutputStream();
        int n5 = this.currentReader.getNumberOfPages();
        PdfGState pdfGState = new PdfGState();
        pdfGState.setFillOpacity(f);
        PdfStamper pdfStamper = new PdfStamper(this.currentReader, outputStream);
        BaseFont baseFont = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        float f4 = 0.0f;
        PdfImportedPage pdfImportedPage = null;
        String[] stringArray = null;
        PdfPageLabels.PdfPageLabelFormat[] pdfPageLabelFormatArray = null;
        if (string != null) {
            f4 = baseFont.getWidthPoint(string, (float)n);
        }
        if (pdfInputFile != null) {
            pdfImportedPage = pdfStamper.getImportedPage(pdfInputFile.getReader(), 1);
        }
        if (string2 != null && string2.length() > 0) {
            stringArray = PdfPageLabels.getPageLabels((PdfReader)this.currentReader);
            if (stringArray == null) {
                stringArray = new String[n5];
                for (n4 = 1; n4 <= n5; ++n4) {
                    stringArray[n4 - 1] = "" + n4;
                }
            }
            if ((pdfPageLabelFormatArray = PdfPageLabels.getPageLabelFormats((PdfReader)this.currentReader)) == null || pdfPageLabelFormatArray.length == 0) {
                pdfPageLabelFormatArray = new PdfPageLabels.PdfPageLabelFormat[]{new PdfPageLabels.PdfPageLabelFormat(1, 0, "", 1)};
            }
        }
        for (n4 = 1; n4 <= n5; ++n4) {
            Object object;
            PdfContentByte pdfContentByte;
            if (pdfImportedPage != null) {
                pdfContentByte = pdfStamper.getUnderContent(n4);
                pdfContentByte.addTemplate((PdfTemplate)pdfImportedPage, 0.0f, 0.0f);
                if (this.preserveHyperlinks) {
                    object = this.currentReader.getLinks(n4);
                    PdfWriter pdfWriter = pdfContentByte.getPdfWriter();
                    for (int i = 0; i < object.size(); ++i) {
                        PdfAnnotation.PdfImportedLink pdfImportedLink = (PdfAnnotation.PdfImportedLink)object.get(i);
                        if (pdfImportedLink.isInternal()) continue;
                        pdfWriter.addAnnotation(pdfImportedLink.createAnnotation(pdfWriter));
                    }
                }
            }
            pdfContentByte = pdfStamper.getOverContent(n4);
            object = this.currentReader.getPageSizeWithRotation(n4);
            if (string != null) {
                float f5 = (float)Math.atan(object.getHeight() / object.getWidth());
                float f6 = (float)Math.cos(f5);
                float f7 = (float)(-Math.sin(f5));
                float f8 = (float)Math.sin(f5);
                float f9 = (float)Math.cos(f5);
                float f10 = (float)(-Math.cos(f5) * (double)f4 / 2.0 - Math.sin(f5) * (double)n / 2.0);
                float f11 = (float)(Math.sin(f5) * (double)f4 / 2.0 - Math.cos(f5) * (double)n / 2.0);
                pdfContentByte.saveState();
                pdfContentByte.setGState(pdfGState);
                pdfContentByte.beginText();
                if (color != null) {
                    pdfContentByte.setColorFill(new BaseColor(color));
                }
                pdfContentByte.setFontAndSize(baseFont, (float)n);
                pdfContentByte.setTextMatrix(f6, f7, f8, f9, f10 + object.getWidth() / 2.0f, f11 + object.getHeight() / 2.0f);
                pdfContentByte.showText(string);
                pdfContentByte.endText();
                pdfContentByte.restoreState();
            }
            if (n2 == -1) continue;
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(baseFont, (float)n3);
            int n6 = n2 % 3;
            if (bl && n4 % 2 == 0) {
                n6 = 2 - n6;
            }
            float f12 = f2 * (float)(n6 == 2 ? -1 : 1) + object.getWidth() * (float)n6 / 2.0f;
            float f13 = f3 * (float)(n2 / 3 == 2 ? -1 : 1) + object.getHeight() * (float)(n2 / 3) / 2.0f;
            String string3 = "" + n4;
            if (string2 != null && string2.length() > 0) {
                int n7 = n4;
                for (PdfPageLabels.PdfPageLabelFormat pdfPageLabelFormat : pdfPageLabelFormatArray) {
                    if (pdfPageLabelFormat.physicalPage > n4) continue;
                    n7 = n4 - pdfPageLabelFormat.physicalPage + pdfPageLabelFormat.logicalPage;
                }
                String string4 = stringArray[n4 - 1];
                try {
                    string3 = String.format(string2, n4, n5, n7, string4);
                }
                catch (IllegalFormatException illegalFormatException) {
                    throw new IOException(illegalFormatException.toString());
                }
            }
            if (n6 != 1 && f2 * 2.0f < baseFont.getWidthPoint(string3, (float)n3) || n2 / 3 == 0 && f3 < baseFont.getDescentPoint(string3, (float)n3) || n2 / 3 == 2 && f3 < baseFont.getAscentPoint(string3, (float)n3)) {
                throw new IOException("Page number " + string3 + " is not within page bounding box");
            }
            pdfContentByte.showTextAligned(1, string3, f12, f13, 0.0f);
            pdfContentByte.endText();
        }
        pdfStamper.close();
        this.currentReader = this.getTempPdfReader(outputStream);
    }

    public int getPageCount() {
        return this.currentReader.getNumberOfPages();
    }

    public void setTransition(int n, int n2, int n3, int n4) {
        if (this.transitionValues == null) {
            this.transitionValues = new int[this.getPageCount()][3];
            for (int i = 0; i < this.transitionValues.length; ++i) {
                this.transitionValues[i][2] = -1;
            }
        }
        this.transitionValues[n - 1][0] = n2;
        this.transitionValues[n - 1][1] = n3;
        this.transitionValues[n - 1][2] = n4;
    }

    public void setViewerPreferences(int n, Map<PdfName, PdfObject> map) {
        this.optionalViewerPreferences = map;
        this.simpleViewerPreferences = n;
    }

    public void addFile(File file) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<File>();
        }
        this.attachments.add(file);
    }

    public void setSignature(File file, String string, char[] cArray, int n, boolean bl) throws IOException {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(file), cArray);
            this.key = (PrivateKey)keyStore.getKey(string, cArray);
            if (this.key == null) {
                throw new IOException("No private key found with alias " + string);
            }
            this.certChain = keyStore.getCertificateChain(string);
            this.certificationLevel = n;
            this.sigVisible = bl;
        }
        catch (GeneralSecurityException generalSecurityException) {
            IOException iOException = new IOException(generalSecurityException.toString());
            iOException.initCause(generalSecurityException);
            throw iOException;
        }
    }

    public void setPageNumbers(PdfPageLabels.PdfPageLabelFormat[] document) throws DocumentException, IOException {
        PdfPageLabels pdfPageLabels = new PdfPageLabels();
        for (PdfPageLabels.PdfPageLabelFormat pdfPageLabelFormat : document) {
            pdfPageLabels.addPageLabel(pdfPageLabelFormat);
        }
        Document document2 = new Document(this.currentReader.getPageSizeWithRotation(1));
        OutputStream outputStream = this.createTempOutputStream();
        PdfCopy pdfCopy = new PdfCopy(document2, outputStream);
        document2.open();
        for (int i = 0; i < this.currentReader.getNumberOfPages(); ++i) {
            PdfPageLabels.PdfPageLabelFormat pdfPageLabelFormat;
            pdfPageLabelFormat = pdfCopy.getImportedPage(this.currentReader, i + 1);
            pdfCopy.addPage((PdfImportedPage)pdfPageLabelFormat);
        }
        PRAcroForm pRAcroForm = this.currentReader.getAcroForm();
        if (pRAcroForm != null) {
            pdfCopy.copyAcroForm(this.currentReader);
        }
        pdfCopy.setPageLabels(pdfPageLabels);
        this.copyXMPMetadata(this.currentReader, (PdfWriter)pdfCopy);
        document2.close();
        this.currentReader = this.getTempPdfReader(outputStream);
        this.copyInformation(this.currentReader, this.currentReader);
    }

    public void preserveHyperlinks() {
        this.preserveHyperlinks = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PageBox {
        MediaBox(null),
        CropBox(MediaBox),
        BleedBox(CropBox),
        TrimBox(CropBox),
        ArtBox(TrimBox);

        public final PageBox defaultBox;

        private PageBox(PageBox pageBox) {
            this.defaultBox = pageBox;
        }

        private String getBoxName() {
            return this.name().substring(0, this.name().length() - 3).toLowerCase();
        }
    }
}

