/*
 * Decompiled with CFR 0.152.
 */
package com.jmupdf.pdf;

import com.jmupdf.Document;
import com.jmupdf.exceptions.DocException;
import com.jmupdf.exceptions.DocSecurityException;
import com.jmupdf.pdf.PdfEncrypt;
import com.jmupdf.pdf.PdfInformation;

public class PdfDocument
extends Document {
    private PdfInformation pdfInformation;
    private PdfEncrypt pdfEncrypt;

    public PdfDocument(String document) throws DocException, DocSecurityException {
        this.open(document, null, 0);
        this.validate();
    }

    public PdfDocument(String document, String password) throws DocException, DocSecurityException {
        this.open(document, password, 0);
        this.validate();
    }

    public PdfDocument(byte[] document) throws DocException, DocSecurityException {
        this.open(document, null, 0);
        this.validate();
    }

    public PdfDocument(byte[] document, String password) throws DocException, DocSecurityException {
        this.open(document, password, 0);
        this.validate();
    }

    private void validate() throws DocException, DocSecurityException {
        if (this.getHandle() > 0L) {
            return;
        }
        if (this.getHandle() == -1L || this.getHandle() == -2L || this.getHandle() == -3L) {
            throw new DocException("Error " + this.getHandle() + ": Document " + this.getDocumentName() + " could not be opened.");
        }
        if (this.getHandle() == -4L || this.getHandle() == -5L) {
            throw new DocSecurityException("Error " + this.getHandle() + ": Document requires authentication");
        }
        throw new DocException("Unexpected error opening document.");
    }

    public String getInfo(String key) {
        if (this.getHandle() > 0L) {
            return PdfDocument.muPdfInfo(this.getHandle(), key);
        }
        return null;
    }

    public PdfEncrypt getEncryptInfo() {
        if (this.getHandle() > 0L) {
            if (this.pdfEncrypt == null) {
                this.pdfEncrypt = new PdfEncrypt(this);
            }
            return this.pdfEncrypt;
        }
        return null;
    }

    public PdfInformation getInformation() {
        if (this.getHandle() > 0L) {
            if (this.pdfInformation == null) {
                this.pdfInformation = new PdfInformation(this);
            }
            return this.pdfInformation;
        }
        return null;
    }

    public void dispose() {
        this.close();
    }

    public PdfDocument clone() {
        PdfDocument doc = null;
        if (this.getHandle() > 0L) {
            try {
                doc = new PdfDocument(this.getDocumentName(), this.getPassWord());
            }
            catch (DocException e) {
                e.printStackTrace();
            }
            catch (DocSecurityException e) {
                e.printStackTrace();
            }
        }
        return doc;
    }

    protected void log(String text) {
        System.out.println(text);
    }
}

