/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction;

import com.jbidwatcher.auction.AuctionCore;
import com.jbidwatcher.auction.AuctionInfo;
import com.jbidwatcher.auction.AuctionServerInterface;
import com.jbidwatcher.auction.AuctionSnipe;
import com.jbidwatcher.auction.Category;
import com.jbidwatcher.auction.EntryInterface;
import com.jbidwatcher.auction.EntryTable;
import com.jbidwatcher.auction.Presenter;
import com.jbidwatcher.auction.event.EventLogger;
import com.jbidwatcher.util.Constants;
import com.jbidwatcher.util.Currency;
import com.jbidwatcher.util.Observer;
import com.jbidwatcher.util.TimeLeftBuilder;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.db.Table;
import com.jbidwatcher.util.queue.MQFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AuctionEntry
extends AuctionCore
implements Comparable<AuctionEntry>,
EntryInterface {
    private Category mCategory;
    private Presenter mAuctionEntryPresenter = null;
    private EventLogger mEntryEvents = null;
    private boolean mLoaded = false;
    private AuctionSnipe mSnipe = null;
    private Currency mCancelSnipeBid = null;
    private AuctionServerInterface mServer = null;
    private long mSnipeAt = -1L;
    private static long sDefaultSnipeAt = 30000L;
    private StringBuffer mLastErrorPage = null;
    private static List<Observer<AuctionEntry>> allObservers = new ArrayList<Observer<AuctionEntry>>();
    public static final String endedAuction = "Auction ended.";
    private static AuctionInfo sAuction = new AuctionInfo();
    private boolean deleting = false;

    public boolean equals(Object o) {
        return o instanceof AuctionEntry && this.compareTo((AuctionEntry)o) == 0;
    }

    public void logError() {
        this.setLastStatus("Communications failure talking to the server.");
        this.setInvalid();
    }

    public Currency bestValue() {
        if (this.isSniped()) {
            return this.getSnipe().getAmount();
        }
        return this.isBidOn() && !this.isComplete() ? this.getBid() : this.getCurrentPrice();
    }

    public Currency getSnipeAmount() {
        return this.isSniped() ? this.getSnipe().getAmount() : Currency.NoValue();
    }

    public int getSnipeQuantity() {
        return this.isSniped() ? this.getSnipe().getQuantity() : 0;
    }

    AuctionSnipe getSnipe() {
        if (this.mSnipe == null && this.get("snipe_id") != null) {
            this.mSnipe = AuctionSnipe.find(this.get("snipe_id"));
            if (this.mSnipe == null) {
                this.setInteger("snipe_id", null);
                this.saveDB();
            }
        }
        return this.mSnipe;
    }

    private synchronized void prepareAuctionEntry(String auctionIdentifier) {
        AuctionInfo info = this.mServer.create(auctionIdentifier);
        boolean bl = this.mLoaded = info != null;
        if (this.mLoaded) {
            this.setString("identifier", auctionIdentifier);
            info.saveDB();
            this.setInteger("auction_id", info.getId());
        }
        if (this.mLoaded) {
            Currency currentPrice = info.getBestPrice();
            this.setDate("last_updated_at", new Date());
            this.setDefaultCurrency(currentPrice);
            this.saveDB();
            this.notifyObservers(ObserverMode.AFTER_CREATE);
            this.updateHighBid();
            this.checkHighBidder();
            this.checkEnded();
        }
    }

    private AuctionEntry(String auctionIdentifier, AuctionServerInterface server) {
        this.mServer = server;
        AuctionEntry.checkConfigurationSnipeTime();
        this.prepareAuctionEntry(auctionIdentifier);
    }

    public AuctionEntry() {
        AuctionEntry.checkConfigurationSnipeTime();
        this.notifyObservers(ObserverMode.AFTER_CREATE);
    }

    public boolean hasAuction() {
        AuctionInfo ai = AuctionInfo.findByIdOrIdentifier(this.getAuctionId(), this.getIdentifier());
        return ai != null;
    }

    private void notifyObservers(ObserverMode event) {
        for (Observer<AuctionEntry> toNotify : allObservers) {
            switch (event) {
                case AFTER_CREATE: {
                    toNotify.afterCreate(this);
                    break;
                }
                case AFTER_SAVE: {
                    toNotify.afterSave(this);
                }
            }
        }
    }

    public static void addObserver(Observer<AuctionEntry> observer) {
        allObservers.add(observer);
    }

    static AuctionEntry construct(String identifier, AuctionServerInterface server) {
        String id;
        AuctionEntry ae = new AuctionEntry(identifier, server);
        if (ae.isLoaded() && (id = ae.saveDB()) != null) {
            JConfig.increment("stats.auctions");
            return ae;
        }
        return null;
    }

    static AuctionEntry construct(AuctionServerInterface server) {
        AuctionEntry ae = new AuctionEntry();
        ae.setServer(server);
        return ae;
    }

    private void checkEnded() {
        Date serverTime;
        if (!this.isComplete() && (serverTime = new Date(System.currentTimeMillis() + this.getServer().getServerTimeDelta())).after(this.getEndDate())) {
            this.setComplete(true);
            this.setNeedsUpdate();
        }
    }

    public AuctionServerInterface getServer() {
        return this.mServer;
    }

    public void setServer(AuctionServerInterface newServer) {
        if (newServer != this.mServer) {
            if (this.isSniped()) {
                this.getServer().cancelSnipe(this.getIdentifier());
            }
            this.mServer = newServer;
            if (this.isSniped()) {
                this.getServer().setSnipe(this.getIdentifier());
            }
        }
    }

    private boolean isLoaded() {
        return this.mLoaded;
    }

    public boolean isSnipeValid() {
        if (this.getSnipe() == null) {
            return false;
        }
        Currency minIncrement = this.getServer().getMinimumBidIncrement(this.getCurBid(), this.getNumBidders());
        boolean rval = false;
        try {
            if (this.getSnipe().getAmount().getValue() >= this.getCurBid().add(minIncrement).getValue()) {
                rval = true;
            }
        }
        catch (Currency.CurrencyTypeException cte) {
            JConfig.log().handleException("This should never happen (" + this.getCurBid() + ", " + minIncrement + ", " + this.getSnipe().getAmount() + ")!", cte);
        }
        return rval;
    }

    public boolean isSniped() {
        return this.getSnipe() != null;
    }

    public boolean isBidOn() {
        return this.getBid() != null && !this.getBid().isNull();
    }

    public boolean isHighBidder() {
        return this.isWinning();
    }

    public boolean isWinning() {
        return this.getBoolean("winning", false);
    }

    public void setWinning(boolean state) {
        this.setBoolean("winning", state);
    }

    public boolean isSeller() {
        return this.getServer().isCurrentUser(this.getSellerName());
    }

    public Currency getBid() {
        return this.getMonetary("last_bid_amount");
    }

    public void setBid(Currency highBid) {
        this.setMonetary("last_bid_amount", highBid == null ? Currency.NoValue() : highBid);
        this.saveDB();
    }

    public void setBidQuantity(int quant) {
        this.setInteger("last_bid_quantity", quant);
        this.saveDB();
    }

    public int getBidQuantity() {
        if (this.isBidOn()) {
            Integer i = this.getInteger("last_bid_quantity");
            return i != null ? i : 1;
        }
        return 0;
    }

    private static long getGlobalSnipeTime() {
        String strConfigSnipeAt = JConfig.queryConfiguration("snipemilliseconds");
        long snipeTime = strConfigSnipeAt != null ? Long.parseLong(strConfigSnipeAt) : 30000L;
        return snipeTime;
    }

    private static void checkConfigurationSnipeTime() {
        sDefaultSnipeAt = AuctionEntry.getGlobalSnipeTime();
    }

    public static void setDefaultSnipeTime(long newSnipeAt) {
        sDefaultSnipeAt = newSnipeAt;
    }

    @Override
    public long getSnipeTime() {
        return this.hasDefaultSnipeTime() ? sDefaultSnipeAt : this.mSnipeAt;
    }

    @Override
    public boolean hasDefaultSnipeTime() {
        return this.mSnipeAt == -1L;
    }

    @Override
    public void setSnipeTime(long newSnipeTime) {
        this.mSnipeAt = newSnipeTime;
    }

    public boolean isJustAdded() {
        Date d = this.getDate("created_at");
        return d != null && d.getTime() > System.currentTimeMillis() - 300000L;
    }

    public void updateHighBid() {
        int numBidders = this.getNumBidders();
        if (numBidders > 0 || this.isFixed()) {
            this.getServer().updateHighBid(this.getIdentifier());
        }
    }

    private void checkHighBidder() {
        int numBidders = this.getNumBidders();
        if (numBidders > 0) {
            if (this.isBidOn() && this.isPrivate()) {
                Currency curBid = this.getCurBid();
                try {
                    if (curBid.less(this.getBid())) {
                        this.setWinning(true);
                    }
                }
                catch (Currency.CurrencyTypeException cte) {
                    JConfig.log().handleException("This should never happen (bad Currency at this point!).", cte);
                }
                if (curBid.equals(this.getBid())) {
                    this.setWinning(numBidders == 1);
                }
            } else {
                this.setWinning(this.getServer().isCurrentUser(this.getHighBidder()));
            }
        }
    }

    public void clearInvalid() {
        this.setBoolean("invalid", false);
        this.saveDB();
    }

    public void setInvalid() {
        this.setBoolean("invalid", true);
        this.saveDB();
    }

    public boolean isInvalid() {
        return this.getBoolean("invalid", false);
    }

    public void setComment(String newComment) {
        if (newComment.trim().length() == 0) {
            this.setString("comment", null);
        } else {
            this.setString("comment", newComment.trim());
        }
        this.saveDB();
    }

    public String getComment() {
        return this.getString("comment");
    }

    public void setLastStatus(String inStatus) {
        this.getEvents().setLastStatus(inStatus);
    }

    public void setShipping(Currency newShipping) {
        this.setMonetary("shipping", newShipping);
        this.saveDB();
    }

    public String getLastStatus() {
        return this.getEvents().getLastStatus();
    }

    public String getStatusHistory() {
        return this.getEvents().getAllStatuses();
    }

    public int getStatusCount() {
        return this.getEvents().getStatusCount();
    }

    private EventLogger getEvents() {
        if (this.mEntryEvents == null) {
            this.mEntryEvents = new EventLogger(this.getIdentifier(), this.getId(), this.getTitle());
        }
        return this.mEntryEvents;
    }

    public boolean snipeCancelled() {
        return this.mCancelSnipeBid != null;
    }

    public Currency getCancelledSnipe() {
        return this.mCancelSnipeBid;
    }

    @Override
    public void cancelSnipe(boolean after_end) {
        this.handleCancel(after_end);
        this.prepareSnipe(Currency.NoValue(), 0);
        this.setInteger("multisnipe_id", null);
        this.saveDB();
    }

    private void handleCancel(boolean after_end) {
        if (this.isSniped()) {
            JConfig.log().logDebug("Cancelling Snipe for: " + this.getTitle() + '(' + this.getIdentifier() + ')');
            this.setLastStatus("Cancelling snipe.");
            if (after_end) {
                this.setBoolean("auto_canceled", true);
                this.mCancelSnipeBid = this.getSnipe().getAmount();
            }
        }
    }

    public void snipeCompleted() {
        this.setSnipedAmount(this.getSnipe().getAmount());
        this.setBid(this.getSnipe().getAmount());
        this.setBidQuantity(this.getSnipe().getQuantity());
        this.getSnipe().delete();
        this.setInteger("snipe_id", null);
        this.mSnipe = null;
        this.setDirty();
        this.setNeedsUpdate();
        this.saveDB();
    }

    private void setSnipedAmount(Currency amount) {
        this.setMonetary("sniped_amount", amount == null ? Currency.NoValue() : amount);
    }

    public void snipeFailed() {
        this.handleCancel(true);
        this.setDirty();
        this.setNeedsUpdate();
        this.saveDB();
    }

    public void update() {
        this.setDate("last_updated_at", new Date());
        try {
            this.getServer().reload(this.getIdentifier());
        }
        catch (Exception e) {
            JConfig.log().handleException("Unexpected exception during auction reload/update.", e);
        }
        try {
            this.updateHighBid();
            this.checkHighBidder();
        }
        catch (Exception e) {
            JConfig.log().handleException("Unexpected exception during high bidder check.", e);
        }
        if (this.isComplete()) {
            this.onComplete();
        } else {
            long now = System.currentTimeMillis() + this.getServer().getServerTimeDelta();
            Date serverTime = new Date(now);
            if (now > this.getEndDate().getTime() && serverTime.after(this.getEndDate())) {
                this.setComplete(true);
                this.setNeedsUpdate();
            }
        }
        this.saveDB();
    }

    private void onComplete() {
        boolean won;
        boolean bl = won = this.isHighBidder() && (!this.isReserve() || this.isReserveMet());
        if (won) {
            JConfig.increment("stats.won");
            MQFactory.getConcrete("won").enqueue(this.getIdentifier());
            if (this.getBoolean("was_sniped")) {
                JConfig.getMetrics().trackEvent("snipe", "won");
            } else {
                JConfig.getMetrics().trackEvent("auction", "won");
            }
        } else {
            MQFactory.getConcrete("notwon").enqueue(this.getIdentifier());
            if (this.getBoolean("was_sniped")) {
                JConfig.getMetrics().trackEvent("snipe", "lost");
            } else if (this.isBidOn()) {
                JConfig.getMetrics().trackEvent("auction", "lost");
            }
        }
        if (this.isSniped()) {
            this.setLastStatus("Cancelling snipe, auction is reported as ended.");
            this.cancelSnipe(true);
        }
    }

    public void prepareSnipe(Currency snipe) {
        this.prepareSnipe(snipe, 1);
    }

    public void prepareSnipe(Currency snipe, int quantity) {
        if (snipe == null || snipe.isNull()) {
            if (this.getSnipe() != null) {
                this.getSnipe().delete();
            }
            this.setInteger("snipe_id", null);
            this.mSnipe = null;
            this.getServer().cancelSnipe(this.getIdentifier());
        } else {
            this.mSnipe = AuctionSnipe.create(snipe, quantity, 0L);
            this.getServer().setSnipe(this.getIdentifier());
        }
        this.setDirty();
        this.saveDB();
        MQFactory.getConcrete("Swing").enqueue("SNIPECHANGED");
    }

    public void refreshSnipe() {
        this.getServer().setSnipe(this.getIdentifier());
    }

    public int bid(Currency bid, int bidQuantity) {
        this.setBid(bid);
        this.setBidQuantity(bidQuantity);
        this.setDate("last_bid_at", new Date(System.currentTimeMillis()));
        JConfig.log().logDebug("Bidding " + bid + " on " + bidQuantity + " item[s] of (" + this.getIdentifier() + ")-" + this.getTitle());
        int rval = this.getServer().bid(this.getIdentifier(), bid, bidQuantity);
        this.saveDB();
        return rval;
    }

    public int buy(int quant) {
        int rval = 15;
        Currency bin = this.getBuyNow();
        if (bin != null && !bin.isNull()) {
            this.setBid(this.getBuyNow());
            this.setBidQuantity(quant);
            this.setDate("last_bid_at", new Date(System.currentTimeMillis()));
            JConfig.log().logDebug("Buying " + quant + " item[s] of (" + this.getIdentifier() + ")-" + this.getTitle());
            rval = this.getServer().buy(this.getIdentifier(), quant);
            if (rval == 16) {
                JConfig.getMetrics().trackEvent("buy", "success");
            } else {
                JConfig.getMetrics().trackEventValue("buy", "fail", Integer.toString(rval));
            }
            this.saveDB();
        }
        return rval;
    }

    public void setNeedsUpdate() {
        this.setDate("last_updated_at", null);
        this.saveDB();
    }

    public Date getLastUpdated() {
        return this.getDate("last_updated_at");
    }

    public String getCategory() {
        String category_id;
        if (this.mCategory == null && (category_id = this.get("category_id")) != null) {
            this.mCategory = Category.findFirstBy("id", category_id);
        }
        if (this.mCategory == null) {
            this.setCategory(!this.isComplete() ? (this.isSeller() ? "selling" : "current") : "complete");
        }
        return this.mCategory != null ? this.mCategory.getName() : null;
    }

    public void setCategory(String newCategory) {
        Category c = Category.findFirstByName(newCategory);
        if (c == null) {
            c = Category.findOrCreateByName(newCategory);
        }
        this.setInteger("category_id", c.getId());
        this.mCategory = c;
        if (this.isComplete()) {
            this.setSticky(true);
        }
        this.saveDB();
    }

    public boolean isSticky() {
        return this.getBoolean("sticky");
    }

    public void setSticky(boolean beSticky) {
        if (beSticky != this.getBoolean("sticky")) {
            this.setBoolean("sticky", beSticky);
            this.saveDB();
        }
    }

    public String getTimeLeft() {
        long rightNow = System.currentTimeMillis();
        long officialDelta = this.getServer().getServerTimeDelta();
        long pageReqTime = this.getServer().getPageRequestTime();
        if (!this.isComplete()) {
            long dateDiff;
            try {
                dateDiff = this.getEndDate().getTime() - (rightNow + officialDelta - pageReqTime);
            }
            catch (Exception endDateException) {
                JConfig.log().handleException("Error getting the end date.", endDateException);
                dateDiff = 0L;
            }
            String mf = TimeLeftBuilder.getTimeLeftString(dateDiff);
            if (mf != null) {
                return mf;
            }
        }
        return endedAuction;
    }

    public String getTitleAndComment() {
        String curComment = this.getComment();
        if (curComment == null) {
            return this.getTitle();
        }
        return this.getTitle() + " (" + curComment + ')';
    }

    public int hashCode() {
        return this.getIdentifier().hashCode() ^ this.getEndDate().hashCode();
    }

    @Override
    public int compareTo(AuctionEntry other) {
        if (other == null) {
            return 1;
        }
        if (other == this) {
            return 0;
        }
        String identifier = this.getIdentifier();
        if (identifier != null && identifier.equals(other.getIdentifier())) {
            return 0;
        }
        Date myEndDate = this.getEndDate();
        Date otherEndDate = other.getEndDate();
        if (myEndDate == null && otherEndDate != null) {
            return 1;
        }
        if (myEndDate != null) {
            if (otherEndDate == null) {
                return -1;
            }
            if (myEndDate.after(otherEndDate)) {
                return 1;
            }
            if (otherEndDate.after(myEndDate)) {
                return -1;
            }
        }
        if (identifier == null) {
            if (other.getIdentifier() != null) {
                return -1;
            }
            return 0;
        }
        if (other.getIdentifier() == null) {
            return 1;
        }
        return this.getIdentifier().compareTo(other.getIdentifier());
    }

    public int getFlags() {
        int r_flags = 1;
        if (this.isFixed()) {
            r_flags = 0;
        }
        if (this.getHighBidder() != null) {
            if (this.isHighBidder()) {
                r_flags = 2;
            } else if (this.isSeller() && this.getNumBidders() > 0 && (!this.isReserve() || this.isReserveMet())) {
                r_flags = 4;
            }
        }
        if (!this.getBuyNow().isNull()) {
            r_flags += 8;
        }
        if (this.isReserve()) {
            r_flags = this.isReserveMet() ? (r_flags += 16) : (r_flags += 32);
        }
        if (this.hasPaypal()) {
            r_flags += 64;
        }
        return r_flags;
    }

    public boolean isNullAuction() {
        return this.get("auction_id") == null;
    }

    public AuctionInfo getAuction() {
        String identifier = this.getString("identifier");
        String auctionId = this.getString("auction_id");
        AuctionInfo info = AuctionInfo.findByIdOrIdentifier(auctionId, identifier);
        if (info == null) {
            if (!this.deleting) {
                this.deleting = true;
                this.delete();
            }
            return sAuction;
        }
        boolean dirty = false;
        if (!this.getDefaultCurrency().equals(info.getDefaultCurrency())) {
            this.setDefaultCurrency(info.getDefaultCurrency());
            dirty = true;
        }
        if (this.getString("identifier") == null) {
            this.setString("identifier", info.getIdentifier());
            dirty = true;
        }
        if (auctionId == null || !auctionId.equals(info.get("id"))) {
            this.setInteger("auction_id", info.getId());
            dirty = true;
        }
        if (dirty) {
            this.saveDB();
        }
        return info;
    }

    @Override
    protected void loadSecondary() {
        AuctionInfo ai = AuctionInfo.findByIdOrIdentifier(this.getAuctionId(), this.getIdentifier());
        if (ai != null) {
            this.setAuctionInfo(ai);
        }
    }

    public void setAuctionInfo(AuctionInfo inAI) {
        if (inAI.getId() != null) {
            this.setSecondary(inAI.getBacking());
            this.setDefaultCurrency(inAI.getDefaultCurrency());
            this.setInteger("auction_id", inAI.getId());
            this.setString("identifier", inAI.getIdentifier());
            this.checkHighBidder();
            this.checkEnded();
            this.saveDB();
        }
    }

    public Currency getCurrentPrice() {
        Currency curPrice = this.getCurBid();
        if (curPrice == null || curPrice.isNull()) {
            return this.getBuyNow();
        }
        return curPrice;
    }

    public Currency getCurrentUSPrice() {
        Currency curPrice = this.getCurBid();
        if (curPrice == null || curPrice.isNull()) {
            return this.getBuyNowUS();
        }
        return this.getUSCurBid();
    }

    public String getSellerName() {
        return this.getAuction().getSellerName();
    }

    @Override
    public Date getStartDate() {
        Date start = super.getStartDate();
        if (start != null) {
            return start;
        }
        return Constants.LONG_AGO;
    }

    public Date getSnipeDate() {
        return new Date(this.getEndDate().getTime() - this.getSnipeTime());
    }

    public String getBrowseableURL() {
        return this.getServer().getBrowsableURLFromItem(this.getIdentifier());
    }

    public void setErrorPage(StringBuffer page) {
        this.mLastErrorPage = page;
    }

    public StringBuffer getErrorPage() {
        return this.mLastErrorPage;
    }

    public Currency getShippingWithInsurance() {
        Currency ship = this.getShipping();
        if (ship == null || ship.isNull()) {
            return Currency.NoValue();
        }
        ship = this.addInsurance(ship);
        return ship;
    }

    private Currency addInsurance(Currency ship) {
        if (this.getInsurance() != null && !this.getInsurance().isNull() && !this.isInsuranceOptional()) {
            try {
                ship = ship.add(this.getInsurance());
            }
            catch (Currency.CurrencyTypeException cte) {
                JConfig.log().handleException("Insurance is somehow a different type than shipping?!?", cte);
            }
        }
        return ship;
    }

    public boolean isShippingOverridden() {
        Currency ship = this.getMonetary("shipping");
        return ship != null && !ship.isNull();
    }

    public boolean isDeleted() {
        return this.getBoolean("deleted", false);
    }

    public void setDeleted() {
        if (!this.isDeleted()) {
            this.setBoolean("deleted", true);
            this.clearInvalid();
        } else {
            this.setComplete(true);
        }
        this.saveDB();
    }

    public void clearDeleted() {
        if (this.isDeleted()) {
            this.setBoolean("deleted", false);
            this.saveDB();
        }
    }

    public String getAuctionId() {
        return this.get("auction_id");
    }

    public void setComplete(boolean complete) {
        this.setBoolean("ended", complete);
        this.saveDB();
    }

    @Override
    public String saveDB() {
        String snipeId;
        String categoryId;
        if (this.isNullAuction()) {
            return null;
        }
        String auctionId = this.getAuctionId();
        if (auctionId != null) {
            this.set("auction_id", auctionId);
        }
        this.getCategory();
        if (this.mCategory != null && (categoryId = this.mCategory.saveDB()) != null) {
            this.set("category_id", categoryId);
        }
        if (this.getSnipe() != null && (snipeId = this.getSnipe().saveDB()) != null) {
            this.set("snipe_id", snipeId);
        }
        if (this.mEntryEvents != null) {
            this.mEntryEvents.save();
        }
        String id = super.saveDB();
        this.set("id", id);
        this.notifyObservers(ObserverMode.AFTER_SAVE);
        return id;
    }

    @Override
    protected Table getDatabase() {
        return EntryTable.getRealDatabase();
    }

    @Override
    public boolean delete() {
        AuctionInfo ai = AuctionInfo.findByIdOrIdentifier(this.getAuctionId(), this.getIdentifier());
        if (ai != null) {
            ai.delete();
        }
        if (this.getSnipe() != null) {
            this.getSnipe().delete();
        }
        return super.delete();
    }

    public Presenter getPresenter() {
        return this.mAuctionEntryPresenter;
    }

    public void setNumBids(int bidCount) {
        AuctionInfo info = AuctionInfo.findByIdOrIdentifier(this.getAuctionId(), this.getIdentifier());
        info.setNumBids(bidCount);
        info.saveDB();
    }

    public boolean isUpdateRequired() {
        return this.getDate("last_updated_at") == null;
    }

    @Override
    public String getUnique() {
        return this.getIdentifier();
    }

    public void setPresenter(Presenter presenter) {
        this.mAuctionEntryPresenter = presenter;
    }

    public static enum ObserverMode {
        AFTER_CREATE,
        AFTER_SAVE;

    }
}

