/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction;

import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.EntryCorral;
import com.jbidwatcher.auction.EntryCorralTemplate;
import com.jbidwatcher.auction.Snipeable;
import com.jbidwatcher.util.Currency;
import com.jbidwatcher.util.db.ActiveRecord;
import com.jbidwatcher.util.db.Table;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiSnipe
extends ActiveRecord {
    private static EntryCorralTemplate corral = null;
    private static Map<Integer, MultiSnipe> singleSource = new HashMap<Integer, MultiSnipe>();
    private static final int HEX_BASE = 16;
    private Color mBackground;
    private static Table sDB = null;

    public synchronized int activeEntries() {
        return this.getAuctionEntriesInThisGroup(corral).size();
    }

    public static void setCorral(EntryCorralTemplate corral) {
        MultiSnipe.corral = corral;
    }

    private void setValues(Color groupColor, Currency snipeValue, long id, boolean subtractShipping) {
        this.mBackground = groupColor;
        this.setString("color", MultiSnipe.makeRGB(groupColor));
        this.setMonetary("default_bid", snipeValue);
        this.setBoolean("subtract_shipping", subtractShipping);
        this.setString("identifier", Long.toString(id));
        String myId = this.saveDB();
        if (myId != null) {
            singleSource.put(this.getId(), this);
        }
    }

    public static String makeRGB(Color groupColor) {
        String blue;
        String green;
        String red = Integer.toString(groupColor.getRed(), 16);
        if (red.length() == 1) {
            red = '0' + red;
        }
        if ((green = Integer.toString(groupColor.getGreen(), 16)).length() == 1) {
            green = '0' + green;
        }
        if ((blue = Integer.toString(groupColor.getBlue(), 16)).length() == 1) {
            blue = '0' + blue;
        }
        return red + green + blue;
    }

    public static Color reverseColor(String colorText) {
        int red = Integer.parseInt(colorText.substring(0, 2), 16);
        int green = Integer.parseInt(colorText.substring(2, 4), 16);
        int blue = Integer.parseInt(colorText.substring(4, 6), 16);
        return new Color(red, green, blue);
    }

    public MultiSnipe() {
    }

    public MultiSnipe(String groupColor, Currency snipeValue, long id, boolean subtractShipping) {
        Color rgb = MultiSnipe.reverseColor(groupColor);
        this.setString("color", groupColor);
        this.setValues(rgb, snipeValue, id, subtractShipping);
    }

    public MultiSnipe(Color groupColor, Currency snipeValue, boolean subtractShipping) {
        this.setValues(groupColor, snipeValue, System.currentTimeMillis(), subtractShipping);
    }

    public Color getColor() {
        if (this.mBackground == null) {
            this.mBackground = MultiSnipe.reverseColor(this.getColorString());
        }
        return this.mBackground;
    }

    public String getColorString() {
        return this.getString("color");
    }

    public Currency getSnipeValue(Currency shipping) {
        if (shipping != null && !shipping.isNull() && this.getBoolean("subtract_shipping")) {
            try {
                return this.getMonetary("default_bid").subtract(shipping);
            }
            catch (Currency.CurrencyTypeException currencyTypeException) {
                // empty catch block
            }
        }
        return this.getMonetary("default_bid");
    }

    public long getIdentifier() {
        return Long.parseLong(this.getString("identifier", "0"));
    }

    public synchronized void add(String identifier) {
        AuctionEntry ae = (AuctionEntry)corral.takeForWrite(identifier);
        try {
            ae.set("multisnipe_id", this.get("id"));
            if (!ae.isSniped()) {
                ae.prepareSnipe(this.getSnipeValue(ae.getShippingWithInsurance()), 1);
            } else {
                ae.saveDB();
            }
        }
        finally {
            corral.release(identifier);
        }
    }

    public synchronized void remove(String identifier) {
        ActiveRecord ae = corral.takeForWrite(identifier);
        try {
            ae.set("multisnipe_id", null);
            ae.saveDB();
        }
        finally {
            corral.release(identifier);
        }
    }

    public synchronized void setWonAuction() {
        List<? extends Snipeable> oldEntries = this.getAuctionEntriesInThisGroup(corral);
        for (Snipeable snipeable : oldEntries) {
            snipeable.cancelSnipe(false);
        }
    }

    public synchronized boolean anyEarlier(Snipeable inEntry) {
        String inIdentifier = inEntry.getIdentifier();
        for (Snipeable snipeable : this.getAuctionEntriesInThisGroup(corral)) {
            if (!snipeable.getEndDate().before(inEntry.getEndDate()) || inIdentifier.equals(snipeable.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSafeMultiSnipe(Snipeable ae1, Snipeable ae2) {
        long end1 = ae1.getEndDate().getTime();
        long end2 = ae2.getEndDate().getTime();
        long snipe1 = end1 - ae1.getSnipeTime();
        long snipe2 = end2 - ae2.getSnipeTime();
        return !(end1 == end2 || end1 < end2 && end1 >= snipe2 || end2 < end1 && end2 >= snipe1);
    }

    public synchronized boolean isSafeToAdd(Snipeable ae) {
        for (Snipeable snipeable : this.getAuctionEntriesInThisGroup(corral)) {
            if (snipeable.getIdentifier().equals(ae.getIdentifier()) || MultiSnipe.isSafeMultiSnipe(snipeable, ae)) continue;
            return false;
        }
        return true;
    }

    private List<? extends Snipeable> getAuctionEntriesInThisGroup(EntryCorralTemplate corral) {
        return ((EntryCorral)corral).getMultisnipedByGroup(this.getString("id"));
    }

    public boolean subtractShipping() {
        return this.getBoolean("subtract_shipping");
    }

    protected static String getTableName() {
        return "multisnipes";
    }

    @Override
    protected Table getDatabase() {
        if (sDB == null) {
            sDB = MultiSnipe.openDB(MultiSnipe.getTableName());
        }
        return sDB;
    }

    private static MultiSnipe cacheResult(MultiSnipe rval) {
        if (rval != null) {
            if (singleSource.get(rval.getId()) != null) {
                rval = singleSource.get(rval.getId());
            } else {
                singleSource.put(rval.getId(), rval);
            }
        }
        return rval;
    }

    public static MultiSnipe findFirstBy(String key, String value) {
        MultiSnipe rval = (MultiSnipe)ActiveRecord.findFirstBy(MultiSnipe.class, key, value);
        return MultiSnipe.cacheResult(rval);
    }

    public static MultiSnipe find(Integer id) {
        MultiSnipe rval = singleSource.get(id);
        if (rval == null) {
            rval = (MultiSnipe)ActiveRecord.findFirstBy(MultiSnipe.class, "id", Integer.toString(id));
            singleSource.put(id, rval);
        }
        return rval;
    }

    public static boolean deleteAll(List<MultiSnipe> toDelete) {
        if (toDelete.isEmpty()) {
            return true;
        }
        String multisnipes = MultiSnipe.makeCommaList(toDelete);
        for (MultiSnipe ms : toDelete) {
            singleSource.remove(ms.getId());
        }
        return toDelete.get(0).getDatabase().deleteBy("id IN (" + multisnipes + ")");
    }
}

