/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.AuctionInfo;
import com.jbidwatcher.auction.Category;
import com.jbidwatcher.auction.EntryCorral;
import com.jbidwatcher.auction.EntryFactory;
import com.jbidwatcher.auction.EntryManager;
import com.jbidwatcher.auction.EntryTable;
import com.jbidwatcher.auction.Resolver;
import com.jbidwatcher.auction.server.AuctionServer;
import com.jbidwatcher.auction.server.AuctionStats;
import com.jbidwatcher.auction.server.ServerMenu;
import com.jbidwatcher.search.SearchManager;
import com.jbidwatcher.util.PauseManager;
import com.jbidwatcher.util.StringTools;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.MessageQueue;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@Singleton
public class AuctionServerManager
implements MessageQueue.Listener,
Resolver {
    private final EntryFactory entryFactory;
    private EntryManager entryManager = null;
    private AuctionServer mServer = null;
    private SearchManager searcher;
    private PauseManager pauseManager;
    private Map<String, Long> timingLog = new HashMap<String, Long>();
    private final Map<String, Long> startLog = new HashMap<String, Long>();
    private Map<String, Long> countLog = new HashMap<String, Long>();
    private Map<String, LinkedList<Long>> last10Log = new HashMap<String, LinkedList<Long>>();

    @Inject
    private AuctionServerManager(EntryManager entryManager, SearchManager searcher, EntryFactory entryFactory, PauseManager pauseManager) {
        this.entryManager = entryManager;
        this.searcher = searcher;
        this.entryFactory = entryFactory;
        this.pauseManager = pauseManager;
        this.entryFactory.setResolver(this);
        MQFactory.getConcrete("auction_manager").registerListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeStart(String blockName) {
        Map<String, Long> map = this.startLog;
        synchronized (map) {
            this.startLog.put(blockName, System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeStop(String blockName) {
        Map<String, Long> map = this.startLog;
        synchronized (map) {
            long now = System.currentTimeMillis();
            long started = this.startLog.get(blockName);
            this.startLog.remove(blockName);
            long accum = this.timingLog.containsKey(blockName) ? this.timingLog.get(blockName) : 0L;
            accum += now - started;
            LinkedList<Long> last10 = this.last10Log.get(blockName);
            if (last10 == null) {
                last10 = new LinkedList();
            }
            last10.add(now - started);
            if (last10.size() > 10) {
                last10.removeFirst();
            }
            this.last10Log.put(blockName, last10);
            this.timingLog.put(blockName, accum);
            this.countLog.put(blockName, this.countLog.containsKey(blockName) ? this.countLog.get(blockName) + 1L : 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeDump(String last10From) {
        Map<String, Long> map = this.startLog;
        synchronized (map) {
            for (Map.Entry<String, Long> segment : this.timingLog.entrySet()) {
                long accum = segment.getValue();
                long count = this.countLog.get(segment.getKey());
                Double avg = (double)accum * 1.0 / ((double)count * 1.0);
                JConfig.log().logDebug(segment.getKey() + ": " + avg + " x " + count + "(" + segment.getValue() + ")");
            }
            JConfig.log().logDebug("Last 10 from " + last10From + ": " + StringTools.comma((List)this.last10Log.get(last10From)));
        }
    }

    public void loadAuctionsFromDB(AuctionServer newServer) {
        MQFactory.getConcrete("splash").enqueue("SET 0");
        this.timeStart("counts");
        EntryCorral.trueUpEntries();
        int entryCount = EntryCorral.count();
        JConfig.getMetrics().trackCustomData("categories", Integer.toString(Category.count(Category.class)));
        JConfig.getMetrics().trackCustomData("entries", Integer.toString(entryCount));
        int auctionCount = AuctionInfo.count();
        int uniqueEntries = EntryCorral.uniqueCount();
        int activeEntries = EntryCorral.activeCount();
        JConfig.getMetrics().trackCustomData("active", Integer.toString(activeEntries));
        JConfig.getMetrics().trackCustomData("sniped", Integer.toString(EntryCorral.snipedCount()));
        int uniqueCount = AuctionInfo.uniqueCount();
        this.timeStop("counts");
        if (JConfig.queryConfiguration("stats.auctions") == null) {
            JConfig.setConfiguration("stats.auctions", Long.toString(uniqueEntries));
        }
        JConfig.log().logMessage("Loading listings from the database (" + activeEntries + "/" + uniqueEntries + "/" + entryCount + " entries, " + uniqueCount + "/" + auctionCount + " auctions)");
        this.timeStart("findAll");
        List<AuctionEntry> entries = EntryCorral.findActive();
        this.timeStop("findAll");
        this.timeStart("findAuctions");
        this.connectEntries(entries);
        this.timeStop("findAuctions");
        final ArrayList sniped = new ArrayList();
        JConfig.log().logMessage("Done with the initial load (got " + entries.size() + " active entries)");
        this.importListingsToUI(newServer, entries, new Report(){

            @Override
            public void report(AuctionEntry ae, int count) {
                MQFactory.getConcrete("splash").enqueue("SET " + count);
                if (!ae.isComplete() && ae.isSniped()) {
                    sniped.add(ae);
                }
            }
        });
        JConfig.log().logDebug("Auction Entries loaded");
        this.spinOffCompletedLoader(newServer);
        JConfig.log().logDebug("Completed loader spun off");
        for (AuctionEntry snipable : sniped) {
            this.timeStart("snipeSetup");
            if (!snipable.isComplete()) {
                snipable.refreshSnipe();
            }
            this.timeStop("snipeSetup");
        }
        JConfig.log().logDebug("Snipes processed");
        this.timeDump("addEntry");
    }

    private void connectEntries(List<AuctionEntry> entries) {
        ArrayList<String> auctionIDs = new ArrayList<String>(entries.size());
        for (AuctionEntry entry : entries) {
            auctionIDs.add(entry.getAuctionId());
        }
        List<AuctionInfo> auctions = AuctionInfo.findAllByIds(auctionIDs);
        HashMap<String, AuctionInfo> joining = new HashMap<String, AuctionInfo>(entries.size());
        for (AuctionInfo info : auctions) {
            joining.put(info.getId().toString(), info);
        }
        for (AuctionEntry entry : entries) {
            AuctionInfo ai = (AuctionInfo)joining.get(entry.getAuctionId());
            entry.setAuctionInfo(ai);
        }
    }

    private void spinOffCompletedLoader(final AuctionServer newServer) {
        Thread completedHandler = new Thread(){

            @Override
            public void run() {
                final MessageQueue tabQ = MQFactory.getConcrete("complete Tab");
                tabQ.enqueue("REPORT Importing completed listings");
                tabQ.enqueue("SHOW");
                AuctionServerManager.this.timeStart("findEnded");
                List<AuctionEntry> entries = EntryCorral.findEnded();
                AuctionServerManager.this.timeStop("findEnded");
                int endedCount = entries.size();
                final double percentStep = (double)endedCount / 100.0;
                final double percentMultiple = 100.0 / (double)endedCount;
                tabQ.enqueue("PROGRESS");
                tabQ.enqueue("PROGRESS Loading...");
                AuctionServerManager.this.importListingsToUI(newServer, entries, new Report(){

                    @Override
                    public void report(AuctionEntry ae, int count) {
                        if (percentStep < 1.0) {
                            tabQ.enqueue("PROGRESS " + Math.round((double)count * percentMultiple));
                        } else if ((long)count % Math.round(percentStep) == 0L) {
                            tabQ.enqueue("PROGRESS " + Math.round((double)count / percentStep));
                        }
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
                tabQ.enqueue("HIDE");
                EntryTable.getRealDatabase().commit();
            }
        };
        Thread lostHandler = new Thread(){

            @Override
            public void run() {
                List<AuctionInfo> lostAuctions = AuctionInfo.findLostAuctions();
                if (lostAuctions != null && !lostAuctions.isEmpty()) {
                    JConfig.log().logMessage("Recovering " + lostAuctions.size() + " listings.");
                    for (AuctionInfo ai : lostAuctions) {
                        AuctionEntry ae = AuctionServerManager.this.entryFactory.constructEntry();
                        ae.setAuctionInfo(ai);
                        ae.setCategory("recovered");
                        ae.setSticky(true);
                        ae.setNeedsUpdate();
                        AuctionServerManager.this.entryManager.addEntry(ae);
                    }
                    MQFactory.getConcrete("recovered Tab").enqueue("REPORT These auctions had lost their settings.");
                    MQFactory.getConcrete("recovered Tab").enqueue("SHOW");
                    EntryTable.getRealDatabase().commit();
                }
            }
        };
        completedHandler.start();
        lostHandler.start();
    }

    private void importListingsToUI(AuctionServer newServer, List<AuctionEntry> entries, Report r) {
        int count = 0;
        for (AuctionEntry ae : entries) {
            this.timeStart("setServer");
            ae.setServer(newServer);
            this.timeStop("setServer");
            if (!ae.hasAuction()) {
                boolean recentlyUpdated;
                JConfig.log().logMessage("We lost the underlying auction for: " + ae.dumpRecord());
                boolean bl = recentlyUpdated = ae.getLastUpdated() != null && ae.getLastUpdated().after(new Date(System.currentTimeMillis() - 3888000000L));
                if (ae.getString("identifier") != null && recentlyUpdated) {
                    JConfig.log().logMessage("Trying to reload auction via its auction identifier.");
                    MQFactory.getConcrete("drop").enqueue(ae.getString("identifier"));
                } else {
                    if (!recentlyUpdated) {
                        JConfig.log().logMessage("Auction entry " + ae.getString("identifier") + " is too old to reload, deleting.");
                    } else {
                        JConfig.log().logMessage("Auction entry id " + ae.getId() + " doesn't have enough detail to reload; deleting.");
                    }
                    this.timeStart("delete");
                    ae.delete();
                    this.timeStop("delete");
                }
            } else {
                this.timeStart("addEntry");
                this.timeStart("addEntry-" + ae.getCategory());
                try {
                    this.entryManager.addEntry(ae);
                }
                catch (Exception e) {
                    String errorMessage = "Failed to add an auction entry";
                    errorMessage = errorMessage + " for item " + ae.getIdentifier() + " (" + ae.getId() + ") ";
                    JConfig.log().handleException(errorMessage, e);
                }
                this.timeStop("addEntry-" + ae.getCategory());
                this.timeStop("addEntry");
            }
            if (r == null) continue;
            r.report(ae, count++);
        }
    }

    @Override
    public void messageAction(Object deQ) {
        String cmd = (String)deQ;
        if (cmd.equals("TIMECHECK")) {
            if (this.pauseManager.isPaused()) {
                return;
            }
            AuctionServer defaultServer = this.getServer();
            defaultServer.reloadTime();
            long servTime = defaultServer.getServerTimeDelta();
            Date now = new Date(System.currentTimeMillis() + servTime);
            MQFactory.getConcrete("Swing").enqueue("Server time is now: " + now);
        }
    }

    public String getDefaultServerTime() {
        AuctionServer defaultServer = this.getServer();
        return defaultServer.getTime();
    }

    public AuctionServer setServer(AuctionServer aucServ) {
        if (this.mServer != null) {
            RuntimeException here = new RuntimeException("Trying to add a server, when we've already got one!");
            JConfig.log().handleException("setServer error!", here);
            return this.mServer;
        }
        this.mServer = aucServ;
        this.mServer.addSearches(this.searcher);
        return this.mServer;
    }

    @Override
    public AuctionServer getServer() {
        return this.mServer;
    }

    public ServerMenu addAuctionServerMenus() {
        return this.mServer.establishMenu();
    }

    public void cancelSearches() {
        this.mServer.cancelSearches();
    }

    public AuctionStats getStats() {
        AuctionStats outStat = new AuctionStats();
        outStat._count = EntryCorral.count();
        outStat._completed = EntryCorral.completedCount();
        outStat._snipes = EntryCorral.snipedCount();
        outStat._nextSnipe = EntryCorral.nextSniped();
        outStat._nextEnd = null;
        outStat._nextUpdate = null;
        return outStat;
    }

    private abstract class Report {
        private Report() {
        }

        public abstract void report(AuctionEntry var1, int var2);
    }
}

