/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction.server.ebay;

import com.jbidwatcher.auction.ItemParser;
import com.jbidwatcher.auction.SpecificAuction;
import com.jbidwatcher.util.Currency;
import com.jbidwatcher.util.Record;
import com.jbidwatcher.util.StringTools;
import com.jbidwatcher.util.TT;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.PlainMessageQueue;
import java.util.Date;

public class ebayAuction2
extends SpecificAuction {
    protected TT T;

    protected ebayAuction2(TT countryProperties) {
        this.T = countryProperties;
    }

    @Override
    public ItemParser.ParseErrors setFields(Record parse, String seller) {
        if (this.setSellerInfo(parse, seller)) {
            return ItemParser.ParseErrors.SELLER_AWAY;
        }
        this.setTitle((String)parse.get("title"));
        if (parse.get("thumbnail_url") != null) {
            this.setThumbnailURL((String)parse.get("thumbnail_url"));
            this.loadThumbnail();
        }
        this.setItemLocation((String)parse.get("location"));
        this.setPaypal(Boolean.parseBoolean((String)parse.get("paypal")));
        this.setFixedPrice(Boolean.parseBoolean((String)parse.get("fixed")));
        if (parse.containsKey("ending_at")) {
            Date endDate = StringTools.figureDate((String)parse.get("ending_at"), this.T.s("ebayServer.itemDateFormat")).getDate();
            this.setEnd(endDate);
        }
        if (parse.containsKey("price.current")) {
            this.setCurBid(Currency.getCurrency((String)parse.get("price.current")));
        }
        if (parse.containsKey("price.current_us")) {
            this.setUSCur(Currency.getCurrency((String)parse.get("price.current_us")));
        }
        if ("true".equals(parse.get("price.minimum"))) {
            this.setMinBid(this.getCurBid());
        }
        if (parse.containsKey("price.bin")) {
            this.setBuyNow(Currency.getCurrency((String)parse.get("price.bin")));
        }
        if (parse.containsKey("price.bin_us")) {
            this.setBuyNowUS(Currency.getCurrency((String)parse.get("price.bin_us")));
        }
        if (parse.containsKey("shipping.shipping")) {
            this.setShipping(Currency.getCurrency((String)parse.get("shipping.shipping")));
        }
        if (parse.containsKey("shipping.insurance")) {
            this.setInsurance(Currency.getCurrency((String)parse.get("shipping.insurance")));
        }
        if (parse.containsKey("shipping.insurance_optional")) {
            this.setInsuranceOptional(Boolean.valueOf((String)parse.get("shipping.insurance_optional")));
        }
        if (parse.containsKey("identifier")) {
            this.setIdentifier((String)parse.get("identifier"));
        }
        if (parse.containsKey("bid_count")) {
            this.setNumBids(Integer.valueOf((String)parse.get("bid_count")));
        }
        if ("true".equals(parse.get("complete"))) {
            this.setEnded(true);
        }
        return ItemParser.ParseErrors.SUCCESS;
    }

    private boolean setSellerInfo(Record parse, String seller) {
        String sellerName = this.handleSellerName(parse, seller);
        if (sellerName == null) {
            return true;
        }
        this.setSellerName(sellerName);
        if (this.mSeller != null) {
            if (parse.containsKey("feedback.feedback")) {
                this.mSeller.setFeedback(Integer.parseInt((String)parse.get("feedback.feedback")));
            }
            if (parse.containsKey("feedback.percentage")) {
                this.mSeller.setPositivePercentage((String)parse.get("feedback.percentage"));
            }
        }
        return false;
    }

    private String handleSellerName(Record parse, String seller) {
        String sellerName = (String)parse.get("seller");
        if (sellerName != null && sellerName.length() == 0) {
            sellerName = seller == null ? "(unknown)" : seller;
        }
        return sellerName;
    }

    private void requestHighBidder() {
        MQFactory.getConcrete("high_bidder").enqueue(this.getIdentifier());
    }

    private void requestEndDate() {
        MQFactory.getConcrete("end_date").enqueue(this.getIdentifier());
    }

    private void loadThumbnail() {
        try {
            if (JConfig.queryConfiguration("show.images", "true").equals("true") && !this.hasNoThumbnail() && !this.hasThumbnail()) {
                ((PlainMessageQueue)MQFactory.getConcrete("thumbnail")).enqueueObject(this);
            }
        }
        catch (Exception e) {
            JConfig.log().handleException("Error handling thumbnail loading", e);
            JConfig.getMetrics().trackEvent("failure", "thumbnail_load");
        }
    }
}

