/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.Category;
import com.jbidwatcher.ui.ActionTriple;
import com.jbidwatcher.ui.JBidContext;
import com.jbidwatcher.ui.JTabManager;
import com.jbidwatcher.ui.ListManager;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.PlainMessageQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;

public class JBidTableContext
extends JBidContext {
    private final ListManager listManager;
    private final JTabManager tabManager;
    private JMenu tabMenu = null;

    public JBidTableContext(JTabManager tabManager, ListManager listManager) {
        this.tabManager = tabManager;
        this.listManager = listManager;
        this.buildMenu(this.localPopup);
    }

    @Override
    protected void DoAction(Object src, String actionString, Object whichAuction) {
        if (actionString.startsWith("BT-")) {
            actionString = actionString.substring(3);
        }
        ((PlainMessageQueue)MQFactory.getConcrete("user")).enqueueObject(new ActionTriple(src, actionString, whichAuction));
    }

    protected void buildMenu(JPopupMenu menu) {
        menu.add(this.makeMenuItem("Snipe")).addActionListener(this);
        menu.add(this.makeMenuItem("Cancel Snipe")).addActionListener(this);
        menu.add(new JPopupMenu.Separator());
        menu.add(this.makeMenuItem("Bid")).addActionListener(this);
        menu.add(this.makeMenuItem("Buy")).addActionListener(this);
        menu.add(new JPopupMenu.Separator());
        if (JConfig.debugging() && JConfig.queryConfiguration("debug.uber", "false").equals("true")) {
            menu.add(this.makeMenuItem("Mark as Won")).addActionListener(this);
            menu.add(new JPopupMenu.Separator());
        }
        menu.add(this.makeMenuItem("Update Auction", "Update")).addActionListener(this);
        menu.add(this.makeMenuItem("Show Information", "Information")).addActionListener(this);
        menu.add(this.makeMenuItem("Show In Browser", "Browse")).addActionListener(this);
        menu.add(new JPopupMenu.Separator());
        menu.add(this.makeMenuItem("Set Shipping", "Shipping")).addActionListener(this);
        menu.add(new JPopupMenu.Separator());
        this.tabMenu = new JMenu("Send To");
        menu.add(this.tabMenu);
        JMenu comment = new JMenu("Comment");
        comment.add(this.makeMenuItem("Add", "Add Comment")).addActionListener(this);
        comment.add(this.makeMenuItem("View", "View Comment")).addActionListener(this);
        comment.add(this.makeMenuItem("Remove", "Remove Comment")).addActionListener(this);
        menu.add(comment);
        JMenu advanced = new JMenu("Advanced");
        advanced.add(this.makeMenuItem("Show Last Error", "ShowError")).addActionListener(this);
        advanced.add(this.makeMenuItem("Mark As Not Ended", "NotEnded")).addActionListener(this);
        if (JConfig.queryConfiguration("my.jbidwatcher.id") != null) {
            advanced.add(this.makeMenuItem("Report a problem with this item", "Report")).addActionListener(this);
        }
        menu.add(advanced);
        menu.add(new JPopupMenu.Separator());
        menu.add(this.makeMenuItem("Delete")).addActionListener(this);
    }

    @Override
    protected void beforePopup(JPopupMenu jp, MouseEvent e) {
        int[] rowList;
        ActionListener tabActions = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent action) {
                String toTab = action.getActionCommand();
                JBidTableContext.this.DoSendTo(toTab);
            }
        };
        super.beforePopup(jp, e);
        if (this.tabMenu != null) {
            this.tabMenu.removeAll();
            JTabbedPane tabbedPane = this.tabManager.getTabs();
            String currentTitle = tabbedPane.getTitleAt(tabbedPane.getSelectedIndex());
            List<String> tabs = this.listManager.allCategories();
            if (tabs == null) {
                this.tabMenu.setEnabled(false);
            } else {
                tabs.remove("selling");
                tabs.remove(currentTitle);
                this.tabMenu.setEnabled(true);
                for (String tab : tabs) {
                    if (tab == null) continue;
                    this.tabMenu.add(this.makeMenuItem(tab)).addActionListener(tabActions);
                }
            }
        }
        Object resolvedObject = this.resolvePoint();
        AuctionEntry ae = null;
        if (resolvedObject != null && resolvedObject instanceof AuctionEntry) {
            ae = (AuctionEntry)resolvedObject;
        }
        if ((rowList = this.getPossibleRows()) != null && rowList.length != 0) {
            if (rowList.length == 1) {
                Object firstSelected = this.getIndexedEntry(rowList[0]);
                if (firstSelected != null && firstSelected instanceof AuctionEntry) {
                    ae = (AuctionEntry)firstSelected;
                }
            } else {
                ae = null;
            }
        }
        this.rename("Multisnipe", "Snipe");
        this.rename("Edit", "Add");
        if (ae != null) {
            if (ae.getComment() == null) {
                this.disable("View");
                this.disable("Remove");
            } else {
                this.rename("Add", "Edit");
            }
            if (!ae.isSniped()) {
                this.disable("Cancel Snipe");
            }
            if (!ae.isComplete()) {
                this.disable("Complete");
                this.disable("Mark As Not Ended");
            } else {
                this.enable("Mark As Not Ended");
            }
            if (ae.isSeller() || ae.isComplete()) {
                this.disable("Buy");
                this.disable("Bid");
                this.disable("Snipe");
            }
            if (ae.isFixed()) {
                this.disable("Bid");
                this.disable("Snipe");
            }
            if (!ae.isFixed() && ae.getBuyNow().isNull()) {
                this.disable("Buy");
            }
        }
        if (rowList != null && rowList.length > 1) {
            this.disable("Bid");
            this.disable("Buy");
            this.disable("Show Last Error");
            this.disable("Set Shipping");
            this.disable("Add");
            this.disable("View");
            this.disable("Remove");
            boolean anySniped = false;
            boolean anyFixed = false;
            boolean anyEnded = false;
            boolean anyCurrent = false;
            for (int aRowList : rowList) {
                Object line = this.getIndexedEntry(aRowList);
                AuctionEntry step = (AuctionEntry)line;
                if (step.isSniped()) {
                    anySniped = true;
                }
                if (step.isFixed()) {
                    anyFixed = true;
                }
                if (step.isComplete()) {
                    anyEnded = true;
                }
                if (step.isComplete()) continue;
                anyCurrent = true;
            }
            if (!anySniped) {
                this.disable("Cancel Snipe");
            }
            if (anyFixed || anyEnded) {
                this.disable("Snipe");
            }
            if (!anyCurrent) {
                this.enable("Complete");
            }
            if (anyEnded) {
                this.enable("Mark As Not Ended");
            } else {
                this.disable("Mark As Not Ended");
            }
            this.rename("Snipe", "Multisnipe");
        }
        if (ae == null || ae.getErrorPage() == null) {
            this.disable("Show Last Error");
        }
    }

    private void DoSendTo(String tab) {
        int[] rowList = this.getPossibleRows();
        if (rowList.length == 0) {
            JOptionPane.showMessageDialog(null, "No auctions selected to move!", "Error moving listings", -1);
            return;
        }
        Category c = Category.findFirstByName(tab);
        if (c == null) {
            JOptionPane.showMessageDialog(null, "Cannot locate that tab, something has gone wrong.\nClose and restart JBidwatcher.", "Error moving listings", -1);
            return;
        }
        ArrayList<AuctionEntry> tempTable = new ArrayList<AuctionEntry>(rowList.length);
        for (int aRowList : rowList) {
            AuctionEntry moveEntry = (AuctionEntry)this.getIndexedEntry(aRowList);
            tempTable.add(moveEntry);
        }
        Object object = tempTable.iterator();
        while (object.hasNext()) {
            AuctionEntry moveEntry = (AuctionEntry)object.next();
            moveEntry.setCategory(tab);
            MQFactory.getConcrete("redraw").enqueue(moveEntry.getIdentifier());
        }
    }
}

