/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.commands;

import com.cyberfox.util.platform.Platform;
import com.github.rjeschke.txtmark.Processor;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.jbidwatcher.auction.AuctionBid;
import com.jbidwatcher.auction.AuctionBuy;
import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.AuctionServerInterface;
import com.jbidwatcher.auction.DeletedEntry;
import com.jbidwatcher.auction.EntryCorral;
import com.jbidwatcher.auction.EntryFactory;
import com.jbidwatcher.auction.EntryInterface;
import com.jbidwatcher.auction.MultiSnipe;
import com.jbidwatcher.auction.MultiSnipeManager;
import com.jbidwatcher.auction.server.AuctionServerManager;
import com.jbidwatcher.my.MyJBidwatcher;
import com.jbidwatcher.scripting.Scripting;
import com.jbidwatcher.search.SearchManager;
import com.jbidwatcher.ui.ActionTriple;
import com.jbidwatcher.ui.AuctionsManager;
import com.jbidwatcher.ui.Clipboard;
import com.jbidwatcher.ui.JBHelp;
import com.jbidwatcher.ui.JBidToolBar;
import com.jbidwatcher.ui.JTabManager;
import com.jbidwatcher.ui.ListManager;
import com.jbidwatcher.ui.MyActionListener;
import com.jbidwatcher.ui.ScriptManager;
import com.jbidwatcher.ui.SearchFrame;
import com.jbidwatcher.ui.SnipeDialog;
import com.jbidwatcher.ui.SubmitLogDialog;
import com.jbidwatcher.ui.commands.FAQCommand;
import com.jbidwatcher.ui.commands.MenuCommand;
import com.jbidwatcher.ui.config.JConfigFrame;
import com.jbidwatcher.ui.myTableCellRenderer;
import com.jbidwatcher.ui.util.JBidFrame;
import com.jbidwatcher.ui.util.JPasteListener;
import com.jbidwatcher.ui.util.OptionUI;
import com.jbidwatcher.util.Currency;
import com.jbidwatcher.util.ErrorMonitor;
import com.jbidwatcher.util.LogProvider;
import com.jbidwatcher.util.PauseManager;
import com.jbidwatcher.util.Record;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.db.Database;
import com.jbidwatcher.util.html.JHTML;
import com.jbidwatcher.util.html.JHTMLOutput;
import com.jbidwatcher.util.queue.AuctionQObject;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.MessageQueue;
import com.jbidwatcher.util.services.ActivityMonitor;
import com.l2fprod.common.swing.JFontChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

@Singleton
public class UserActions
implements MessageQueue.Listener {
    private final JTabManager mTabs;
    private final EntryCorral entryCorral;
    private static SearchFrame _searchFrame = null;
    private final AuctionsManager auctionsManager;
    private final EntryFactory entryFactory;
    private final PauseManager pauseManager;
    private final AuctionServerManager serverManager;
    private final ErrorMonitor monitor;
    private final MultiSnipeManager multisnipeManager;
    private final SearchManager searchManager;
    private final MyJBidwatcher myJBidwatcher;
    private final myTableCellRenderer cellRenderer;
    private final Provider<JConfigFrame> configFrameProvider;
    private OptionUI _oui = new OptionUI();
    private static StringBuffer _colorHelp = null;
    private static StringBuffer _aboutText = null;
    private static StringBuffer _licenseText = null;
    private static StringBuffer _needHelp = null;
    private static StringBuffer _donate = null;
    private boolean _in_deleting = false;
    private ScriptManager mScriptFrame;
    private final JBidToolBar toolBar;
    private final ListManager listManager;
    private final JPasteListener pasteListener;
    public static final String ADD_AUCTION = "ADD ";
    private static final String GET_SERVER_TIME = "GETTIME";
    private static final String SEARCH = "SEARCH";
    public static final String MY_EBAY = "My eBay";
    private static Pattern digitSearch = Pattern.compile("[0-9]+");
    private static final StringBuffer badAbout = new StringBuffer("Error loading About text!  (D'oh!)  Email <a href=\"mailto:cyberfox@jbidwatcher.com\">me</a>!");
    private static final StringBuffer badLicense = new StringBuffer("Error loading License text!  Please visit <a href=\"http://www.jbidwatcher.com/by-nc-sa-amended.shtml\">http://http://www.jbidwatcher.com/by-nc-sa-amended.shtml</a>!");
    private static JFrame aboutFrame = null;
    private static JFrame licenseFrame = null;
    private static JFrame needHelpFrame = null;
    private static JFrame donateFrame = null;
    private static final StringBuffer EMPTY_LOG = new StringBuffer("The log is empty.");
    private static final int DO_COPY_URL = 0;
    private static final int DO_COPY_ID = 1;
    private static final int DO_COPY_DATA = 2;
    private static final StringBuffer badColors = new StringBuffer("Error loading Color help text!  (D'oh!)  Email <a href=\"mailto:cyberfox%40jbidwatcher.com\">me</a>!");
    private static JFrame helpFrame = null;
    private SubmitLogDialog mLogSubmitDialog;

    public void DoFAQ() {
        new FAQCommand().execute();
    }

    @Inject
    public UserActions(EntryCorral corral, JTabManager tabManager, EntryFactory factory, AuctionsManager auctionsManager, AuctionServerManager serverManager, PauseManager pauseManager, ErrorMonitor errorMonitor, MultiSnipeManager multiSnipeManager, SearchManager searchManager, MyJBidwatcher myJBidwatcher, JBidToolBar toolBar, ListManager listManager, myTableCellRenderer cellRenderer, JPasteListener pasteListener, Provider<JConfigFrame> configFrameProvider) {
        this.entryCorral = corral;
        this.mTabs = tabManager;
        this.entryFactory = factory;
        this.auctionsManager = auctionsManager;
        this.serverManager = serverManager;
        this.pauseManager = pauseManager;
        this.monitor = errorMonitor;
        this.multisnipeManager = multiSnipeManager;
        this.searchManager = searchManager;
        this.myJBidwatcher = myJBidwatcher;
        this.toolBar = toolBar;
        this.listManager = listManager;
        this.cellRenderer = cellRenderer;
        this.configFrameProvider = configFrameProvider;
        this.pasteListener = pasteListener;
    }

    @Override
    public void messageAction(Object deQ) {
        if (deQ instanceof String) {
            this.handleStringMessage(deQ);
        }
        if (deQ instanceof ActionTriple) {
            ActionTriple action = (ActionTriple)deQ;
            this.DoAction(action.getSource(), action.getCommand(), action.getAuction());
        }
    }

    private void handleStringMessage(Object deQ) {
        String commandStr = (String)deQ;
        Scripting.rubyMethod("handle_action", commandStr, this, null, null);
        if (commandStr.startsWith(ADD_AUCTION)) {
            String auctionSource = commandStr.substring(ADD_AUCTION.length());
            this.cmdAddAuction(auctionSource);
        } else if (commandStr.equals(GET_SERVER_TIME)) {
            if (JConfig.queryConfiguration("timesync.enabled", "true").equals("true")) {
                MQFactory.getConcrete("auction_manager").enqueue("TIMECHECK");
            }
        } else if (commandStr.equals(SEARCH)) {
            this.DoSearch();
        } else if (commandStr.equals("About JBidwatcher")) {
            this.DoAbout();
        } else {
            JConfig.log().logDebug("Received unrecognized 'user' message: " + commandStr);
        }
    }

    private void cmdAddAuction(String auctionSource) {
        if (auctionSource.regionMatches(true, 0, "<html>", 0, 6)) {
            auctionSource = JHTML.getFirstContent(auctionSource);
        }
        auctionSource = auctionSource.trim();
        String id = this.serverManager.getServer().stripId(auctionSource);
        if (EntryFactory.isInvalid(true, id)) {
            AuctionEntry found = EntryCorral.findByIdentifier(id);
            if (found != null) {
                JConfig.log().logMessage("Found auction " + id + " in category " + found.getCategory());
                this.mTabs.showEntry(found);
            }
        } else {
            this.entryFactory.conditionallyAddEntry(true, id, this.mTabs.getCurrentTableTitle());
        }
    }

    @MenuCommand(action="Toolbar")
    public void DoHideShowToolbar() {
        MQFactory.getConcrete("Swing").enqueue("TOOLBAR");
    }

    public void DoSearch() {
        if (_searchFrame == null) {
            _searchFrame = new SearchFrame(this.searchManager, this.mTabs, this.listManager, this.pasteListener);
        } else {
            _searchFrame.show();
        }
    }

    public void DoScripting() {
        if (JConfig.scriptingEnabled()) {
            if (this.mScriptFrame == null) {
                this.mScriptFrame = new ScriptManager();
            }
            MQFactory.getConcrete("scripting").enqueue("SHOW");
        }
    }

    @MenuCommand(action="Font")
    public void DoChooseFont() {
        JFontChooser jfc = new JFontChooser();
        jfc.setSelectedFont(this.cellRenderer.getDefaultFont());
        Font chosen = jfc.showFontDialog(null, "Please choose the default font for the auction table");
        if (chosen != null) {
            myTableCellRenderer.setDefaultFont(chosen);
            MQFactory.getConcrete("redraw").enqueue("#font");
        }
    }

    @MenuCommand(params=2, action="ShowError")
    public void DoShowLastError(Component src, AuctionEntry passedAE) {
        AuctionEntry ae = passedAE;
        int[] rowList = this.mTabs.getPossibleRows();
        if (ae == null && rowList.length == 0 || rowList.length > 1) {
            JOptionPane.showMessageDialog(src, "You must select a single auction to view the error page for.", "Error view", -1);
            return;
        }
        if (ae == null) {
            ae = (AuctionEntry)this.mTabs.getIndexedEntry(rowList[0]);
        }
        StringBuffer wholeStatus = ae.getErrorPage();
        Dimension statusBox = new Dimension(756, 444);
        this._oui.showHTMLDisplay(new JHTMLOutput("Error Page", wholeStatus).getStringBuffer(), statusBox, "Error Page...");
    }

    @MenuCommand(params=-2, action="Mark as Won")
    public void DoDebugWin(AuctionEntry ae) {
        MQFactory.getConcrete("won").enqueue(ae.getIdentifier());
    }

    @MenuCommand(params=2)
    public void DoDelete(Component src, AuctionEntry passedAE) {
        Dimension statusBox;
        AuctionEntry ae = passedAE;
        if (this._in_deleting) {
            return;
        }
        this._in_deleting = true;
        StringBuffer wholeDelete = new StringBuffer();
        int[] rowList = this.mTabs.getPossibleRows();
        if (ae == null && rowList.length == 0) {
            this._in_deleting = false;
            JOptionPane.showMessageDialog(src, "You must select an auction to delete.", "Delete error", -1);
            return;
        }
        if (JConfig.queryConfiguration("prompt.hide_delete_confirm", "false").equals("true")) {
            this.silentDelete(ae, rowList);
            this._in_deleting = false;
            return;
        }
        ArrayList<AuctionEntry> deleteIds = new ArrayList<AuctionEntry>();
        if (rowList.length != 0 && rowList.length != 1) {
            wholeDelete.append("<table border=0 spacing=0 width=\"100%\">");
            wholeDelete.append("<tr><td><u><b>Item Number</b></u></td><td><u><b>Title</b></u></td></tr>");
            for (int i = 0; i < rowList.length; ++i) {
                AuctionEntry tempEntry = (AuctionEntry)this.mTabs.getIndexedEntry(rowList[i]);
                deleteIds.add(tempEntry);
                String color = "FFFFFF";
                if (i % 2 == 1) {
                    color = "C0C0C0";
                }
                wholeDelete.append("<tr><td bgcolor=#").append(color).append("><b>").append(tempEntry.getIdentifier()).append("</b></td><td bgcolor=#").append(color).append('>').append(tempEntry.getTitle()).append("</td></tr>");
            }
            wholeDelete.append("</table>");
            statusBox = new Dimension(756, Math.min(372, rowList.length * 27 + 90));
        } else {
            if (rowList.length == 1) {
                ae = (AuctionEntry)this.mTabs.getIndexedEntry(rowList[0]);
            }
            if (ae == null) {
                throw new IllegalArgumentException();
            }
            wholeDelete.append("<table border=0 spacing=0 width=\"100%\"><tr><td><b>").append(ae.getIdentifier()).append("</b></td><td>").append(ae.getTitle()).append("</td></tr></table>");
            deleteIds.add(ae);
            statusBox = new Dimension(756, 115);
        }
        ArrayList<String> buttons = new ArrayList<String>();
        buttons.add("TEXT Are you sure you want to delete these auctions: ");
        buttons.add("Yes");
        buttons.add("TEXT    ");
        buttons.add("No, Cancel");
        buttons.add("CHECK Don't prompt in the future.");
        MyActionListener al = new MyActionListener(){
            boolean mDontPrompt = false;

            @Override
            public void actionPerformed(ActionEvent listen_ae) {
                String actionString = listen_ae.getActionCommand();
                if (actionString.equals("Don't prompt in the future.")) {
                    JCheckBox jch = (JCheckBox)listen_ae.getSource();
                    this.mDontPrompt = jch.isSelected();
                } else {
                    if (actionString.equals("Yes")) {
                        for (EntryInterface entry : this.mEntries) {
                            entry.cancelSnipe(false);
                            MQFactory.getConcrete("delete").enqueue(entry.getIdentifier());
                            DeletedEntry.create(entry.getIdentifier());
                        }
                        EntryCorral.deleteAll(this.mEntries);
                        if (this.mDontPrompt) {
                            JConfig.setConfiguration("prompt.hide_delete_confirm", "true");
                        }
                    }
                    this.m_within.dispose();
                    this.m_within = null;
                }
            }
        };
        al.setEntries(deleteIds);
        JFrame newFrame = this._oui.showChoiceTextDisplay(new JHTMLOutput("Deleting", wholeDelete).getStringBuffer(), statusBox, "Deleting...", buttons, "Items to delete...", al);
        al.setFrame(newFrame);
        this._in_deleting = false;
    }

    private void silentDelete(AuctionEntry ae, int[] rowList) {
        final ArrayList<AuctionEntry> entries = new ArrayList<AuctionEntry>();
        if (rowList.length != 0 && rowList.length != 1) {
            for (int aRowList : rowList) {
                AuctionEntry tempEntry = (AuctionEntry)this.mTabs.getIndexedEntry(aRowList);
                entries.add(tempEntry);
            }
        } else {
            if (rowList.length == 1) {
                ae = (AuctionEntry)this.mTabs.getIndexedEntry(rowList[0]);
            }
            if (ae != null) {
                entries.add(ae);
            }
        }
        Thread deleteThread = new Thread(new Runnable(){

            @Override
            public void run() {
                String logMsg = "Deleting " + entries.size() + " entries";
                JConfig.log().logDebug(logMsg);
                Thread.currentThread().setName(logMsg);
                for (AuctionEntry deleteId : entries) {
                    UserActions.this.auctionsManager.delEntry(deleteId);
                }
            }
        });
        deleteThread.start();
    }

    public void DoConfigure() {
        ((JConfigFrame)this.configFrameProvider.get()).show();
    }

    @MenuCommand(action="Paste")
    public void DoPasteFromClipboard() {
        String auctionId;
        String original = auctionId = Clipboard.getClipboardString();
        if (auctionId.charAt(0) == '<' && ((auctionId = JHTML.getFirstContent(auctionId)).charAt(0) < '0' || auctionId.charAt(0) > '9')) {
            Matcher digits = digitSearch.matcher(auctionId);
            if (digits.find()) {
                auctionId = digits.group();
            }
            if (auctionId == null) {
                JConfig.log().logDebug("Failed to paste auction id: " + original);
            }
        }
        if (auctionId != null) {
            MQFactory.getConcrete("user").enqueue(ADD_AUCTION + auctionId);
        }
    }

    private String makeUsefulString(AuctionEntry ae) {
        String result;
        Currency currentPrice = ae.getCurrentPrice();
        if (ae.isSeller()) {
            result = ae.getHighBidder();
            if (result == null) {
                result = "";
            }
        } else {
            result = ae.getSellerName();
        }
        result = result + "  " + ae.getIdentifier() + "  " + currentPrice + " (" + ae.getTitle() + ")\n";
        return result;
    }

    @MenuCommand(params=2)
    public void DoCopy(Component src, AuctionEntry ae) {
        this.DoCopySomething(src, ae, 2, "No auctions selected to copy!", "");
    }

    @MenuCommand(params=1, action="Add New")
    public void DoAdd(Component src) {
        String keyModifier = Platform.isMac() ? "Cmd" : "Ctrl";
        String prompt = "<html><body>Enter the auction number to add <small>(Press " + keyModifier + "-V to paste)</small></body></html>";
        String endResult = this.promptString(src, prompt, "Adding");
        if (endResult == null) {
            return;
        }
        endResult = endResult.trim();
        MQFactory.getConcrete("user").enqueue(ADD_AUCTION + endResult);
    }

    private Record getFirstResult(ResultSet rs) throws SQLException {
        Record rval = new Record();
        ResultSetMetaData rsm = rs.getMetaData();
        if (rsm != null && rs.next()) {
            for (int i = 1; i <= rsm.getColumnCount(); ++i) {
                rval.put(rs.getMetaData().getColumnName(i).toLowerCase(), rs.getString(i));
            }
        }
        rs.close();
        return rval;
    }

    public void DoSQL(Component src) {
        String sql = this.promptString(src, "Enter the command to run", "Executing");
        if (sql == null || sql.length() == 0) {
            return;
        }
        sql = sql.trim();
        try {
            Database db = new Database(null);
            Statement s = db.getStatement();
            boolean resultType = db.executeCanonicalizedSQL(s, sql);
            if (resultType) {
                ResultSet rs = s.getResultSet();
                Record r = this.getFirstResult(rs);
                MQFactory.getConcrete("Swing").enqueue("ALERT " + r.dump());
            } else {
                MQFactory.getConcrete("Swing").enqueue("ALERT " + s.getUpdateCount());
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private String promptString(Component src, String prePrompt, String preTitle) {
        return this._oui.promptString(src, prePrompt, preTitle, "");
    }

    private String promptString(Component src, String prePrompt, String preTitle, String preFill) {
        return this._oui.promptString(src, prePrompt, preTitle, preFill);
    }

    @MenuCommand(params=2, action="Cancel Snipe")
    public void CancelSnipe(Component src, AuctionEntry ae) {
        int[] rowList = this.mTabs.getPossibleRows();
        int len = rowList.length;
        if (ae == null && len == 0) {
            JOptionPane.showMessageDialog(src, "You must select an auction to be able to cancel snipes.", "Snipe-cancel error", -1);
            return;
        }
        if (len != 0) {
            for (int aRowList : rowList) {
                AuctionEntry tempEntry = (AuctionEntry)this.mTabs.getIndexedEntry(aRowList);
                if (tempEntry.isSniped()) {
                    JConfig.getMetrics().trackEvent("snipe", "cancel");
                }
                tempEntry.cancelSnipe(false);
                MQFactory.getConcrete("redraw").enqueue(tempEntry.getIdentifier());
            }
        } else {
            if (ae.isSniped()) {
                JConfig.getMetrics().trackEvent("snipe", "cancel");
            }
            ae.cancelSnipe(false);
            MQFactory.getConcrete("redraw").enqueue(ae.getIdentifier());
        }
    }

    @MenuCommand(params=2, action="Show Time Info")
    public void DoShowTime(Component src, AuctionEntry ae) {
        AuctionServerInterface as = this.serverManager.getServer();
        if (ae != null) {
            as = ae.getServer();
        }
        String prompt = "<html><body><table>";
        prompt = prompt + "<tr><td><b>Current time:</b></td><td>" + new Date() + "</td></tr>";
        prompt = prompt + "<tr><td><b>Page load time:</td><td>" + as.getPageRequestTime() + "</td></tr>";
        prompt = prompt + "<tr><td><b>eBay time delta:</td><td>" + as.getServerTimeDelta() + "</td></tr>";
        prompt = prompt + "</table></body></html>";
        JOptionPane jop = new JOptionPane(prompt, 1);
        JDialog jdTime = jop.createDialog(src, "Auction Server Time Information");
        jdTime.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent ev) {
                ev.getWindow().toFront();
            }
        });
        jdTime.setVisible(true);
    }

    @MenuCommand(params=2)
    public void DoInformation(Component src, EntryInterface ae) {
        int[] rowList = this.mTabs.getPossibleRows();
        int len = rowList.length;
        if (ae == null && len == 0) {
            JOptionPane.showMessageDialog(src, "Must select an auction to get information about.", "Information error", -1);
            return;
        }
        this.showComplexInformation(rowList);
    }

    private int getInteger(String cfgValue, int defaultValue) {
        int rval = defaultValue;
        try {
            String prop = JConfig.queryDisplayProperty(cfgValue);
            if (prop != null) {
                rval = Integer.parseInt(prop);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rval;
    }

    private void showComplexInformation(int[] rowList) {
        StringBuffer prompt = new StringBuffer();
        for (int aRowList : rowList) {
            AuctionEntry stepAE = (AuctionEntry)this.mTabs.getIndexedEntry(aRowList);
            prompt.append(stepAE.getPresenter().buildInfo(true)).append("<hr>");
        }
        int width = this.getInteger("info.width", 620);
        int height = this.getInteger("info.height", 440);
        Dimension statusBox = new Dimension(width, height);
        ArrayList<String> buttons = new ArrayList<String>(2);
        buttons.add("Continue");
        MyActionListener al = new MyActionListener(){

            @Override
            public void actionPerformed(ActionEvent listen_ae) {
                this.m_within.dispose();
                this.m_within = null;
            }
        };
        final JFrame newFrame = this._oui.showChoiceTextDisplay(new JHTMLOutput("Information", prompt).getStringBuffer(), statusBox, "Information...", buttons, null, al);
        newFrame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JConfig.setDisplayConfiguration("info.width", Integer.toString(newFrame.getWidth()));
                JConfig.setDisplayConfiguration("info.height", Integer.toString(newFrame.getHeight()));
            }
        });
        al.setFrame(newFrame);
    }

    private boolean dangerousSnipeWarning(Component src) {
        String warning = "Two or more of your auctions complete within the snipe time of\nanother.  What will happen is that if the first of those is bid on,\nthe second WILL be bid on as well.  This is very unlikely to be what\nyou want.  It is strongly recommended that you cancel the multisnipe\nand check the end times of your auctions, only selecting auctions\nwhich end more than your snipe timer seconds apart.";
        Object[] options = new Object[]{"Cancel", "Proceed"};
        int choiceResult = JOptionPane.showOptionDialog(src, warning, "Dangerous Multisnipe", -1, 2, null, options, options[0]);
        return choiceResult == 0 || choiceResult == -1;
    }

    private boolean checkIfDangerousMultiSnipe(Component src, int[] rowList, MultiSnipe ms) {
        boolean foundDangerousSnipe = false;
        for (int i = 0; i < rowList.length && !foundDangerousSnipe; ++i) {
            AuctionEntry ae1 = (AuctionEntry)this.mTabs.getIndexedEntry(rowList[i]);
            if (ms != null && !ms.isSafeToAdd(ae1)) {
                foundDangerousSnipe = true;
            }
            for (int j = i + 1; j < rowList.length && !foundDangerousSnipe; ++j) {
                AuctionEntry ae2 = (AuctionEntry)this.mTabs.getIndexedEntry(rowList[j]);
                if (MultiSnipe.isSafeMultiSnipe(ae1, ae2)) continue;
                foundDangerousSnipe = true;
            }
        }
        return foundDangerousSnipe && this.dangerousSnipeWarning(src);
    }

    @MenuCommand(params=1)
    public void DoMultipleSnipe(Component src) {
        if (!JConfig.isPrerelease("2.99pre5")) {
            // empty if block
        }
        JOptionPane.showMessageDialog(src, "Creating new multi-snipes is disabled in this pre-release, as the underlying high-bidder detection code isn't certain to work.", "MultiSniping Disabled", 2);
    }

    private String genBidSnipeHTML(AuctionEntry ae, Currency minBid) {
        String highBidder;
        String prompt = "<html><body><table>";
        prompt = prompt + "<tr><td>Title:</td><td>" + ae.getTitle() + "</td></tr>";
        prompt = prompt + "<tr><td>Current bid:</td><td>" + ae.getCurBid() + "</td></tr>";
        if (ae.getShipping() != null && !ae.getShipping().isNull()) {
            prompt = prompt + "<tr><td>Shipping:</td><td>" + ae.getShipping() + "</td></tr>";
        }
        if ((highBidder = ae.getHighBidder()) == null || highBidder.equals("null")) {
            highBidder = "(n/a)";
        }
        prompt = prompt + "<tr><td>High bidder:</td><td>" + highBidder + "</td></tr>";
        prompt = prompt + "<tr><td>Seller:</td><td>" + ae.getSellerName() + "</td></tr>";
        prompt = prompt + "</table>";
        prompt = minBid != null ? prompt + "Minimum legal bid is " + minBid + "<br>" : prompt + "Cannot calculate minimum legal bid for this currency.<br>";
        prompt = prompt + "<i>Do not enter any punctuation or currency symbols<br>other than the optional decimal point.</i><br>";
        return prompt;
    }

    @MenuCommand(params=2)
    public void DoSnipe(Component src, AuctionEntry passedAE) {
        Currency minimumNextBid;
        AuctionEntry ae = passedAE;
        int[] rowList = this.mTabs.getPossibleRows();
        if (rowList.length > 1) {
            this.DoMultipleSnipe(src);
            return;
        }
        if (rowList.length == 1) {
            ae = (AuctionEntry)this.mTabs.getIndexedEntry(rowList[0]);
        }
        if (ae == null) {
            JOptionPane.showMessageDialog(src, "You have not chosen an auction to snipe on!", "Snipe error", -1);
            return;
        }
        if (ae.getServer().isDefaultUser()) {
            JOptionPane.showMessageDialog(src, "You cannot snipe on an auction without first entering your\nuser account information on the " + ae.getServer().getName() + " configuration tab.", "No auction account error", -1);
            return;
        }
        if (ae.isComplete()) {
            JOptionPane.showMessageDialog(src, "You cannot place a snipe on an ended auction", "Snipe error", -1);
            return;
        }
        try {
            minimumNextBid = ae.getCurBid().add(ae.getServer().getMinimumBidIncrement(ae.getCurBid(), ae.getNumBidders()));
        }
        catch (Currency.CurrencyTypeException cte) {
            minimumNextBid = null;
        }
        SnipeDialog sd = this.showSnipeDialog(ae, minimumNextBid);
        if (sd.isCancelled() || sd.getAmount().length() == 0) {
            return;
        }
        String snipeAmount = sd.getAmount();
        try {
            Currency shipping;
            Currency bidAmount = Currency.getCurrency(ae.getCurBid().fullCurrencyName(), snipeAmount);
            if (sd.subtractShipping() && (shipping = ae.getShippingWithInsurance()) != null && !shipping.isNull()) {
                bidAmount = bidAmount.subtract(shipping);
            }
            boolean wasSniped = ae.isSniped();
            ae.prepareSnipe(bidAmount);
            if (wasSniped) {
                JConfig.getMetrics().trackEvent("snipe", "changed");
            } else {
                JConfig.getMetrics().trackEvent("snipe", "new");
            }
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(src, "You have entered a bad price for your snipe.\n" + snipeAmount + " is not a valid snipe.\n" + "Punctuation (other than a decimal point) and currency symbols are not legal.", "Bad snipe value", -1);
            return;
        }
        catch (Currency.CurrencyTypeException e) {
            JConfig.log().handleException("Couldn't subtract shipping from bid amount.", e);
            return;
        }
        MQFactory.getConcrete("redraw").enqueue(ae.getIdentifier());
        this._oui.promptWithCheckbox(src, "Sniped for: " + ae.getSnipeAmount(), "Snipe Alert", "message.sniped", -1, 0);
    }

    public SnipeDialog showSnipeDialog(AuctionEntry ae, Currency minimumNextBid) {
        String prompt = this.genBidSnipeHTML(ae, minimumNextBid);
        prompt = prompt + "</body></html>";
        String previous = "";
        if (ae.isSniped()) {
            previous = ae.getSnipeAmount().getValueString();
        }
        SnipeDialog sd = new SnipeDialog(previous);
        sd.clear();
        sd.setPrompt(prompt);
        sd.pack();
        Rectangle rec = OptionUI.findCenterBounds(sd.getPreferredSize());
        sd.setLocation(rec.x, rec.y);
        sd.setVisible(true);
        return sd;
    }

    @MenuCommand(params=2)
    public void DoShipping(Component src, AuctionEntry ae) {
        Currency shippingAmount;
        if (ae == null) {
            JOptionPane.showMessageDialog(src, "You have not chosen an auction to set the shipping for!", "Shipping-set error", -1);
            return;
        }
        String prompt = "<html><body>" + ae.getPresenter().buildInfo(false);
        String endResult = this.promptString(src, prompt = prompt + "<br><b>How much is shipping?</b></body></html>", "Shipping");
        if (endResult == null) {
            return;
        }
        try {
            if (endResult != null) {
                endResult = endResult.replace(',', '.');
            }
            shippingAmount = Currency.getCurrency(ae.getCurrentPrice().fullCurrencyName(), endResult);
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(src, "You have entered a bad shipping amount.\n" + endResult + " is not a valid shipping cost.\n" + "Punctuation (other than a decimal point) and currency symbols are not legal.\n" + "The currency used is always the same as the auction.", "Bad shipping value", -1);
            return;
        }
        if (shippingAmount != null) {
            ae.setShipping(shippingAmount);
            MQFactory.getConcrete("redraw").enqueue(ae.getIdentifier());
        }
    }

    private boolean anyBiddingErrors(Component src, AuctionEntry ae) {
        if (ae == null) {
            JOptionPane.showMessageDialog(src, "You have not chosen an auction to bid on!", "Bid error", -1);
            return true;
        }
        if (ae.getServer().isDefaultUser()) {
            JOptionPane.showMessageDialog(src, "You cannot bid on an auction without first entering your\nuser account information on the " + ae.getServer().getName() + " configuration tab.", "No auction account error", -1);
            return true;
        }
        if (ae.isComplete()) {
            JOptionPane.showMessageDialog(src, "You cannot place a bid on an ended auction", "Bid error", -1);
            return true;
        }
        return false;
    }

    @MenuCommand(params=2)
    public void DoBuy(Component src, AuctionEntry ae) {
        if (this.anyBiddingErrors(src, ae)) {
            return;
        }
        int endResult = this._oui.promptWithCheckbox(src, "This will buy the item outright at the price of " + ae.getBuyNow() + ".\nIs this what you want?", "Buy Item", "prompt.bin_confirm");
        if (endResult != 2 && endResult != -1) {
            MQFactory.getConcrete(ae.getServer().getFriendlyName()).enqueueBean(new AuctionQObject(5, new AuctionBuy(ae, Currency.NoValue(), 1), "none"));
        }
    }

    @MenuCommand(params=2)
    public void DoBid(Component src, AuctionEntry ae) {
        Currency bidAmount;
        Currency minimumNextBid;
        if (this.anyBiddingErrors(src, ae)) {
            return;
        }
        try {
            minimumNextBid = ae.getCurBid().add(ae.getServer().getMinimumBidIncrement(ae.getCurBid(), ae.getNumBidders()));
        }
        catch (Currency.CurrencyTypeException cte) {
            minimumNextBid = null;
        }
        String prompt = this.genBidSnipeHTML(ae, minimumNextBid);
        prompt = prompt + "How much do you wish to bid?</body></html>";
        String endResult = minimumNextBid != null ? this.promptString(src, prompt, "Bidding", Float.toString((float)minimumNextBid.getValue())) : this.promptString(src, prompt, "Bidding");
        if (endResult == null) {
            return;
        }
        try {
            if (endResult != null) {
                endResult = endResult.replace(',', '.');
            }
            bidAmount = Currency.getCurrency(ae.getCurBid().fullCurrencyName(), endResult);
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(src, "You have entered a bad price for your bid.\n" + endResult + " is not a valid bid.\n" + "Punctuation (other than a decimal point) and currency symbols are not legal.", "Bad bid value", -1);
            return;
        }
        MQFactory.getConcrete(ae.getServer().getFriendlyName()).enqueueBean(new AuctionQObject(5, new AuctionBid(ae, bidAmount), "none"));
        this.entryCorral.put(ae);
    }

    @MenuCommand(params=2, action="Browse")
    public void DoShowInBrowser(Component src, AuctionEntry inAuction) {
        AuctionEntry ae = inAuction;
        int[] rowList = this.mTabs.getPossibleRows();
        if (rowList.length != 0) {
            ae = (AuctionEntry)this.mTabs.getIndexedEntry(rowList[0]);
        } else if (ae == null) {
            JOptionPane.showMessageDialog(src, "Cannot launch browser from menu, you must select an auction.", "Menu Error", -1);
            return;
        }
        this.showInBrowser(ae);
    }

    public void showInBrowser(AuctionEntry inEntry) {
        String browseTo = inEntry.getBrowseableURL();
        JConfig.getMetrics().trackEvent("browse", "auction");
        MQFactory.getConcrete("browse").enqueue(browseTo);
    }

    @MenuCommand(params=-2, action="Remove Comment")
    public void DoDeleteComment(AuctionEntry ae) {
        if (ae == null) {
            JConfig.log().logMessage("Auction selected to delete comment from is null, unexpected error!");
            return;
        }
        ae.setComment("");
        MQFactory.getConcrete("redraw").enqueue(ae.getIdentifier());
    }

    @MenuCommand(params=2, action="Add Comment")
    public void DoComment(Component src, AuctionEntry inAuction) {
        String endResult;
        if (inAuction == null) {
            JConfig.log().logMessage("Auction selected to comment on is null, unexpected error!");
            return;
        }
        String curComment = inAuction.getComment();
        if (curComment == null) {
            curComment = "";
        }
        if ((endResult = this.promptString(src, "Enter a comment for: " + inAuction.getTitle(), "Commenting", curComment)) == null) {
            return;
        }
        inAuction.setComment(endResult);
        MQFactory.getConcrete("redraw").enqueue(inAuction.getIdentifier());
    }

    @MenuCommand(params=2, action="View Comment")
    public void DoShowComment(Component src, AuctionEntry inAuction) {
        if (inAuction == null) {
            JConfig.log().logMessage("Can't show comments from menu items yet.");
            return;
        }
        JOptionPane.showMessageDialog(src, inAuction.getComment(), "Comment", -1);
    }

    public void DoUpdateAll() {
        EntryCorral.forceUpdateActive();
        this.entryCorral.clear();
    }

    @MenuCommand(params=1)
    public void DoStopUpdating(Component src) {
        int endResult = this._oui.promptWithCheckbox(src, "This will terminate all searches, as well as\nall updates that are currently pending.\n\nStop all searches?", "Stop updating/searching", "prompt.search_stop");
        if (endResult != 2 && endResult != -1) {
            this.serverManager.cancelSearches();
            MQFactory.getConcrete("drop").clear();
            this.pauseManager.pause();
        }
    }

    @MenuCommand(params=2)
    public void DoUpdate(Component src, AuctionEntry inAuction) {
        int[] rowList = this.mTabs.getPossibleRows();
        if (rowList.length != 0) {
            for (int aRowList : rowList) {
                AuctionEntry tempEntry = (AuctionEntry)this.mTabs.getIndexedEntry(aRowList);
                tempEntry.setNeedsUpdate();
            }
        } else if (inAuction == null) {
            JOptionPane.showMessageDialog(src, "No auction selected to update.", "No auction to update", 1);
        } else {
            inAuction.setNeedsUpdate();
        }
    }

    @MenuCommand(params=-2, action="NotEnded")
    public void DoSetNotEnded(AuctionEntry whichAuction) {
        int[] rowList = this.mTabs.getPossibleRows();
        if (rowList.length != 0) {
            for (int aRowList : rowList) {
                AuctionEntry tempEntry = (AuctionEntry)this.mTabs.getIndexedEntry(aRowList);
                tempEntry.setComplete(false);
                tempEntry.setNeedsUpdate();
            }
        } else {
            whichAuction.setComplete(false);
            whichAuction.setNeedsUpdate();
        }
    }

    @MenuCommand(action="Resync")
    public void DoResetServerTime() {
        MQFactory.getConcrete("user").enqueue(GET_SERVER_TIME);
    }

    public void DoAbout() {
        if (aboutFrame == null) {
            Dimension aboutBoxSize = new Dimension(495, 245);
            if (_aboutText == null) {
                _aboutText = JBHelp.loadHelp("/help/about.jbh", "About JBidwatcher...");
            }
            aboutFrame = this._oui.showHTMLDisplay(_aboutText != null ? _aboutText : badAbout, aboutBoxSize, "About JBidwatcher");
        } else {
            aboutFrame.setVisible(true);
        }
    }

    public void DoLicense() {
        if (licenseFrame == null) {
            Dimension licenseBoxSize = new Dimension(600, 245);
            if (_licenseText == null) {
                _licenseText = JBHelp.loadHelp("/help/COPYING.html", "License for JBidwatcher...");
            }
            licenseFrame = this._oui.showHTMLDisplay(_licenseText != null ? _licenseText : badLicense, licenseBoxSize, "License for JBidwatcher");
        } else {
            licenseFrame.setVisible(true);
        }
    }

    public void DoNeedHelp() {
        if (needHelpFrame == null) {
            Dimension boxSize = new Dimension(507, 300);
            if (_needHelp == null) {
                _needHelp = JBHelp.loadHelp("/help/need_help.jbh", "/help/need_help.md", "A Message from the JBidwatcher Author");
            }
            if (_needHelp != null) {
                needHelpFrame = this._oui.showHTMLDisplay(_needHelp, boxSize, "A Message from Morgan Schweers");
            }
        } else {
            needHelpFrame.setVisible(true);
        }
    }

    public void DoMetrics() {
        Dimension boxSize = new Dimension(400, 220);
        String text = "**I would very much appreciate it if you would allow JBidwatcher to collect _anonymous_ usage statistics to help me know what to improve.**\n\nBy clicking 'Yes' you agree that JBidwatcher may collect and report usage data for support purposes, and to help me improve the quality of JBidwatcher and related applications and services.\n\n<small>You can learn more about what is collected [here](http://www.jbidwatcher.com/help/metrics).  Thank you!";
        StringBuffer sb = new StringBuffer(Processor.process((String)text));
        this._oui.showTextDisplayWithButtons(sb, boxSize, "Please help me make JBidwatcher better", "metrics.optin", "No", "false", "Yes", "true");
    }

    public void DoDonate() {
        if (donateFrame == null) {
            Dimension boxSize = new Dimension(495, 245);
            if (_donate == null) {
                _donate = JBHelp.loadHelp("/help/donate.jbh", "A Message from the JBidwatcher Author");
            }
            if (_donate != null) {
                donateFrame = this._oui.showHTMLDisplay(_donate, boxSize, "A Message from Morgan Schweers");
            }
        } else {
            donateFrame.setVisible(true);
        }
    }

    @MenuCommand(action="Clear Donation")
    public void UndoDonate() {
        boolean alreadyClicked = JConfig.queryConfiguration("donation.clicked", "false").equals("true");
        if (donateFrame != null) {
            donateFrame.setVisible(false);
        }
        JConfig.setConfiguration("donation.clicked", "true");
        this.toolBar.hideDonation();
        if (!alreadyClicked) {
            JOptionPane.showMessageDialog(null, "The donation button has been removed; you can still access the donation screen from Help | Donate.", "Removed donation button", 1);
        }
    }

    private void showLog(final LogProvider provider, String frameName) {
        Dimension logBoxSize = new Dimension(625, 500);
        StringBuffer logText = provider.getLog();
        if (logText == null || logText.length() == 0) {
            logText = EMPTY_LOG;
        }
        final JBidFrame logFrame = this._oui.getTextDisplay(logText, logBoxSize, "JBidwatcher " + frameName, false);
        JButton logButton = new JButton("Submit Log");
        logButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserActions.this.DoSubmitLogFile();
            }
        });
        JButton refreshButton = new JButton("Refresh");
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logFrame.getEditor().setText(provider.getLog().toString());
            }
        });
        JPanel buttonBox = new JPanel(new BorderLayout());
        buttonBox.add((Component)logButton, "East");
        buttonBox.add((Component)refreshButton, "West");
        logFrame.add((Component)buttonBox, "South");
        logFrame.pack();
        logFrame.setSize(logBoxSize.width, logBoxSize.height);
        logFrame.setVisible(true);
        logFrame.setDefaultCloseOperation(2);
    }

    public void DoViewLog() {
        this.showLog(this.monitor, "Log");
    }

    public void DoViewActivity() {
        this.showLog(ActivityMonitor.getInstance(), "Activity Log");
    }

    public void DoExit() {
        MQFactory.getConcrete("Swing").enqueue("QUIT");
    }

    private String getActionValue(int action, AuctionEntry ae) {
        switch (action) {
            case 0: {
                return ae.getBrowseableURL();
            }
            case 1: {
                return ae.getIdentifier();
            }
            case 2: {
                return this.makeUsefulString(ae);
            }
        }
        return "";
    }

    public void DoCopySomething(Component src, AuctionEntry passedAE, int action, String fail_msg, String seperator) {
        AuctionEntry ae = passedAE;
        int[] rowList = this.mTabs.getPossibleRows();
        if (ae == null && rowList.length == 0) {
            JOptionPane.showMessageDialog(src, fail_msg, "Error copying", -1);
            return;
        }
        if (rowList.length != 0 && rowList.length != 1) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < rowList.length; ++i) {
                AuctionEntry tempEntry = (AuctionEntry)this.mTabs.getIndexedEntry(rowList[i]);
                if (i != 0) {
                    sb.append(seperator);
                }
                sb.append(this.getActionValue(action, tempEntry));
            }
            Clipboard.setClipboardString(sb.toString());
        } else {
            if (rowList.length == 1) {
                ae = (AuctionEntry)this.mTabs.getIndexedEntry(rowList[0]);
            }
            Clipboard.setClipboardString(this.getActionValue(action, ae));
        }
    }

    @MenuCommand(params=2)
    public void DoCopyURL(Component src, AuctionEntry ae) {
        this.DoCopySomething(src, ae, 0, "No auctions selected to copy URLs of!", "\n");
    }

    @MenuCommand(params=2)
    public void DoCopyID(Component src, AuctionEntry ae) {
        this.DoCopySomething(src, ae, 1, "No auctions selected to copy IDs of!", ", ");
    }

    @MenuCommand(params=1)
    public void DoHelp(Component src) {
        JOptionPane.showMessageDialog(src, "I'm very sorry, but help has not been implemented yet.\nIf you'd like to assist in getting help up, you could\nwrite me an email at cyberfox@jbidwatcher.com\ndescribing how you use a particular part of JBidwatcher,\nand I'll try to collect those into contextual help options.", "Sorry, no help!", 1);
    }

    @MenuCommand(action="Explain Colors And Icons")
    public void DoHelpColors() {
        if (helpFrame == null) {
            Dimension chSize = new Dimension(495, 245);
            if (_colorHelp == null) {
                _colorHelp = JBHelp.loadHelp("/help/colors.jbh", "Help on Colors");
            }
            helpFrame = this._oui.showHTMLDisplay(_colorHelp != null ? _colorHelp : badColors, chSize, "Help on color use in JBidwatcher");
        } else {
            helpFrame.setVisible(true);
        }
    }

    @MenuCommand(action="Check For Updates")
    public void DoCheckUpdates() {
        JConfig.setConfiguration("updates.last_version", "2.99pre5");
        MQFactory.getConcrete("update").enqueue("INTERACTIVE");
    }

    @MenuCommand(params=1, action="Selection Color")
    public void DoSetSelectionColor(Component src) {
        Color selectionColor;
        String oldColor = JConfig.queryConfiguration("selection.color");
        if (oldColor == null) {
            oldColor = "C6A646";
        }
        if ((selectionColor = JColorChooser.showDialog(src, "Choose a selection-background color", MultiSnipe.reverseColor(oldColor))) == null) {
            return;
        }
        JConfig.setConfiguration("selection.color", MultiSnipe.makeRGB(selectionColor));
    }

    @MenuCommand(params=1)
    public void DoSetBackgroundColor(Component src) {
        Color bgColor = JColorChooser.showDialog(src, "Select a background color for your auction tables", null);
        if (bgColor == null) {
            return;
        }
        MQFactory.getConcrete("redraw").enqueue("#" + Integer.toHexString(bgColor.getRGB() & 0xFFFFFF));
        myTableCellRenderer.resetBehavior();
        JConfig.setConfiguration("background", MultiSnipe.makeRGB(bgColor));
    }

    @MenuCommand(params=1)
    public void DoClearDeleted(Component src) {
        int clearedCount = this.auctionsManager.clearDeleted();
        this._oui.promptWithCheckbox(src, "Cleared " + clearedCount + " deleted entries.", "Clear Complete", "prompt.clear_complete", -1, 0);
    }

    protected void DoAction(Object src, String actionString, Object whichAuction) {
        this.DoAction(src, actionString, (AuctionEntry)whichAuction);
    }

    protected void DoAction(Object src, String actionString, AuctionEntry whichAuction) {
        Component c_src = src instanceof Component ? (Component)src : null;
        Scripting.rubyMethod("handle_action", actionString, this, c_src, whichAuction);
        if (actionString.equals("About JBidwatcher")) {
            this.DoAbout();
        } else if (actionString.equals("Dump")) {
            JConfig.log().logDebug("Dump requested.");
        } else if (actionString.equals("Forum")) {
            MQFactory.getConcrete("browse").enqueue("http://forum.jbidwatcher.com");
        } else if (actionString.equals("My JBidwatcher")) {
            MQFactory.getConcrete("browse").enqueue("http://my.jbidwatcher.com");
        } else if (actionString.equals("Report Bug")) {
            MQFactory.getConcrete("browse").enqueue("http://jbidwatcher.lighthouseapp.com/projects/8037-jbidwatcher/tickets");
        } else {
            JConfig.log().logDebug('[' + actionString + ']');
        }
    }

    @MenuCommand(action="My eBay")
    public void DoGetMyeBay() {
        AuctionQObject loadMyeBay = new AuctionQObject(3, null, "current");
        MQFactory.getConcrete(this.serverManager.getServer().getFriendlyName()).enqueueBean(loadMyeBay);
    }

    public void DoSubmitLogFile() {
        if (this.mLogSubmitDialog == null) {
            this.mLogSubmitDialog = new SubmitLogDialog(this.myJBidwatcher);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UserActions.this.mLogSubmitDialog.showDialog();
            }
        });
    }

    public void DoRestart() {
        String launcher = System.getenv("JBIDWATCHER_LAUNCHER");
        if (JConfig.debugging && launcher != null) {
            System.exit(100);
        } else {
            JOptionPane.showMessageDialog(null, "Restart does not work without being run from the JBidLauncher script.", "Restart Failed", -1);
        }
    }

    @MenuCommand(params=2, action="Report")
    public void DoReportProblem(Component src, AuctionEntry auction) {
        String endResult = this.promptString(src, "What's wrong with: " + auction.getTitle(), "Reporting a problem", "");
        if (endResult == null) {
            endResult = "";
        }
        auction.setLastStatus(endResult);
        MQFactory.getConcrete("report").enqueue(auction.getIdentifier());
    }
}

