/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.config;

import com.jbidwatcher.ui.config.JConfigTab;
import com.jbidwatcher.ui.util.AutoCompletion;
import com.jbidwatcher.ui.util.JPasteListener;
import com.jbidwatcher.util.config.JConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JConfigAdvancedTab
extends JConfigTab {
    JComboBox configKey = null;
    JTextField configValue = null;
    private JButton setButton = null;
    private JButton delButton = null;
    private static HashSet<JComboBox> boxSet = new HashSet();

    @Override
    public String getTabName() {
        return "Advanced";
    }

    @Override
    public void cancel() {
    }

    @Override
    public void apply() {
        JConfig.setConfiguration((String)this.configKey.getSelectedItem(), this.configValue.getText());
    }

    @Override
    public void updateValues() {
        this.buildNewConfigList(this.configKey, this.configValue);
        String gotVal = (String)this.configKey.getSelectedItem();
        if (gotVal == null || gotVal.length() == 0) {
            this.configValue.setText("");
        } else {
            this.configValue.setText(JConfig.queryConfiguration(gotVal, ""));
        }
    }

    private void buildNewConfigList(final JComboBox box, final JTextField value) {
        box.removeAllItems();
        box.setEditable(true);
        box.addItem("");
        List<String> cfgKeys = JConfig.getAllKeys();
        for (String cfgKey : cfgKeys) {
            String s = cfgKey;
            if (s.indexOf("password") != -1) continue;
            box.addItem(s);
        }
        if (!boxSet.contains(box)) {
            box.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String selected;
                    if (value != null && box != null && (selected = (String)box.getSelectedItem()) != null) {
                        boolean isPassword;
                        boolean bl = isPassword = selected.indexOf("password") != -1;
                        if (selected.length() == 0 || isPassword) {
                            value.setEnabled(false);
                            if (isPassword) {
                                value.setText("********");
                            } else {
                                value.setText("");
                            }
                            JConfigAdvancedTab.this.setButton.setEnabled(false);
                            JConfigAdvancedTab.this.delButton.setEnabled(false);
                        } else {
                            value.setEnabled(true);
                            value.setText(JConfig.queryConfiguration(selected, ""));
                            JConfigAdvancedTab.this.setButton.setEnabled(true);
                            JConfigAdvancedTab.this.delButton.setEnabled(true);
                        }
                    }
                }
            });
            AutoCompletion.enable(box);
            boxSet.add(box);
        }
        box.requestFocus();
    }

    private JPanel buildAdvancedConfiguration(JPasteListener pasteListener) {
        JPanel tp = new JPanel();
        this.setButton = new JButton("Set...");
        this.delButton = new JButton("Delete");
        tp.setBorder(BorderFactory.createTitledBorder("Advanced Configuration Editor"));
        tp.setLayout(new BoxLayout(tp, 1));
        this.configKey = new JComboBox();
        tp.add(new JLabel("Configuration Key"));
        this.configValue = new JTextField();
        this.configValue.addMouseListener(pasteListener);
        this.configValue.setToolTipText("The associated configuration value for the entered key.");
        this.configValue.setEditable(true);
        this.configValue.getAccessibleContext().setAccessibleName("The configuration value for the entered key.");
        JLabel jl = new JLabel("Configuration Value");
        this.buildNewConfigList(this.configKey, this.configValue);
        tp.add(this.configKey);
        tp.add(jl);
        this.updateValues();
        JPanel qp = new JPanel();
        Box pairBox = Box.createHorizontalBox();
        qp.setLayout(new BoxLayout(qp, 1));
        qp.add(this.configValue);
        pairBox.add(this.setButton);
        pairBox.add(Box.createHorizontalStrut(30));
        pairBox.add(this.delButton);
        qp.add(pairBox);
        this.setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ae.getActionCommand().equals("Set...") && ((String)JConfigAdvancedTab.this.configKey.getSelectedItem()).length() != 0) {
                    JConfig.setConfiguration((String)JConfigAdvancedTab.this.configKey.getSelectedItem(), JConfigAdvancedTab.this.configValue.getText());
                    JConfigAdvancedTab.this.updateValues();
                }
            }
        });
        this.delButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ae.getActionCommand().equals("Delete")) {
                    JConfig.kill((String)JConfigAdvancedTab.this.configKey.getSelectedItem());
                    JConfigAdvancedTab.this.updateValues();
                }
            }
        });
        tp.add((Component)qp, "South");
        return tp;
    }

    public JConfigAdvancedTab(JPasteListener pasteListener) {
        this.setLayout(new BorderLayout());
        this.add((Component)JConfigAdvancedTab.panelPack(this.buildAdvancedConfiguration(pasteListener)), "North");
    }
}

