/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.config;

import com.jbidwatcher.ui.config.JConfigTab;
import com.jbidwatcher.ui.util.JPasteListener;
import com.jbidwatcher.util.config.JConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JConfigFirewallTab
extends JConfigTab {
    private JRadioButton noFirewall;
    private JRadioButton socksFirewall;
    private JRadioButton webProxy;
    private JCheckBox proxyHttps;
    String holdProxyHost = null;
    String holdProxyPort = null;
    String holdHTTPSProxyHost = null;
    String holdHTTPSProxyPort = null;
    String holdProxyUser = null;
    String holdProxyPass = null;
    String holdFireHost = null;
    String holdFirePort = null;
    private JTextField proxyHost;
    private JTextField proxyPort;
    private JTextField httpsProxyHost;
    private JTextField httpsProxyPort;
    private JTextField proxyUser;
    private JPasswordField proxyPass;
    private JTextField firewallHost;
    private JTextField firewallPort;
    private DocumentListener firewallTextFieldListener;

    public JConfigFirewallTab(JPasteListener pasteListener) {
        this.pasteListener = pasteListener;
        JPanel topPanes = new JPanel();
        JPanel bottomPanes = new JPanel();
        this.firewallTextFieldListener = new textAction();
        this.setLayout(new BorderLayout());
        topPanes.setLayout(new GridLayout(1, 2));
        topPanes.add(JConfigFirewallTab.panelPack(this.buildRadioButtons()));
        topPanes.add(JConfigFirewallTab.panelPack(this.buildFirewallPrompt()));
        this.add((Component)topPanes, "North");
        bottomPanes.setLayout(new GridLayout(1, 2));
        bottomPanes.add(JConfigFirewallTab.panelPack(this.buildProxyPanel()));
        bottomPanes.add(JConfigFirewallTab.panelPack(this.buildHTTPSProxyPanel()));
        this.add((Component)bottomPanes, "Center");
        this.updateValues();
    }

    @Override
    public String getTabName() {
        return "Firewall";
    }

    @Override
    public void cancel() {
        this.holdHTTPSProxyPort = null;
        this.holdHTTPSProxyHost = null;
        this.holdFirePort = null;
        this.holdFireHost = null;
        this.holdProxyPass = null;
        this.holdProxyUser = null;
        this.holdProxyPort = null;
        this.holdProxyHost = null;
        this.updateValues();
    }

    @Override
    public void apply() {
        String firewallState = "none";
        if (this.noFirewall.isSelected()) {
            firewallState = "none";
        } else if (this.socksFirewall.isSelected()) {
            firewallState = "firewall";
        } else if (this.webProxy.isSelected()) {
            firewallState = "proxy";
        }
        JConfig.setConfiguration("proxyfirewall", firewallState);
        if (this.holdProxyHost != null) {
            JConfig.setConfiguration("proxy.host", this.holdProxyHost);
        }
        if (this.holdProxyPort != null) {
            JConfig.setConfiguration("proxy.port", this.holdProxyPort);
        }
        if (this.holdProxyUser != null) {
            JConfig.setConfiguration("proxy.user", this.holdProxyUser);
        }
        if (this.holdProxyPass != null) {
            JConfig.setConfiguration("proxy.pass", this.holdProxyPass);
        }
        if (this.holdFireHost != null) {
            JConfig.setConfiguration("firewall.host", this.holdFireHost);
        }
        if (this.holdFirePort != null) {
            JConfig.setConfiguration("firewall.port", this.holdFirePort);
        }
        if (this.proxyHttps.isSelected()) {
            JConfig.setConfiguration("proxy.https.set", "true");
            if (this.holdHTTPSProxyHost != null) {
                JConfig.setConfiguration("proxy.https.host", this.holdHTTPSProxyHost);
            }
            if (this.holdHTTPSProxyPort != null) {
                JConfig.setConfiguration("proxy.https.port", this.holdHTTPSProxyPort);
            }
        } else {
            JConfig.setConfiguration("proxy.https.set", "false");
        }
    }

    private String getConfigValue(JToggleButton jrb, String configValue, String defaultValue) {
        if (jrb.isSelected()) {
            if (defaultValue == null) {
                String outputValue = JConfig.queryConfiguration(configValue);
                if (outputValue == null) {
                    return "";
                }
                return outputValue;
            }
            return defaultValue;
        }
        return "<disabled>";
    }

    private void setAllProxyText() {
        this.proxyHost.setText(this.getConfigValue(this.webProxy, "proxy.host", this.holdProxyHost));
        this.proxyPort.setText(this.getConfigValue(this.webProxy, "proxy.port", this.holdProxyPort));
        this.proxyUser.setText(this.getConfigValue(this.webProxy, "proxy.user", this.holdProxyUser));
        this.proxyPass.setText(this.getConfigValue(this.webProxy, "proxy.pass", this.holdProxyPass));
    }

    private void setAllProxyStatus(boolean proxyP) {
        this.proxyHost.setEnabled(proxyP);
        this.proxyPort.setEnabled(proxyP);
        this.proxyUser.setEnabled(proxyP);
        this.proxyPass.setEnabled(proxyP);
    }

    private void setAllFirewallText() {
        this.firewallHost.setText(this.getConfigValue(this.socksFirewall, "firewall.host", this.holdFireHost));
        this.firewallPort.setText(this.getConfigValue(this.socksFirewall, "firewall.port", this.holdFirePort));
    }

    private void setAllFirewallStatus(boolean firewallP) {
        this.firewallHost.setEnabled(firewallP);
        this.firewallPort.setEnabled(firewallP);
    }

    private void setAllHTTPSText() {
        this.httpsProxyHost.setText(this.getConfigValue(this.proxyHttps, "proxy.https.host", this.holdHTTPSProxyHost));
        this.httpsProxyPort.setText(this.getConfigValue(this.proxyHttps, "proxy.https.port", this.holdHTTPSProxyPort));
    }

    private void setAllHTTPSStatus(boolean httpsP) {
        this.httpsProxyHost.setEnabled(httpsP);
        this.httpsProxyPort.setEnabled(httpsP);
    }

    private void updateProxyFirewall(boolean proxyP, boolean firewallP, boolean httpsP) {
        if (!proxyP) {
            this.setAllProxyStatus(proxyP);
            this.setAllProxyText();
        } else {
            this.setAllProxyText();
            this.setAllProxyStatus(proxyP);
        }
        if (!firewallP) {
            this.setAllFirewallStatus(firewallP);
            this.setAllFirewallText();
        } else {
            this.setAllFirewallText();
            this.setAllFirewallStatus(firewallP);
        }
        if (!httpsP) {
            this.setAllHTTPSStatus(httpsP);
            this.setAllHTTPSText();
        } else {
            this.setAllHTTPSText();
            this.setAllHTTPSStatus(httpsP);
        }
    }

    @Override
    public final void updateValues() {
        boolean proxyP;
        boolean firewallP;
        String proxyFirewall = JConfig.queryConfiguration("proxyfirewall");
        if (proxyFirewall == null) {
            this.noFirewall.setSelected(true);
            firewallP = false;
            proxyP = false;
        } else if (proxyFirewall.equals("proxy")) {
            this.webProxy.setSelected(true);
            firewallP = false;
            proxyP = true;
        } else if (proxyFirewall.equals("firewall")) {
            this.socksFirewall.setSelected(true);
            firewallP = true;
            proxyP = false;
        } else {
            this.noFirewall.setSelected(true);
            firewallP = false;
            proxyP = false;
        }
        if (JConfig.queryConfiguration("proxy.https.set", "false").equals("true")) {
            this.proxyHttps.setSelected(true);
        }
        this.updateProxyFirewall(proxyP, firewallP, this.proxyHttps.isSelected());
    }

    private JPanel buildRadioButtons() {
        radioAction rad = new radioAction();
        JPanel buttonPanel = new JPanel();
        Box buttonBox = Box.createVerticalBox();
        this.noFirewall = new JRadioButton("No firewall or proxy");
        this.socksFirewall = new JRadioButton("SOCKS 4/5 Firewall");
        this.webProxy = new JRadioButton("HTTP Web Proxy");
        ButtonGroup allButtons = new ButtonGroup();
        allButtons.add(this.socksFirewall);
        allButtons.add(this.webProxy);
        allButtons.add(this.noFirewall);
        this.socksFirewall.addActionListener(rad);
        this.webProxy.addActionListener(rad);
        this.noFirewall.addActionListener(rad);
        buttonPanel.setBorder(BorderFactory.createTitledBorder("Firewall/Proxy"));
        buttonPanel.setLayout(new BorderLayout());
        buttonBox.add(this.socksFirewall);
        buttonBox.add(this.webProxy);
        buttonBox.add(this.noFirewall);
        buttonPanel.add((Component)buttonBox, "North");
        return buttonPanel;
    }

    private JPanel buildFirewallPrompt() {
        JPanel firewallPanel = new JPanel();
        firewallPanel.setBorder(BorderFactory.createTitledBorder("SOCKS Settings"));
        firewallPanel.setLayout(new BoxLayout(firewallPanel, 1));
        this.firewallHost = new JTextField();
        this.firewallPort = new JTextField();
        this.setAllFirewallStatus(false);
        this.adjustField(this.firewallHost, "Host name or IP address of SOCKS firewall", this.firewallTextFieldListener);
        this.adjustField(this.firewallPort, "Port number for SOCKS firewall", this.firewallTextFieldListener);
        Box updownBox = Box.createVerticalBox();
        updownBox.add(JConfigFirewallTab.makeLine(new JLabel("SOCKS Host: "), this.firewallHost));
        updownBox.add(JConfigFirewallTab.makeLine(new JLabel("SOCKS Port:  "), this.firewallPort));
        firewallPanel.add(updownBox);
        return firewallPanel;
    }

    private JPanel buildProxyPanel() {
        JPanel proxyPanel = new JPanel();
        proxyPanel.setBorder(BorderFactory.createTitledBorder("HTTP/Web Proxy Settings"));
        proxyPanel.setLayout(new BoxLayout(proxyPanel, 1));
        this.proxyHost = new JTextField();
        this.proxyPort = new JTextField();
        this.proxyUser = new JTextField();
        this.proxyPass = new JPasswordField();
        this.setAllProxyStatus(false);
        this.adjustField(this.proxyHost, "Host name or IP address of web proxy server", this.firewallTextFieldListener);
        this.adjustField(this.proxyPort, "Port number that a web proxy server runs on", this.firewallTextFieldListener);
        this.adjustField(this.proxyUser, "Username (if needed) for web proxy server", this.firewallTextFieldListener);
        this.adjustField(this.proxyPass, "Password (if needed) for web proxy server", this.firewallTextFieldListener);
        proxyPanel.add(JConfigFirewallTab.makeLine(new JLabel("Host: "), this.proxyHost));
        proxyPanel.add(JConfigFirewallTab.makeLine(new JLabel("Port:  "), this.proxyPort));
        proxyPanel.add(JConfigFirewallTab.makeLine(new JLabel("Username: "), this.proxyUser));
        proxyPanel.add(JConfigFirewallTab.makeLine(new JLabel("Password:  "), this.proxyPass));
        return proxyPanel;
    }

    private JPanel buildHTTPSProxyPanel() {
        JPanel proxyPanel = new JPanel();
        radioAction rad = new radioAction();
        proxyPanel.setBorder(BorderFactory.createTitledBorder("HTTPS/Secure Proxy Settings"));
        proxyPanel.setLayout(new BoxLayout(proxyPanel, 1));
        this.httpsProxyHost = new JTextField();
        this.httpsProxyPort = new JTextField();
        this.setAllHTTPSStatus(false);
        this.adjustField(this.httpsProxyHost, "Host name or IP address of HTTPS proxy server", this.firewallTextFieldListener);
        this.adjustField(this.httpsProxyPort, "Port number that the HTTPS proxy server runs on", this.firewallTextFieldListener);
        this.proxyHttps = new JCheckBox("Enable HTTPS (secure http) proxy?");
        this.proxyHttps.addActionListener(rad);
        JPanel checkboxPanel = new JPanel(new BorderLayout());
        checkboxPanel.add((Component)this.proxyHttps, "West");
        proxyPanel.add(checkboxPanel);
        proxyPanel.add(JConfigFirewallTab.makeLine(new JLabel("HTTPS Host: "), this.httpsProxyHost));
        proxyPanel.add(JConfigFirewallTab.makeLine(new JLabel("HTTPS Port: "), this.httpsProxyPort));
        return proxyPanel;
    }

    private class textAction
    implements DocumentListener {
        private textAction() {
        }

        private void anyEvent() {
            if (JConfigFirewallTab.this.proxyHost.isEnabled()) {
                JConfigFirewallTab.this.holdProxyHost = JConfigFirewallTab.this.proxyHost.getText();
            }
            if (JConfigFirewallTab.this.proxyPort.isEnabled()) {
                JConfigFirewallTab.this.holdProxyPort = JConfigFirewallTab.this.proxyPort.getText();
            }
            if (JConfigFirewallTab.this.proxyUser.isEnabled()) {
                JConfigFirewallTab.this.holdProxyUser = JConfigFirewallTab.this.proxyUser.getText();
            }
            if (JConfigFirewallTab.this.proxyPass.isEnabled()) {
                JConfigFirewallTab.this.holdProxyPass = new String(JConfigFirewallTab.this.proxyPass.getPassword());
            }
            if (JConfigFirewallTab.this.firewallHost.isEnabled()) {
                JConfigFirewallTab.this.holdFireHost = JConfigFirewallTab.this.firewallHost.getText();
            }
            if (JConfigFirewallTab.this.firewallPort.isEnabled()) {
                JConfigFirewallTab.this.holdFirePort = JConfigFirewallTab.this.firewallPort.getText();
            }
            if (JConfigFirewallTab.this.httpsProxyHost.isEnabled()) {
                JConfigFirewallTab.this.holdHTTPSProxyHost = JConfigFirewallTab.this.httpsProxyHost.getText();
            }
            if (JConfigFirewallTab.this.httpsProxyPort.isEnabled()) {
                JConfigFirewallTab.this.holdHTTPSProxyPort = JConfigFirewallTab.this.httpsProxyPort.getText();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent de) {
            this.anyEvent();
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
            this.anyEvent();
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            this.anyEvent();
        }
    }

    private class radioAction
    implements ActionListener {
        private radioAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            boolean proxyP = false;
            boolean firewallP = false;
            if (JConfigFirewallTab.this.noFirewall.isSelected()) {
                firewallP = false;
                proxyP = false;
            } else if (JConfigFirewallTab.this.socksFirewall.isSelected()) {
                firewallP = true;
                proxyP = false;
            } else if (JConfigFirewallTab.this.webProxy.isSelected()) {
                firewallP = false;
                proxyP = true;
            }
            JConfigFirewallTab.this.updateProxyFirewall(proxyP, firewallP, JConfigFirewallTab.this.proxyHttps.isSelected());
        }
    }
}

