/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util;

import com.jbidwatcher.util.Currency;
import com.jbidwatcher.util.Record;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;

public class HashBacked {
    private static final Record EMPTY = new Record();
    private Record mBacking = EMPTY;
    public static String DB_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private SimpleDateFormat mDateFormat = new SimpleDateFormat(DB_DATE_FORMAT);
    private Map<String, String> mTranslationTable;
    private String mDefaultCurrency;
    private boolean mDirty = false;
    private static final Currency ONE_DOLLAR = Currency.getCurrency("$1.00");
    private Record mSecondary = null;
    private boolean mSecondaryAttempted = false;

    public HashBacked() {
        this(new Record());
    }

    public HashBacked(Record data) {
        this.mDateFormat.setTimeZone(TimeZone.getDefault());
        this.mBacking = data;
        this.mDefaultCurrency = data.get("currency") == null ? ONE_DOLLAR.fullCurrencyName() : this.get("currency");
    }

    public void setTranslationTable(Map<String, String> table) {
        if (this.mTranslationTable == null) {
            this.mTranslationTable = table;
        }
    }

    public boolean isDirty() {
        return this.mDirty;
    }

    protected void clearDirty() {
        this.mDirty = false;
    }

    protected void setDirty() {
        this.mDirty = true;
    }

    public Currency getMonetary(String key, int currencyType) {
        String result = this.get(key);
        try {
            double value = Double.parseDouble(result);
            return Currency.getCurrency(currencyType, value);
        }
        catch (Exception e) {
            return Currency.NoValue();
        }
    }

    public Currency getMonetary(String key, Currency fallback) {
        Currency rval = this.getMonetary(key);
        if (rval == null || rval.isNull()) {
            return fallback;
        }
        return rval;
    }

    protected void setDefaultCurrency(Currency sample) {
        this.mDefaultCurrency = sample.fullCurrencyName();
    }

    public Currency getDefaultCurrency() {
        return Currency.getCurrency(this.mDefaultCurrency, 1.0);
    }

    public Currency getMonetary(String key) {
        String result = this.get(key);
        if (result == null) {
            return Currency.NoValue();
        }
        try {
            double value = Double.parseDouble(result);
            return Currency.getCurrency(this.mDefaultCurrency, value);
        }
        catch (Exception e) {
            return Currency.NoValue();
        }
    }

    public void setMonetary(String key, Currency c) {
        this.setMonetary(key, c, true);
    }

    public void setMonetary(String key, Currency c, boolean updateDefault) {
        if (c == null || c.isNull()) {
            this.set(key, null);
        } else {
            if (updateDefault && !c.fullCurrencyName().equals(this.mDefaultCurrency) && c.getCurrencyType() != 1 && c.getCurrencyType() != 0) {
                this.setDefaultCurrency(c);
            }
            this.set(key, Double.toString(c.getValue()));
        }
    }

    public void setBoolean(String key, boolean value) {
        this.set(key, value ? "1" : "0");
    }

    public void setDate(String key, Date date) {
        if (date == null || date.getTime() < 0L) {
            this.set(key, null);
        } else {
            this.set(key, this.mDateFormat.format(date));
        }
    }

    public Date getDate(String key) {
        String s_value = this.get(key);
        if (s_value == null || s_value.length() == 0) {
            return null;
        }
        try {
            return this.mDateFormat.parse(s_value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Integer getInteger(String key, Integer fallback) {
        Integer result = this.getInteger(key);
        if (result == null) {
            return fallback;
        }
        return result;
    }

    public Integer getInteger(String key) {
        String s_value = this.get(key);
        if (s_value == null || s_value.length() == 0) {
            return null;
        }
        return Integer.parseInt(s_value);
    }

    public void setInteger(String key, Integer value) {
        if (value == null) {
            this.set(key, null);
        } else {
            this.set(key, Integer.toString(value));
        }
    }

    public boolean getBoolean(String key) {
        String result = this.get(key);
        return result != null && "1".equals(result);
    }

    public boolean getBoolean(String key, boolean fallback) {
        String result = this.get(key);
        if (result == null) {
            return fallback;
        }
        return "1".equals(result);
    }

    public void setString(String key, String value) {
        this.set(key, value);
    }

    public String getString(String key) {
        return this.get(key);
    }

    public String getString(String key, String fallback) {
        String rval = this.get(key);
        if (rval == null) {
            return fallback;
        }
        return rval;
    }

    protected void setSecondary(Record r) {
        this.mSecondary = r;
    }

    protected void loadSecondary() {
    }

    public String get(String key) {
        String result;
        if (this.mTranslationTable != null && this.mTranslationTable.containsKey(key)) {
            key = this.mTranslationTable.get(key);
        }
        if ((result = (String)this.mBacking.get(key)) == null && this.mBacking.get("id") != null) {
            if (this.mSecondary != null) {
                if (this.mSecondary.containsKey(key)) {
                    result = (String)this.mSecondary.get(key);
                }
            } else if (!this.mSecondaryAttempted) {
                this.mSecondaryAttempted = true;
                this.loadSecondary();
                if (this.mSecondary != null) {
                    result = (String)this.mSecondary.get(key);
                }
            }
        }
        return result;
    }

    public void set(String key, String value) {
        String prev;
        if (this.mTranslationTable != null && this.mTranslationTable.containsKey(key)) {
            key = this.mTranslationTable.get(key);
        }
        if ((prev = this.mBacking.put(key, value)) == null && value != null || prev != null && !prev.equals(value)) {
            this.setDirty();
        }
    }

    public Record getBacking() {
        return this.mBacking;
    }

    public void setBacking(Record r) {
        this.mBacking = r;
        this.mDefaultCurrency = r.get("currency") == null ? ONE_DOLLAR.fullCurrencyName() : this.get("currency");
        this.clearDirty();
    }

    public String dumpRecord() {
        StringBuffer sb = new StringBuffer("<record>\n");
        for (String key : this.mBacking.keySet()) {
            sb.append("  <").append(key).append('>').append((String)this.mBacking.get(key)).append("</").append(key).append(">\n");
        }
        sb.append("</record>\n");
        return sb.toString();
    }
}

