/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util;

import com.jbidwatcher.util.config.JConfig;
import java.text.MessageFormat;
import org.jetbrains.annotations.Nullable;

public class TimeLeftBuilder {
    private static final String mf_min_sec = "{6}{2,number,##}m, {7}{3,number,##}s";
    private static final String mf_hrs_min = "{5}{1,number,##}h, {6}{2,number,##}m";
    private static final String mf_day_hrs = "{4}{0,number,##}d, {5}{1,number,##}h";
    private static final String mf_min_sec_detailed = "{6}{2,number,##} minute{2,choice,0#, |1#, |1<s,} {7}{3,number,##} second{3,choice,0#|1#|1<s}";
    private static final String mf_hrs_min_detailed = "{5}{1,number,##} hour{1,choice,0#, |1#, |1<s,} {6}{2,number,##} minute{2,choice,0#|1#|1<s}";
    private static final String mf_day_hrs_detailed = "{4}{0,number,##} day{0,choice,0#, |1#, |1<s,}  {5}{1,number,##} hour{1,choice,0#|1#|1<s}";

    private static String convertToMsgFormat(String simpleFormat) {
        String msgFmt = simpleFormat.replaceAll("DD", "{4}{0,number,##}");
        msgFmt = msgFmt.replaceAll("HH", "{5}{1,number,##}");
        msgFmt = msgFmt.replaceAll("MM", "{6}{2,number,##}");
        msgFmt = msgFmt.replaceAll("SS", "{7}{3,number,##}");
        return msgFmt;
    }

    private static String getTimeFormatter(long days, long hours) {
        String mf;
        boolean use_detailed = JConfig.queryConfiguration("timeleft.detailed", "false").equals("true");
        if (days == 0L) {
            if (hours == 0L) {
                mf = use_detailed ? mf_min_sec_detailed : mf_min_sec;
                String cfg = JConfig.queryConfiguration("timeleft.minutes");
                if (cfg != null) {
                    mf = TimeLeftBuilder.convertToMsgFormat(cfg);
                }
            } else {
                mf = use_detailed ? mf_hrs_min_detailed : mf_hrs_min;
                String cfg = JConfig.queryConfiguration("timeleft.hours");
                if (cfg != null) {
                    mf = TimeLeftBuilder.convertToMsgFormat(cfg);
                }
            }
        } else {
            mf = use_detailed ? mf_day_hrs_detailed : mf_day_hrs;
            String cfg = JConfig.queryConfiguration("timeleft.days");
            if (cfg != null) {
                mf = TimeLeftBuilder.convertToMsgFormat(cfg);
            }
        }
        return mf;
    }

    private static String pad(long x) {
        return x < 10L ? " " : "";
    }

    @Nullable
    public static String getTimeLeftString(long dateDiff) {
        if (dateDiff > 5184000000L) {
            return "N/A";
        }
        if (dateDiff >= 0L) {
            long days = dateDiff / 86400000L;
            long hours = (dateDiff -= days * 86400000L) / 3600000L;
            long minutes = (dateDiff -= hours * 3600000L) / 60000L;
            long seconds = (dateDiff -= minutes * 60000L) / 1000L;
            String mf = TimeLeftBuilder.getTimeFormatter(days, hours);
            Object[] timeArgs = new Object[]{days, hours, minutes, seconds, TimeLeftBuilder.pad(days), TimeLeftBuilder.pad(hours), TimeLeftBuilder.pad(minutes), TimeLeftBuilder.pad(seconds)};
            return MessageFormat.format(mf, timeArgs);
        }
        return null;
    }
}

