/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util.http;

import com.cyberfox.util.config.Base64;
import com.jbidwatcher.util.ByteBuffer;
import com.jbidwatcher.util.Parameters;
import com.jbidwatcher.util.StringTools;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.http.HttpInterface;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class Http
implements HttpInterface {
    private String mUsername = null;
    private String mPassword = null;
    private static HttpInterface sInstance = new Http();

    public static HttpInterface net() {
        return sInstance;
    }

    @Override
    public void setAuthInfo(String user, String pass) {
        this.mUsername = user;
        this.mPassword = pass;
    }

    private void setConnectionInfo(URLConnection huc) {
        if (this.mUsername != null && this.mPassword != null) {
            huc.setRequestProperty("Authorization", "Basic " + Base64.encodeString(this.mUsername + ':' + this.mPassword, false));
        }
        this.setConnectionProxyInfo(huc);
    }

    private void setConnectionProxyInfo(URLConnection huc) {
        String proxyHost;
        if (JConfig.queryConfiguration("proxyfirewall", "none").equals("proxy") && (proxyHost = JConfig.queryConfiguration("proxy.host", null)) != null) {
            String user = JConfig.queryConfiguration("proxy.user", null);
            String pass = JConfig.queryConfiguration("proxy.pass", null);
            System.setProperty("http.proxyUser", user);
            System.setProperty("http.proxyPassword", pass);
            if (user != null && pass != null) {
                String str = user + ':' + pass;
                String encoded = "Basic " + Base64.encodeString(str);
                huc.setRequestProperty("Proxy-Authorization", encoded);
            }
        }
    }

    @Override
    public URLConnection postFormPage(String url, String cgiData, String cookie, String referer, boolean followRedirects) {
        URLConnection huc;
        try {
            if (JConfig.queryConfiguration("debug.urls", "false").equals("true")) {
                JConfig.log().logDebug("postFormPage: " + url);
            }
            URL authURL = JConfig.getURL(url);
            huc = authURL.openConnection();
            this.setConnectionInfo(huc);
            huc.setDoOutput(true);
            if (huc instanceof HttpURLConnection) {
                HttpURLConnection conn = (HttpURLConnection)huc;
                conn.setRequestMethod("POST");
                if (!followRedirects) {
                    conn.setInstanceFollowRedirects(false);
                }
            }
            if (JConfig.queryConfiguration("debug.uber", "false").equals("true") && JConfig.debugging) {
                Http.dumpFormHeaders(System.err, cgiData, cookie);
            }
            huc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            huc.setRequestProperty("Content-Length", Integer.toString(cgiData.length()));
            this.setAgentAndEncoding(huc);
            if (referer != null) {
                huc.setRequestProperty("Referer", referer);
            }
            if (cookie != null) {
                huc.setRequestProperty("Cookie", cookie);
            }
            PrintStream obw = new PrintStream(huc.getOutputStream());
            obw.print(cgiData);
            obw.close();
        }
        catch (ConnectException ce) {
            JConfig.log().logMessage("postFormPage: " + ce);
            huc = null;
        }
        catch (Exception e) {
            JConfig.log().handleException("postFormPage: " + e, e);
            huc = null;
        }
        return huc;
    }

    private static void dumpFormHeaders(PrintStream out, String cgiData, String cookie) {
        if (cgiData != null) {
            out.println("Content-Type: application/x-www-form-urlencoded");
            out.println("Content-Length: " + Integer.toString(cgiData.length()));
            out.println("User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.101 Safari/537.36");
            out.println("Cookie: " + cookie);
        } else {
            out.println("CGI Data is null!");
        }
    }

    private void setAgentAndEncoding(URLConnection uc) {
        uc.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.101 Safari/537.36");
        uc.setRequestProperty("Accept-Encoding", "gzip");
    }

    @Override
    public URLConnection makeRequest(URL source, String cookie) throws IOException {
        if (JConfig.queryConfiguration("debug.urls", "false").equals("true")) {
            JConfig.log().logDebug("makeRequest: " + source.toString());
        }
        URLConnection uc = source.openConnection();
        this.setConnectionInfo(uc);
        if (cookie != null) {
            uc.setRequestProperty("Cookie", cookie);
        }
        this.setAgentAndEncoding(uc);
        return uc;
    }

    @Override
    public ByteBuffer getURL(URL url) {
        return this.getURL(url, null);
    }

    private ByteBuffer getURL(URL url, String inCookie) {
        ByteBuffer rval;
        try {
            URLConnection uc = this.makeRequest(url, inCookie);
            rval = this.receiveData(uc);
        }
        catch (FileNotFoundException fnfe) {
            rval = null;
        }
        catch (IOException e) {
            if (e.getMessage().indexOf("HTTP response code: 504") == -1) {
                JConfig.log().handleException("Error loading data URL (" + url.toString() + ')', e);
            } else {
                JConfig.log().logMessage("HTTP 504 error loading URL (" + url.toString() + ')');
            }
            rval = null;
        }
        return rval;
    }

    private ByteBuffer receiveData(URLConnection uc) throws IOException {
        InputStream is = uc.getInputStream();
        if ("gzip".equals(uc.getContentEncoding())) {
            is = new GZIPInputStream(is);
        }
        return this.receiveStream(is);
    }

    private ByteBuffer receiveStream(InputStream is) throws IOException {
        int curMax = 111821;
        byte[] mainBuf = new byte[curMax];
        int count = is.read(mainBuf, 0, curMax);
        int offset = 0;
        while (count != -1) {
            if (offset + count == curMax) {
                byte[] tmp = new byte[curMax *= 3];
                System.arraycopy(mainBuf, 0, tmp, 0, offset + count);
                mainBuf = tmp;
            }
            offset += count;
            try {
                count = is.read(mainBuf, offset, curMax - offset);
            }
            catch (EOFException badEnd) {
                JConfig.log().logDebug("Got a bad end of compressed input stream.");
                count = -1;
            }
        }
        is.close();
        return new ByteBuffer(mainBuf, offset);
    }

    @Override
    public StringBuffer get(String url) {
        try {
            HttpURLConnection huc = (HttpURLConnection)this.getPage(url);
            InputStream is = this.getStream(huc);
            if ("gzip".equals(huc.getContentEncoding())) {
                is = new GZIPInputStream(is);
            }
            ByteBuffer results = this.receiveStream(is);
            StringBuffer sb = this.convertByteBufferToStringBuffer(huc, results);
            if (huc.getResponseCode() / 100 > 3) {
                JConfig.log().logMessage("Failed to get " + url + ": " + sb);
                return null;
            }
            return sb;
        }
        catch (IOException ioe) {
            JConfig.log().logDebug("Got an exception reading " + url + ": " + ioe.getMessage());
            return null;
        }
    }

    @Override
    public StringBuffer receivePage(URLConnection uc) throws IOException {
        if (uc == null) {
            return null;
        }
        ByteBuffer buff = this.receiveData(uc);
        return this.convertByteBufferToStringBuffer(uc, buff);
    }

    private StringBuffer convertByteBufferToStringBuffer(URLConnection uc, ByteBuffer buff) throws UnsupportedEncodingException {
        if (buff == null) {
            return null;
        }
        String charset = uc.getContentType();
        if (charset != null && charset.matches(".*charset=([^;]*).*")) {
            charset = charset.replaceFirst(".*charset=([^;]*).*", "$1");
            return new StringBuffer(new String(buff.getData(), 0, buff.getLength(), charset));
        }
        return new StringBuffer(new String(buff.getData(), 0, buff.getLength()));
    }

    @Override
    public URLConnection getPage(String url) {
        return this.getPage(url, null, null, true);
    }

    @Override
    public URLConnection getPage(String url, String cookie, String referer, boolean followRedirects) {
        HttpURLConnection huc;
        try {
            URL authURL;
            URLConnection uc;
            if (JConfig.queryConfiguration("debug.urls", "false").equals("true")) {
                JConfig.log().logDebug("getPage: " + url);
            }
            if (!((uc = (authURL = JConfig.getURL(url)).openConnection()) instanceof HttpURLConnection)) {
                return uc;
            }
            huc = (HttpURLConnection)uc;
            huc.setInstanceFollowRedirects(followRedirects);
            this.setConnectionInfo(huc);
            this.setAgentAndEncoding(huc);
            if (referer != null) {
                huc.setRequestProperty("Referer", referer);
            }
            if (cookie != null) {
                huc.setRequestProperty("Cookie", cookie);
            }
        }
        catch (Exception e) {
            JConfig.log().handleException("getPage: " + e, e);
            huc = null;
        }
        return huc;
    }

    @Override
    public String putTo(String url, String sb) {
        HttpURLConnection huc = null;
        String result = null;
        try {
            huc = (HttpURLConnection)JConfig.getURL(url).openConnection();
            this.setConnectionInfo(huc);
            huc.setRequestProperty("Content-Type", "application/octet-stream");
            huc.setRequestProperty("Content-Length", Integer.toString(sb.length() - 1));
            huc.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.101 Safari/537.36");
            huc.setRequestMethod("PUT");
            huc.setDoOutput(true);
            huc.getOutputStream().write(sb.getBytes());
            result = StringTools.cat(huc.getInputStream());
        }
        catch (MalformedURLException murle) {
            JConfig.log().logMessage("Invalid URL!? (" + url + "): " + murle.getMessage());
        }
        catch (IOException ioe) {
            try {
                if (huc != null) {
                    result = StringTools.cat(huc.getErrorStream());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public String postTo(String url, Parameters params) {
        StringBuffer postData = null;
        try {
            postData = Http.createCGIData(params);
            URLConnection uc = this.postFormPage(url, postData.toString(), null, null, false);
            StringBuffer sb = this.receivePage(uc);
            return sb == null ? null : sb.toString();
        }
        catch (IOException e) {
            int length = 0;
            if (postData != null) {
                length = postData.length();
            }
            JConfig.log().logDebug("Couldn't send params (length: " + length + ") to " + url);
            JConfig.log().logDebug(e.getMessage());
            return null;
        }
    }

    private static StringBuffer createCGIData(Parameters data) throws UnsupportedEncodingException {
        StringBuffer postData = new StringBuffer();
        boolean first = true;
        for (Map.Entry param : data.entrySet()) {
            Object key = param.getKey();
            Object value = param.getValue();
            if (value == null) continue;
            if (!first) {
                postData.append('&');
            } else {
                first = false;
            }
            postData.append(key.toString());
            postData.append('=');
            postData.append(URLEncoder.encode(value.toString(), "UTF-8"));
        }
        return postData;
    }

    @Override
    public InputStream getStream(HttpURLConnection huc) {
        InputStream rval;
        if (huc == null) {
            return null;
        }
        try {
            int status = huc.getResponseCode();
            if (status / 100 == 4) {
                rval = huc.getErrorStream();
            } else if (status / 100 == 3) {
                String location = huc.getHeaderField("Location");
                huc = (HttpURLConnection)this.getPage(location);
                rval = huc.getInputStream();
            } else {
                rval = huc.getInputStream();
            }
        }
        catch (IOException e) {
            JConfig.log().logDebug("Error getting the stream from " + huc.getURL() + ": " + e.getMessage());
            rval = null;
        }
        return rval;
    }
}

