/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import org.jruby.ir.OpClass;

public enum Operation {
    NOP(0),
    JUMP(8),
    JUMP_INDIRECT(8),
    BEQ(8),
    BNE(8),
    B_UNDEF(8),
    B_NIL(8),
    B_TRUE(8),
    B_FALSE(8),
    RECV_SELF(0),
    RECV_PRE_REQD_ARG(1024),
    RECV_POST_REQD_ARG(1024),
    RECV_KW_ARG(1024),
    RECV_KW_REST_ARG(1024),
    RECV_REST_ARG(1024),
    RECV_OPT_ARG(1024),
    RECV_CLOSURE(1024),
    RECV_EXCEPTION(1024),
    CALL(515),
    NORESULT_CALL(515),
    SUPER(515),
    ZSUPER(515),
    YIELD(3),
    LAMBDA(515),
    RUNTIME_HELPER(515),
    CALL_1F(515),
    CALL_1O(515),
    CALL_0O(515),
    NORESULT_CALL_1O(515),
    RETURN(17),
    NONLOCAL_RETURN(17),
    BREAK(17),
    ALIAS(2051),
    GVAR_ALIAS(2051),
    DEF_MODULE(6145),
    DEF_CLASS(6145),
    DEF_META_CLASS(6145),
    DEF_INST_METH(6145),
    DEF_CLASS_METH(6145),
    PROCESS_MODULE_BODY(6145),
    UNDEF_METHOD(2051),
    LABEL(16388),
    EXC_REGION_START(16388),
    EXC_REGION_END(16388),
    LEXICAL_SEARCH_CONST(2),
    INHERITANCE_SEARCH_CONST(2),
    CONST_MISSING(2),
    SEARCH_CONST(2),
    GET_GLOBAL_VAR(128),
    GET_FIELD(128),
    GET_CVAR(130),
    BINDING_LOAD(128),
    MASGN_OPT(128),
    MASGN_REQD(128),
    MASGN_REST(128),
    PUT_CONST(257),
    PUT_GLOBAL_VAR(259),
    PUT_FIELD(257),
    PUT_ARRAY(257),
    PUT_CVAR(257),
    BINDING_STORE(257),
    ATTR_ASSIGN(259),
    LINE_NUM(16448),
    COPY(0),
    NOT(0),
    BLOCK_GIVEN(0),
    GET_OBJECT(0),
    GET_BACKREF(0),
    RESTORE_ERROR_INFO(1),
    RAISE_ARGUMENT_ERROR(2),
    CHECK_ARITY(16386),
    CHECK_ARGS_ARRAY_ARITY(2),
    RECORD_END_BLOCK(16385),
    TO_ARY(0),
    ENSURE_RUBY_ARRAY(0),
    THROW(35),
    MATCH(515),
    MATCH2(515),
    MATCH3(515),
    SET_RETADDR(0),
    CLASS_VAR_MODULE(0),
    IS_TRUE(0),
    EQQ(0),
    RESCUE_EQQ(2),
    THREAD_POLL(16385),
    GET_ENCODING(0),
    SET_WITHIN_DEFINED(1),
    DEFINED_CONSTANT_OR_METHOD(2),
    METHOD_DEFINED(2),
    BACKREF_IS_MATCH_DATA(0),
    CLASS_VAR_IS_DEFINED(0),
    GLOBAL_IS_DEFINED(0),
    HAS_INSTANCE_VAR(0),
    IS_METHOD_BOUND(0),
    METHOD_IS_PUBLIC(0),
    SUPER_METHOD_BOUND(0),
    GET_ERROR_INFO(0),
    MODULE_GUARD(8),
    PUSH_FRAME(16385),
    PUSH_BINDING(16385),
    POP_FRAME(16385),
    POP_BINDING(16385),
    METHOD_LOOKUP(0),
    BOX_VALUE(0),
    UNBOX_VALUE(0);

    public final OpClass opClass;
    private int flags;

    private Operation(int flags) {
        this.flags = flags;
        this.opClass = this.isArgReceive() ? OpClass.ARG_OP : (this.isBranch() ? OpClass.BRANCH_OP : (this.isBookKeepingOp() ? OpClass.BOOK_KEEPING_OP : (this.isCall() ? OpClass.CALL_OP : OpClass.OTHER_OP)));
    }

    public boolean transfersControl() {
        return (this.flags & 0x38) > 0;
    }

    public boolean isLoad() {
        return (this.flags & 0x80) > 0;
    }

    public boolean isStore() {
        return (this.flags & 0x100) > 0;
    }

    public boolean isCall() {
        return (this.flags & 0x200) > 0;
    }

    public boolean isBranch() {
        return (this.flags & 8) > 0;
    }

    public boolean isReturn() {
        return (this.flags & 0x10) > 0;
    }

    public boolean isException() {
        return (this.flags & 0x20) > 0;
    }

    public boolean isArgReceive() {
        return (this.flags & 0x400) > 0;
    }

    public boolean startsBasicBlock() {
        return this == LABEL;
    }

    public boolean endsBasicBlock() {
        return this.transfersControl();
    }

    public boolean hasSideEffects() {
        return (this.flags & 1) > 0;
    }

    public boolean isDebugOp() {
        return (this.flags & 0x40) > 0;
    }

    public boolean isBookKeepingOp() {
        return (this.flags & 0x4000) > 0;
    }

    public boolean canRaiseException() {
        return (this.flags & 2) > 0;
    }

    public boolean modifiesCode() {
        return (this.flags & 0x800) > 0;
    }

    public boolean inlineUnfriendly() {
        return (this.flags & 0x1000) > 0;
    }

    public String toString() {
        return this.name().toLowerCase();
    }
}

