/*
 * Decompiled with CFR 0.152.
 */
package com.orbus.mahalo;

import com.orbus.mahalo.ServiceState;
import com.orbus.mahalo.dns.DNSEntry;
import com.orbus.mahalo.dns.DNSRecord;
import java.net.InetAddress;
import java.net.SocketException;

public class HostInfo {
    private InetAddress _Address;
    private String _sOriginalName;
    private String _sName;
    private ServiceState _eState = ServiceState.PROBING_1;
    private int _iHostNameCount = 1;

    public HostInfo(InetAddress aAddress, String asName) throws IllegalArgumentException, SocketException {
        if (aAddress == null || asName == null) {
            throw new IllegalArgumentException("Niether aAddress nor asName can be null.");
        }
        if (asName.indexOf(46) >= 0) {
            throw new IllegalArgumentException("asName (" + asName + ") should be a pure host name and not contain dots. (.local. will be added automatically).");
        }
        this._Address = aAddress;
        this._sOriginalName = asName;
        this._sName = asName + ".local.";
    }

    public synchronized void advanceState() {
        this._eState = this._eState.advance();
    }

    public synchronized void revertState() {
        this._eState = this._eState.revert();
    }

    public final ServiceState getState() {
        return this._eState;
    }

    public String getName() {
        return this._sName;
    }

    public InetAddress getAddress() {
        return this._Address;
    }

    public void incrementHostName() {
        ++this._iHostNameCount;
        this._sName = this._sOriginalName + "-" + this._iHostNameCount;
    }

    public DNSRecord.Address getDNSAddressRecord(DNSEntry.EntryType aeType) {
        return aeType == DNSEntry.EntryType.A ? this.getDNS4AddressRecord() : this.getDNS6AddressRecord();
    }

    private DNSRecord.Address getDNS4AddressRecord() {
        return new DNSRecord.Address(this.getName(), DNSEntry.EntryType.A, DNSEntry.EntryClass.IN, true, 3600, this.getAddress());
    }

    private DNSRecord.Address getDNS6AddressRecord() {
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("local host info[");
        buf.append(this.getName());
        buf.append(", ");
        buf.append(":");
        buf.append(this.getAddress().getHostAddress());
        buf.append("]");
        return buf.toString();
    }
}

