/*
 * Decompiled with CFR 0.152.
 */
package com.orbus.mahalo.dns;

import com.orbus.mahalo.dns.DNSEntry;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;

public abstract class DNSRecord {
    protected DNSEntry _Entry;
    protected int _iTTL;
    private long _iCreated = System.currentTimeMillis();

    public DNSEntry.EntryType getType() {
        return this._Entry.getType();
    }

    public DNSEntry.EntryClass getDNSClass() {
        return this._Entry.getDNSClass();
    }

    public boolean isAuthoritative() {
        return this._Entry.getUnique();
    }

    public String getName() {
        return this._Entry.getName();
    }

    public int getTTL() {
        return this._iTTL;
    }

    DNSRecord() {
    }

    DNSRecord(String asName, DNSEntry.EntryType aeType, DNSEntry.EntryClass aeClass, boolean abUnique, int aiTTL) {
        this();
        this._Entry = new DNSEntry(asName, aeType, aeClass, abUnique);
        this._iTTL = aiTTL;
    }

    public boolean equals(Object other) {
        return other instanceof DNSRecord && this.sameAs((DNSRecord)other);
    }

    boolean sameAs(DNSRecord other) {
        return this._Entry.equals(other._Entry) && this.sameValue(other);
    }

    abstract boolean sameValue(DNSRecord var1);

    long getExpirationTime(int percent) {
        return this._iCreated + (long)(percent * this._iTTL) * 10L;
    }

    int getRemainingTTL(long now) {
        return (int)Math.max(0L, (this.getExpirationTime(100) - now) / 1000L);
    }

    public boolean isExpired(long now) {
        return this.getExpirationTime(100) <= now;
    }

    boolean isStale(long now) {
        return this.getExpirationTime(50) <= now;
    }

    void resetTTL(DNSRecord other) {
        this._iCreated = other._iCreated;
        this._iTTL = other._iTTL;
    }

    public void write(ByteBuffer aBuffer) {
        long now = System.currentTimeMillis();
        this._Entry.write(aBuffer);
        aBuffer.putInt(this.getRemainingTTL(now));
    }

    abstract void parseInstance(ByteBuffer var1, int var2) throws IOException;

    public static DNSRecord Parse(ByteBuffer aBuffer) throws IOException {
        DNSEntry internalEntry;
        DNSRecord record = null;
        try {
            internalEntry = DNSEntry.Parse(aBuffer);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        int ttl = aBuffer.getInt();
        int len = DNSEntry.getUnsignedShort(aBuffer);
        assert (len != 0);
        switch (internalEntry._eType) {
            case A: 
            case AAAA: {
                record = new Address();
                break;
            }
            case CNAME: 
            case PTR: {
                record = new Pointer();
                break;
            }
            case TXT: {
                record = new Text();
                break;
            }
            case SRV: {
                record = new Service();
                break;
            }
            case HINFO: {
                break;
            }
        }
        int curPosition = aBuffer.position();
        if (record != null) {
            try {
                record._Entry = internalEntry;
                record._iTTL = ttl;
                record.parseInstance(aBuffer, len);
            }
            catch (Exception e) {
                record = null;
                aBuffer.position(curPosition + len);
            }
        } else {
            try {
                aBuffer.position(curPosition + len);
            }
            catch (IllegalArgumentException iae) {
                System.err.println("Ignoring bad positioning for buffer.");
            }
        }
        return record;
    }

    public String toString() {
        return "record" + this._Entry.toString() + this.getRemainingTTL(System.currentTimeMillis()) + "/" + this._iTTL;
    }

    public static class Service
    extends DNSRecord {
        int _iPriority;
        int _iWeight;
        int _iPort;
        String _sServer;

        public Service() {
        }

        public Service(String asName, DNSEntry.EntryClass aeClass, boolean abUnique, int aiTTL, int aiPriority, int aiWeight, int aiPort, String asServer) {
            super(asName, DNSEntry.EntryType.SRV, aeClass, abUnique, aiTTL);
            this._iPriority = aiPriority;
            this._iWeight = aiWeight;
            this._iPort = aiPort;
            this._sServer = asServer;
        }

        public int getPort() {
            return this._iPort;
        }

        public int getWeight() {
            return this._iWeight;
        }

        public int getPriority() {
            return this._iPriority;
        }

        public String getServer() {
            return this._sServer;
        }

        public void write(ByteBuffer aBuffer) {
            super.write(aBuffer);
            int ilengthOffset = aBuffer.position();
            aBuffer.putShort((short)0);
            aBuffer.putShort((short)this._iPriority);
            aBuffer.putShort((short)this._iWeight);
            aBuffer.putShort((short)this._iPort);
            int inameLength = DNSEntry.writeDNSName(aBuffer, this._sServer);
            aBuffer.putShort(ilengthOffset, (short)(6 + inameLength));
        }

        private byte[] toByteArray() {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                DataOutputStream dout = new DataOutputStream(bout);
                dout.write(this._Entry.toByteArray());
                dout.writeShort(this._iPriority);
                dout.writeShort(this._iWeight);
                dout.writeShort(this._iPort);
                dout.write(this._sServer.getBytes("UTF8"));
                dout.close();
                return bout.toByteArray();
            }
            catch (IOException e) {
                throw new InternalError();
            }
        }

        private int lexCompare(Service that) {
            byte[] thisBytes = this.toByteArray();
            byte[] thatBytes = that.toByteArray();
            int n = Math.min(thisBytes.length, thatBytes.length);
            for (int i = 0; i < n; ++i) {
                if (thisBytes[i] > thatBytes[i]) {
                    return 1;
                }
                if (thisBytes[i] >= thatBytes[i]) continue;
                return -1;
            }
            return thisBytes.length - thatBytes.length;
        }

        public boolean sameValue(DNSRecord other) {
            Service s = (Service)other;
            return this._iPriority == s._iPriority && this._iWeight == s._iWeight && this._iPort == s._iPort && this._sServer.equals(s._sServer);
        }

        public void parseInstance(ByteBuffer aBuffer, int aiLength) throws IOException {
            this._iPriority = DNSEntry.getUnsignedShort(aBuffer);
            this._iWeight = DNSEntry.getUnsignedShort(aBuffer);
            this._iPort = DNSEntry.getUnsignedShort(aBuffer);
            this._sServer = DNSEntry.getDNSName(aBuffer);
        }

        public String toString() {
            return super.toString() + "," + this._sServer + ":" + this._iPort;
        }
    }

    public static class Text
    extends DNSRecord {
        byte[] _Text;

        Text() {
        }

        public byte[] getTextBytes() {
            return this._Text;
        }

        public Text(String asName, DNSEntry.EntryClass aeClass, boolean abUnique, int aiTTL, byte[] aText) {
            super(asName, DNSEntry.EntryType.TXT, aeClass, abUnique, aiTTL);
            this._Text = aText;
        }

        public void write(ByteBuffer aBuffer) {
            super.write(aBuffer);
            aBuffer.putShort((short)this._Text.length);
            aBuffer.put(this._Text);
        }

        boolean sameValue(DNSRecord other) {
            Text txt = (Text)other;
            if (txt._Text.length != this._Text.length) {
                return false;
            }
            int i = this._Text.length;
            while (i-- > 0) {
                if (txt._Text[i] == this._Text[i]) continue;
                return false;
            }
            return true;
        }

        public void parseInstance(ByteBuffer aBuffer, int aiLength) throws IOException {
            this._Text = new byte[aiLength];
            aBuffer.get(this._Text);
        }

        public String toString() {
            return super.toString() + "," + (this._Text.length > 10 ? new String(this._Text, 0, 7) + "..." : new String(this._Text));
        }
    }

    public static class Pointer
    extends DNSRecord {
        String _sAlias;

        Pointer() {
        }

        public Pointer(String asName, DNSEntry.EntryType aeType, DNSEntry.EntryClass aeClass, int aiTTL, String asAlias) throws IllegalArgumentException {
            super(asName, aeType, aeClass, false, aiTTL);
            if (aeType != DNSEntry.EntryType.PTR && aeType != DNSEntry.EntryType.CNAME) {
                throw new IllegalArgumentException("aeType must be either PTR or CNAME for a Pointer record.");
            }
            this._sAlias = asAlias;
        }

        public void write(ByteBuffer aBuffer) {
            super.write(aBuffer);
            int ilengthOffset = aBuffer.position();
            aBuffer.putShort((short)0);
            int ilength = DNSEntry.writeDNSName(aBuffer, this._sAlias);
            aBuffer.putShort(ilengthOffset, (short)ilength);
        }

        boolean sameValue(DNSRecord other) {
            return this._sAlias.equals(((Pointer)other)._sAlias);
        }

        public String getAlias() {
            return this._sAlias;
        }

        public String toString() {
            return super.toString() + "," + this._sAlias;
        }

        public void parseInstance(ByteBuffer aBuffer, int aiLength) throws IOException {
            this._sAlias = DNSEntry.getDNSName(aBuffer);
        }
    }

    public static class Address
    extends DNSRecord {
        private InetAddress _Addr;

        Address() {
        }

        public Address(String asName, DNSEntry.EntryType aeType, DNSEntry.EntryClass aeClass, boolean abUnique, int aiTTL, InetAddress aAddr) throws IllegalArgumentException {
            super(asName, aeType, aeClass, abUnique, aiTTL);
            if (aeType != DNSEntry.EntryType.A && aeType != DNSEntry.EntryType.AAAA) {
                throw new IllegalArgumentException("aeType must be either A or AAAA for an Address record.");
            }
            if (aAddr == null) {
                throw new IllegalArgumentException("Address can not be null.");
            }
            this._Addr = aAddr;
        }

        public void write(ByteBuffer aBuffer) {
            super.write(aBuffer);
            byte[] byteAddress = this._Addr.getAddress();
            switch (this._Entry._eType) {
                case A: {
                    if (this._Addr instanceof Inet4Address) break;
                    byte[] temp = byteAddress;
                    byteAddress = new byte[4];
                    System.arraycopy(temp, 12, byteAddress, 0, 4);
                    break;
                }
                case AAAA: {
                    if (!(this._Addr instanceof Inet4Address)) break;
                    byte[] temp = byteAddress;
                    byteAddress = new byte[16];
                    for (int i = 0; i < 16; ++i) {
                        byteAddress[i] = i < 11 ? temp[i - 12] : (byte)0;
                    }
                    break;
                }
            }
            aBuffer.putShort((short)byteAddress.length);
            aBuffer.put(byteAddress);
        }

        public boolean sameName(DNSRecord other) {
            return this._Entry._sName.equalsIgnoreCase(((Address)other)._Entry._sName);
        }

        public boolean sameValue(DNSRecord other) {
            return this._Addr.equals(((Address)other).getAddress());
        }

        public InetAddress getAddress() {
            return this._Addr;
        }

        public void parseInstance(ByteBuffer aBuffer, int aiLength) throws IOException {
            byte[] address = new byte[aiLength];
            aBuffer.get(address);
            this._Addr = InetAddress.getByAddress(address);
        }

        private byte[] toByteArray() {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                DataOutputStream dout = new DataOutputStream(bout);
                dout.write(this._Entry.toByteArray());
                byte[] buffer = this._Addr.getAddress();
                for (int i = 0; i < buffer.length; ++i) {
                    dout.writeByte(buffer[i]);
                }
                dout.close();
                return bout.toByteArray();
            }
            catch (IOException e) {
                throw new InternalError();
            }
        }

        private int lexCompare(Address that) {
            byte[] thisBytes = this.toByteArray();
            byte[] thatBytes = that.toByteArray();
            int n = Math.min(thisBytes.length, thatBytes.length);
            for (int i = 0; i < n; ++i) {
                if (thisBytes[i] > thatBytes[i]) {
                    return 1;
                }
                if (thisBytes[i] >= thatBytes[i]) continue;
                return -1;
            }
            return thisBytes.length - thatBytes.length;
        }

        public String toString() {
            return super.toString() + ", address '" + this._Addr.getHostAddress() + "'";
        }
    }
}

