/*
 * Decompiled with CFR 0.152.
 */
package com.orbus.mahalo.tasks;

import com.orbus.mahalo.HostInfo;
import com.orbus.mahalo.MahaloSocket;
import com.orbus.mahalo.ServiceInfo;
import com.orbus.mahalo.dns.DNSEntry;
import com.orbus.mahalo.dns.DNSPacket;
import com.orbus.mahalo.dns.DNSRecord;
import java.util.LinkedList;
import java.util.List;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Canceler
extends TimerTask {
    public static final int INTERVAL = 1000;
    private MahaloSocket _Socket;
    private HostInfo _LocalInfo;
    private int _iCount = 0;
    private List<ServiceInfo> _LocalServices;

    public Canceler(MahaloSocket aSocket, HostInfo aLocalInfo, List<ServiceInfo> aServices) {
        this._Socket = aSocket;
        this._LocalInfo = aLocalInfo;
        this._LocalServices = new LinkedList<ServiceInfo>(aServices);
    }

    @Override
    public void run() {
        ++this._iCount;
        DNSPacket outPacket = new DNSPacket(true);
        outPacket.setAuthoritativeAnswer(true);
        for (ServiceInfo info : this._LocalServices) {
            outPacket.addAnswer(new DNSRecord.Pointer(info.getType(), DNSEntry.EntryType.PTR, DNSEntry.EntryClass.IN, 0, info.getQualifiedName()));
            outPacket.addAnswer(new DNSRecord.Service(info.getQualifiedName(), DNSEntry.EntryClass.IN, true, 0, info.getPriority(), info.getWeight(), info.getPort(), this._LocalInfo.getName()));
            outPacket.addAnswer(new DNSRecord.Text(info.getQualifiedName(), DNSEntry.EntryClass.IN, true, 0, info.getTextBytes()));
        }
        this._Socket.send(outPacket);
        if (this._iCount == 2) {
            this.cancel();
        }
    }

    @Override
    public synchronized boolean cancel() {
        boolean bresult = super.cancel();
        this.notifyAll();
        return bresult;
    }
}

