/*
 * Decompiled with CFR 0.152.
 */
package com.orbus.mahalo.dns;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Hashtable;

public class DNSEntry {
    public static final int TTL = 3600;
    private static final Charset s_Charset = Charset.forName("UTF-8");
    private static final int CLASS_MASK = Short.MAX_VALUE;
    private static final int CLASS_UNIQUE = 32768;
    protected String _sKey;
    protected String _sName;
    protected EntryType _eType;
    protected EntryClass _eClass;
    protected boolean _bUnique;

    DNSEntry() {
    }

    DNSEntry(String asName, EntryType aeType, EntryClass aeClass, boolean abUnique) {
        this._sKey = asName.toLowerCase();
        this._sName = asName;
        this._eType = aeType;
        this._eClass = aeClass;
        this._bUnique = abUnique;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DNSEntry) {
            DNSEntry other = (DNSEntry)obj;
            return this._sName.equals(other._sName) && this._eType == other._eType && this._eClass == other._eClass;
        }
        return false;
    }

    public String getName() {
        return this._sName;
    }

    public EntryType getType() {
        return this._eType;
    }

    public EntryClass getDNSClass() {
        return this._eClass;
    }

    public boolean getUnique() {
        return this._bUnique;
    }

    public void setUnique(boolean abValue) {
        this._bUnique = abValue;
    }

    public byte[] toByteArray() {
        byte[] bytes = null;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.write(this._sName.getBytes("UTF8"));
            dout.writeShort(this._eType.getValue());
            dout.writeShort(this._eClass.getValue());
            bytes = bout.toByteArray();
            dout.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bytes;
    }

    public void write(ByteBuffer aBuffer) {
        DNSEntry.writeDNSName(aBuffer, this._sName);
        aBuffer.putShort((short)this._eType.getValue());
        aBuffer.putShort((short)(this._eClass.getValue() | (this._bUnique ? 32768 : 0)));
    }

    public int hashCode() {
        return this._sName.hashCode() + this._eType.getValue() + this._eClass.getValue();
    }

    public String toString() {
        return "[" + this._eType.getRecord() + "," + this._eClass.getRecord() + (this._bUnique ? "-unique," : ",") + this._sName + "]";
    }

    public static int writeDNSName(ByteBuffer aBuffer, String asName) {
        String[] sparts;
        int ilength = 0;
        for (String part : sparts = asName.split("\\.")) {
            int iarrayLength;
            byte[] bytes = s_Charset.encode(part).array();
            if (bytes[(iarrayLength = bytes.length) - 1] == 0) {
                --iarrayLength;
            }
            aBuffer.put((byte)iarrayLength);
            ++ilength;
            aBuffer.put(bytes, 0, iarrayLength);
            ilength += iarrayLength;
        }
        aBuffer.put((byte)0);
        return ++ilength;
    }

    public static String getDNSName(ByteBuffer aBuffer) throws IOException {
        StringBuffer buf = new StringBuffer();
        int next = -1;
        int first = aBuffer.position();
        byte len = aBuffer.get();
        while (len != 0) {
            switch (len & 0xC0) {
                case 0: {
                    byte[] bytes = new byte[len];
                    aBuffer.get(bytes);
                    buf.append(s_Charset.decode(ByteBuffer.wrap(bytes)));
                    buf.append('.');
                    break;
                }
                case 192: {
                    if (next < 0) {
                        next = aBuffer.position() + 1;
                    }
                    int nextPos = (len & 0x3F) << 8 | aBuffer.get();
                    aBuffer.position(nextPos);
                    if (aBuffer.position() >= first) {
                        throw new IOException("bad domain name: possible circular name detected");
                    }
                    first = aBuffer.position();
                    break;
                }
                default: {
                    throw new IOException("Bad length on name!");
                }
            }
            len = aBuffer.get();
        }
        if (next > 0) {
            aBuffer.position(next);
        }
        return buf.toString();
    }

    public static int getUnsignedShort(ByteBuffer aBuffer) {
        return ((aBuffer.get() & 0xFF) << 8) + (aBuffer.get() & 0xFF);
    }

    public static DNSEntry Parse(ByteBuffer aBuffer) throws IOException {
        DNSEntry entry = new DNSEntry();
        entry._sKey = DNSEntry.getDNSName(aBuffer);
        entry._sName = entry._sKey.toLowerCase();
        entry._eType = EntryType.Parse(aBuffer.getShort());
        short classAndUnique = aBuffer.getShort();
        entry._eClass = EntryClass.Parse(classAndUnique & Short.MAX_VALUE);
        entry._bUnique = (classAndUnique & 0x8000) != 0;
        return entry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntryClass {
        IN("in", 1),
        CS("cs", 2),
        CH("ch", 3),
        HS("hs", 4),
        NONE("none", 254),
        ANY("any", 255);

        private static Hashtable<Integer, EntryClass> parseTable;
        private final String _sName;
        private final int _iValue;

        private EntryClass(String asName, int aiValue) {
            this._sName = asName;
            this._iValue = aiValue;
        }

        public String getRecord() {
            return this._sName;
        }

        public int getValue() {
            return this._iValue;
        }

        public static EntryClass Parse(int aiValue) {
            return parseTable.get(aiValue);
        }

        static {
            parseTable = new Hashtable();
            for (EntryClass type : EntryClass.values()) {
                parseTable.put(type._iValue, type);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntryType {
        NONE("none", 0),
        A("a", 1),
        NS("ns", 2),
        MD("md", 3),
        MF("mf", 4),
        CNAME("cname", 5),
        SOA("soa", 6),
        MB("mb", 7),
        MG("mg", 8),
        MR("mr", 9),
        NULL("nukk", 10),
        WKS("wks", 11),
        PTR("ptr", 12),
        HINFO("hinfo", 13),
        MINFO("minfo", 14),
        MX("mx", 15),
        TXT("txt", 16),
        AAAA("quada", 28),
        SRV("srv", 33),
        NSEC("nsec", 47),
        ANY("any", 255);

        private static Hashtable<Integer, EntryType> parseTable;
        private final String _sRecord;
        private final int _iValue;

        private EntryType(String asRecord, int aiType) {
            this._sRecord = asRecord;
            this._iValue = aiType;
        }

        public String getRecord() {
            return this._sRecord;
        }

        public int getValue() {
            return this._iValue;
        }

        public static EntryType Parse(int aiValue) {
            EntryType rval = parseTable.get(aiValue);
            if (rval == null) {
                rval = NONE;
            }
            return rval;
        }

        static {
            parseTable = new Hashtable();
            for (EntryType type : EntryType.values()) {
                parseTable.put(type._iValue, type);
            }
        }
    }
}

