/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tessboxeditor;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import net.sourceforge.tessboxeditor.GuiWithTrainer;
import net.sourceforge.vietocr.OCR;
import net.sourceforge.vietocr.OCRFiles;
import net.sourceforge.vietpad.components.SimpleFilter;

public class GuiWithValidator
extends GuiWithTrainer {
    private JFileChooser jFileChooserValidatingImage;
    private OcrWorker ocrWorker;
    private static final Logger logger = Logger.getLogger(GuiWithValidator.class.getName());

    public GuiWithValidator() {
        this.initComponents();
    }

    private void initComponents() {
        this.jFileChooserValidatingImage = new JFileChooser();
        this.jFileChooserValidatingImage.setAcceptAllFileFilterUsed(false);
        this.jFileChooserValidatingImage.setApproveButtonText("Select");
        this.jFileChooserValidatingImage.setDialogTitle("Select Image File");
        SimpleFilter simpleFilter = new SimpleFilter("bmp;jpg;jpeg;png;tif;tiff", "All Images");
        this.jFileChooserValidatingImage.setFileFilter(simpleFilter);
    }

    @Override
    void jButtonValidateActionPerformed(ActionEvent actionEvent) {
        File file = new File(this.trainDataDirectory, "tessdata");
        String string = this.jTextFieldLang.getText();
        File file2 = new File(file, string + ".traineddata");
        if (!file2.exists()) {
            String string2 = String.format("%s.traineddata does not exist in %s. Be sure to run training first.", string, file.getPath());
            JOptionPane.showMessageDialog(this, string2, "Train Tesseract", 0);
            return;
        }
        this.jFileChooserValidatingImage.setCurrentDirectory(this.trainDataDirectory == null ? null : new File(this.trainDataDirectory));
        if (this.jFileChooserValidatingImage.showOpenDialog(this) == 0) {
            this.jButtonValidate.setEnabled(false);
            this.jTextAreaValidationResult.setText(null);
            this.jLabelStatus.setText(this.bundle.getString("OCR_running..."));
            this.jProgressBar1.setIndeterminate(true);
            this.jProgressBar1.setString(this.bundle.getString("OCR_running..."));
            this.jProgressBar1.setVisible(true);
            this.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            this.getGlassPane().setVisible(true);
            File file3 = this.jFileChooserValidatingImage.getSelectedFile();
            ArrayList<File> arrayList = new ArrayList<File>();
            arrayList.add(file3);
            this.ocrWorker = new OcrWorker(arrayList);
            this.ocrWorker.execute();
        }
    }

    @Override
    void jButtonCloseDialogActionPerformed(ActionEvent actionEvent) {
        this.jDialogValidationResult.setVisible(false);
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GuiWithValidator().setVisible(true);
            }
        });
    }

    class OcrWorker
    extends SwingWorker<Void, String> {
        List<File> files;

        OcrWorker(List<File> list) {
            this.files = list;
        }

        @Override
        protected Void doInBackground() throws Exception {
            OCRFiles oCRFiles = new OCRFiles(GuiWithValidator.this.tessDirectory);
            oCRFiles.setDatapath(GuiWithValidator.this.trainDataDirectory);
            oCRFiles.setLanguage(GuiWithValidator.this.jTextFieldLang.getText());
            for (int i = 0; i < this.files.size(); ++i) {
                if (this.isCancelled()) continue;
                String string = ((OCR)oCRFiles).recognizeText(this.files.subList(i, i + 1));
                this.publish(string);
            }
            return null;
        }

        @Override
        protected void process(List<String> list) {
            for (String string : list) {
                GuiWithValidator.this.jTextAreaValidationResult.append(string);
                GuiWithValidator.this.jTextAreaValidationResult.setCaretPosition(GuiWithValidator.this.jTextAreaValidationResult.getDocument().getLength());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            GuiWithValidator.this.jProgressBar1.setIndeterminate(false);
            try {
                this.get();
                GuiWithValidator.this.jLabelStatus.setText(GuiWithValidator.this.bundle.getString("OCR_completed."));
                GuiWithValidator.this.jProgressBar1.setString(GuiWithValidator.this.bundle.getString("OCR_completed."));
            }
            catch (InterruptedException interruptedException) {
                logger.log(Level.WARNING, interruptedException.getMessage(), interruptedException);
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                String string = throwable != null ? (throwable instanceof IOException ? GuiWithValidator.this.bundle.getString("Cannot_find_Tesseract._Please_set_its_path.") : (throwable instanceof FileNotFoundException ? GuiWithValidator.this.bundle.getString("An_exception_occurred_in_Tesseract_engine_while_recognizing_this_image.") : throwable.getMessage())) : executionException.getMessage();
                logger.log(Level.SEVERE, string, executionException);
                GuiWithValidator.this.jLabelStatus.setText(null);
                GuiWithValidator.this.jProgressBar1.setString(null);
                JOptionPane.showMessageDialog(null, string, "Train Tesseract", 0);
            }
            catch (CancellationException cancellationException) {
                logger.log(Level.WARNING, cancellationException.getMessage(), cancellationException);
                GuiWithValidator.this.jLabelStatus.setText("OCR " + GuiWithValidator.this.bundle.getString("canceled"));
                GuiWithValidator.this.jProgressBar1.setString("OCR " + GuiWithValidator.this.bundle.getString("canceled"));
            }
            finally {
                GuiWithValidator.this.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                GuiWithValidator.this.getGlassPane().setVisible(false);
                GuiWithValidator.this.jButtonValidate.setEnabled(true);
                GuiWithValidator.this.jDialogValidationResult.setVisible(true);
            }
        }
    }
}

