/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tessboxeditor.components;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RowHeaderList
extends JList {
    JTable table;
    RowHeaderRenderer render;

    public RowHeaderList(final JTable jTable) {
        this.table = jTable;
        this.setFixedCellWidth(50);
        this.setFixedCellHeight(jTable.getRowHeight());
        this.render = new RowHeaderRenderer();
        this.setCellRenderer(this.render);
        this.setSelectionModel(jTable.getSelectionModel());
        this.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = RowHeaderList.this.getSelectedIndex();
                    Rectangle rectangle = jTable.getCellRect(n, 0, true);
                    jTable.scrollRectToVisible(rectangle);
                }
            }
        });
        AbstractListModel abstractListModel = new AbstractListModel(){

            @Override
            public int getSize() {
                return jTable.getRowCount();
            }

            @Override
            public Object getElementAt(int n) {
                return n + 1;
            }
        };
        this.setModel(abstractListModel);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.setFixedCellWidth(fontMetrics.stringWidth("4444") + 8);
        if (this.table != null) {
            this.setFixedCellHeight(this.table.getRowHeight());
        }
        if (this.render != null) {
            this.render.setFont(font);
        }
    }

    class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer {
        public RowHeaderRenderer() {
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(object == null ? "" : object.toString());
            return this;
        }
    }
}

