/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.util.LineWriter;
import net.sourceforge.schemaspy.view.HtmlFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlMultipleSchemasIndexPage
extends HtmlFormatter {
    private static HtmlMultipleSchemasIndexPage instance = new HtmlMultipleSchemasIndexPage();

    private HtmlMultipleSchemasIndexPage() {
    }

    public static HtmlMultipleSchemasIndexPage getInstance() {
        return instance;
    }

    public void write(String string, List<String> list, DatabaseMetaData databaseMetaData, LineWriter lineWriter) throws IOException {
        this.writeHeader(string, databaseMetaData, list.size(), false, list.get(0).toString(), lineWriter);
        for (String string2 : list) {
            this.writeLineItem(string2, lineWriter);
        }
        this.writeFooter(lineWriter);
    }

    private void writeHeader(String string, DatabaseMetaData databaseMetaData, int n, boolean bl, String string2, LineWriter lineWriter) throws IOException {
        String string3 = new SimpleDateFormat("EEE MMM dd HH:mm z yyyy").format(new Date());
        lineWriter.writeln("<!DOCTYPE HTML PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN' 'http://www.w3.org/TR/html4/loose.dtd'>");
        lineWriter.writeln("<html>");
        lineWriter.writeln("<head>");
        lineWriter.write("  <title>SchemaSpy Analysis");
        if (string != null) {
            lineWriter.write(" of Database ");
            lineWriter.write(string);
        }
        lineWriter.writeln("</title>");
        lineWriter.write("  <link rel=stylesheet href='");
        lineWriter.write(string2);
        lineWriter.writeln("/schemaSpy.css' type='text/css'>");
        lineWriter.writeln("  <meta HTTP-EQUIV='Content-Type' CONTENT='text/html; charset=" + Config.getInstance().getCharset() + "'>");
        lineWriter.writeln("</head>");
        lineWriter.writeln("<body>");
        this.writeTableOfContents(lineWriter);
        lineWriter.writeln("<div class='content' style='clear:both;'>");
        lineWriter.writeln("<table width='100%' border='0' cellpadding='0'>");
        lineWriter.writeln(" <tr>");
        lineWriter.write("  <td class='heading' valign='top'><h1>");
        lineWriter.write("SchemaSpy Analysis");
        if (string != null) {
            lineWriter.write(" of Database ");
            lineWriter.write(string);
        }
        lineWriter.writeln("</h1></td>");
        lineWriter.writeln("  <td class='heading' align='right' valign='top' title='John Currier - Creator of Cool Tools'><span class='indent'>Generated by</span><br><span class='indent'><span class='signature'><a href='http://schemaspy.sourceforge.net' target='_blank'>SchemaSpy</a></span></span></td>");
        lineWriter.writeln(" </tr>");
        lineWriter.writeln("</table>");
        lineWriter.writeln("<table width='100%'>");
        lineWriter.writeln(" <tr><td class='container'>");
        this.writeGeneratedBy(string3, lineWriter);
        lineWriter.writeln(" </td></tr>");
        lineWriter.writeln(" <tr>");
        lineWriter.write("  <td class='container'>");
        if (databaseMetaData != null) {
            lineWriter.write("Database Type: ");
            lineWriter.write(this.getDatabaseProduct(databaseMetaData));
        }
        lineWriter.writeln("  </td>");
        lineWriter.writeln("  <td class='container' align='right' valign='top' rowspan='3'>");
        if (this.sourceForgeLogoEnabled()) {
            lineWriter.writeln("    <a href='http://sourceforge.net' target='_blank'><img src='http://sourceforge.net/sflogo.php?group_id=137197&amp;type=1' alt='SourceForge.net' border='0' height='31' width='88'></a><br>");
        }
        lineWriter.write("    <br>");
        this.writeFeedMe(lineWriter);
        lineWriter.writeln("  </td>");
        lineWriter.writeln(" </tr>");
        lineWriter.writeln("</table>");
        lineWriter.writeln("<div class='indent'>");
        lineWriter.write("<b>");
        lineWriter.write(String.valueOf(n));
        if (string != null) {
            lineWriter.write(" Schema");
        } else {
            lineWriter.write(" Database");
        }
        lineWriter.write(n == 1 ? "" : "s");
        lineWriter.writeln(":</b>");
        lineWriter.writeln("<TABLE class='dataTable' border='1' rules='groups'>");
        lineWriter.writeln("<colgroup>");
        lineWriter.writeln("<thead align='left'>");
        lineWriter.writeln("<tr>");
        lineWriter.write("  <th valign='bottom'>");
        if (string != null) {
            lineWriter.write("Schema");
        } else {
            lineWriter.write("Database");
        }
        lineWriter.writeln("</th>");
        if (bl) {
            lineWriter.writeln("  <th align='center' valign='bottom'>ID</th>");
        }
        lineWriter.writeln("</tr>");
        lineWriter.writeln("</thead>");
        lineWriter.writeln("<tbody>");
    }

    private void writeLineItem(String string, LineWriter lineWriter) throws IOException {
        lineWriter.writeln(" <tr>");
        lineWriter.write("  <td class='detail'><a href='");
        lineWriter.write(string);
        lineWriter.write("/index.html'>");
        lineWriter.write(string);
        lineWriter.writeln("</a></td>");
        lineWriter.writeln(" </tr>");
    }

    protected void writeTableOfContents(LineWriter lineWriter) throws IOException {
        lineWriter.writeln("<table id='headerHolder' cellspacing='0' cellpadding='0'><tr><td>");
        lineWriter.writeln("<div id='header'>");
        lineWriter.writeln(" <ul>");
        lineWriter.writeln("  <li id='current'><a href='index.html' title='All user schemas in the database'>Schemas</a></li>");
        lineWriter.writeln("  <li><a href='http://sourceforge.net/donate/index.php?group_id=137197' title='Please help keep SchemaSpy alive' target='_blank'>Donate</a></li>");
        lineWriter.writeln(" </ul>");
        lineWriter.writeln("</div>");
        lineWriter.writeln("</td></tr></table>");
    }

    private String getDatabaseProduct(DatabaseMetaData databaseMetaData) {
        try {
            return databaseMetaData.getDatabaseProductName() + " - " + databaseMetaData.getDatabaseProductVersion();
        }
        catch (SQLException sQLException) {
            return "";
        }
    }
}

