/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import net.sourceforge.schemaspy.util.ConsolePasswordReader;

public class PasswordReader {
    private static PasswordReader instance;

    public static synchronized PasswordReader getInstance() {
        if (instance == null) {
            try {
                instance = new ConsolePasswordReader();
            }
            catch (Throwable throwable) {
                instance = new PasswordReader();
            }
        }
        return instance;
    }

    protected PasswordReader() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public char[] readPassword(String string, Object ... objectArray) {
        char[] cArray;
        InputStream inputStream = System.in;
        char[] cArray2 = cArray = new char[128];
        int n = cArray2.length;
        int n2 = 0;
        boolean bl = true;
        Masker masker = new Masker(String.format(string, objectArray));
        masker.start();
        try {
            block9: while (bl) {
                int n3 = inputStream.read();
                switch (n3) {
                    case -1: 
                    case 10: {
                        bl = false;
                        continue block9;
                    }
                    case 13: {
                        int n4 = inputStream.read();
                        if (n4 != 10 && n4 != -1) {
                            if (!(inputStream instanceof PushbackInputStream)) {
                                inputStream = new PushbackInputStream(inputStream);
                            }
                            ((PushbackInputStream)inputStream).unread(n4);
                            continue block9;
                        }
                        bl = false;
                        continue block9;
                    }
                }
                if (--n < 0) {
                    cArray2 = new char[n2 + 128];
                    n = cArray2.length - n2 - 1;
                    System.arraycopy(cArray, 0, cArray2, 0, n2);
                    Arrays.fill(cArray, ' ');
                    cArray = cArray2;
                }
                cArray2[n2++] = (char)n3;
            }
        }
        catch (IOException iOException) {
            throw new IOError((Throwable)iOException);
        }
        finally {
            masker.stopMasking();
        }
        if (n2 == 0) {
            return null;
        }
        char[] cArray3 = new char[n2];
        System.arraycopy(cArray2, 0, cArray3, 0, n2);
        Arrays.fill(cArray2, ' ');
        return cArray3;
    }

    public class IOError
    extends Error {
        private static final long serialVersionUID = 20100629L;

        public IOError(Throwable throwable) {
            super(throwable);
        }
    }

    private static class Masker
    extends Thread {
        private volatile boolean masking = true;
        private final String mask;

        public Masker(String string) {
            this.mask = "\r" + string + "     \b\b\b\b\b";
            this.setPriority(Thread.currentThread().getPriority() + 1);
        }

        public void run() {
            while (this.masking) {
                System.out.print(this.mask);
                try {
                    Masker.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    this.interrupt();
                    this.masking = false;
                }
            }
        }

        public void stopMasking() {
            this.masking = false;
        }
    }
}

