/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.math.BigInteger;
import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Symbol;

public final class logbitp
extends Primitive {
    private static final Primitive LOGBITP = new logbitp();

    private logbitp() {
        super("logbitp", "index integer");
    }

    public LispObject execute(LispObject first, LispObject second) {
        BigInteger n;
        int index = -1;
        if (first instanceof Fixnum) {
            index = ((Fixnum)first).value;
        } else if (first instanceof Bignum && ((Bignum)first).value.signum() > 0) {
            index = Integer.MAX_VALUE;
        }
        if (index < 0) {
            return Lisp.type_error(first, Symbol.UNSIGNED_BYTE);
        }
        if (second instanceof Fixnum) {
            n = ((Fixnum)second).getBigInteger();
        } else if (second instanceof Bignum) {
            n = ((Bignum)second).value;
        } else {
            return Lisp.type_error(second, Symbol.INTEGER);
        }
        if (index == Integer.MAX_VALUE) {
            return n.signum() < 0 ? Lisp.T : Lisp.NIL;
        }
        return n.testBit(index) ? Lisp.T : Lisp.NIL;
    }
}

