/*
 * Decompiled with CFR 0.152.
 */
package com.cyberfox.util.platform;

import com.cyberfox.util.config.JConfig;
import com.cyberfox.util.platform.Platform;
import java.io.File;

public class Path {
    private static String sHomeDirectory = null;

    private Path() {
    }

    public static void setHome(String newHome) {
        sHomeDirectory = newHome;
    }

    public static String getHome() {
        if (sHomeDirectory == null) {
            return System.getProperty("user.home");
        }
        return sHomeDirectory;
    }

    public static void setHomeDirectory(String dirname) {
        JConfig.setHomeDirectory(Path.getHomeDirectory(dirname));
    }

    public static String getHomeDirectory(String dirname) {
        String sep = System.getProperty("file.separator");
        String homePath = Platform.isRawMac() ? Path.getMacHomeDirectory(dirname) : Path.getHome() + sep + '.' + dirname;
        File fp = new File(homePath);
        if (!fp.exists()) {
            fp.mkdirs();
        }
        return homePath;
    }

    public static String getMacHomeDirectory(String dirname) {
        String sep = System.getProperty("file.separator");
        if (dirname.equals("jbidwatcher")) {
            dirname = "JBidwatcher";
        }
        return Path.getHome() + sep + "Library" + sep + "Preferences" + sep + dirname;
    }

    public static String getCanonicalFile(String fname, String dirname, boolean mustExist) {
        String outName = fname;
        String pathSeparator = System.getProperty("file.separator");
        if (fname.indexOf(pathSeparator) == -1) {
            String configPathFile = Path.getHomeDirectory(dirname) + pathSeparator + fname;
            if (mustExist) {
                File centralConfig = new File(configPathFile);
                if (centralConfig.exists() && centralConfig.isFile()) {
                    outName = configPathFile;
                }
            } else {
                outName = configPathFile;
            }
        }
        return outName;
    }

    public static String makeStandardDirectory(String inPath, String defaultSubdir, String defaultDirectory) {
        File fp_test;
        String outPath = inPath;
        if (outPath != null && !(fp_test = new File(outPath)).exists() && !fp_test.mkdirs()) {
            outPath = null;
        }
        if (outPath == null) {
            String directoryPath = Path.getCanonicalFile(defaultSubdir, defaultDirectory, false);
            File fp = new File(directoryPath);
            if (fp.exists()) {
                outPath = fp.getAbsolutePath();
            } else {
                if (!fp.mkdirs()) {
                    JConfig.log().logDebug("Couldn't mkdir " + directoryPath);
                }
                outPath = fp.getAbsolutePath();
            }
        }
        return outPath;
    }
}

