/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher;

import com.jbidwatcher.ui.util.OptionUI;
import com.jbidwatcher.util.StringTools;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.http.Http;
import com.jbidwatcher.util.xml.XMLElement;
import com.jbidwatcher.util.xml.XMLInterface;
import com.jbidwatcher.util.xml.XMLParseException;
import com.jbidwatcher.util.xml.XMLSerializeSimple;
import java.awt.Dimension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;

public class UpdaterEntry
extends XMLSerializeSimple {
    protected String _version = "";
    protected String _severity = "";
    protected String _description = "";
    protected String _url = "";
    protected String _changelogURL = "";
    protected String _changelog;
    protected boolean _valid;
    protected ArrayList<XMLInterface> mConfigChanges;
    protected String[] infoTags = new String[]{"version", "severity", "description", "url", "config", "knownversion", "changelog"};

    public UpdaterEntry(String packageName, String updateFrom) {
        StringBuffer loadedUpdate;
        try {
            URLConnection uc = Http.net().getPage(updateFrom);
            loadedUpdate = Http.net().receivePage(uc);
            this._valid = true;
        }
        catch (IOException e) {
            loadedUpdate = null;
            JConfig.log().handleException("UpdaterEntry: " + e, e);
            this._valid = false;
        }
        if (this._valid && (loadedUpdate == null || loadedUpdate.length() == 0)) {
            this._valid = false;
        }
        if (this._valid) {
            this.loadFromString(loadedUpdate, packageName);
        }
    }

    public void loadFromString(StringBuffer sb, String packageName) {
        if (sb == null || packageName == null) {
            JConfig.log().handleException("loadFromString Failed with a null pointer!", new Exception("Updater got incorrect XML file."));
        } else {
            XMLElement xmlUpdate = new XMLElement(true);
            xmlUpdate.parseString(sb.toString());
            if (xmlUpdate.getTagName().equalsIgnoreCase(packageName)) {
                this.fromXML(xmlUpdate);
            } else {
                throw new XMLParseException(xmlUpdate.getTagName(), "Updater got incorrect XML file.");
            }
        }
    }

    @Override
    public XMLElement toXML() {
        throw new RuntimeException("toXML not supported by load-only class.");
    }

    @Override
    protected String[] getTags() {
        return this.infoTags;
    }

    @Override
    protected void handleTag(int i, XMLElement curElement) {
        switch (i) {
            case 0: {
                this._version = curElement.getContents();
                break;
            }
            case 1: {
                this._severity = curElement.getContents();
                break;
            }
            case 2: {
                this._description = curElement.getContents();
                break;
            }
            case 3: {
                this._url = curElement.getContents();
                break;
            }
            case 4: {
                long last;
                String checkTrue;
                boolean valid = true;
                String vNum = curElement.getProperty("VERSION");
                if (vNum != null) {
                    valid = vNum.equals("2.99pre5");
                }
                if ((checkTrue = curElement.getProperty("CHECKTRUE")) != null && JConfig.queryConfiguration(checkTrue, "true").equals("false")) {
                    valid = false;
                }
                if (!valid) break;
                String strStamp = curElement.getProperty("STAMP");
                if (strStamp == null) {
                    if (this.mConfigChanges == null) {
                        this.mConfigChanges = new ArrayList(5);
                    }
                    this.mConfigChanges.add(curElement);
                    break;
                }
                long stamp = Long.parseLong(strStamp);
                if (stamp <= (last = Long.parseLong(JConfig.queryConfiguration("updates.lastConfig", "0")))) break;
                if (this.mConfigChanges == null) {
                    this.mConfigChanges = new ArrayList(5);
                }
                this.mConfigChanges.add(curElement);
                break;
            }
            case 5: {
                String known = curElement.getContents();
                if (!known.equals("2.99pre5")) break;
                this._version = known;
                break;
            }
            case 6: {
                this._changelogURL = curElement.getContents();
                break;
            }
        }
    }

    public boolean isValid() {
        return this._valid;
    }

    public String getVersion() {
        return this._version;
    }

    public String getSeverity() {
        return this._severity;
    }

    public String getDescription() {
        return this._description;
    }

    public String getURL() {
        return this._url;
    }

    public URL getChangelogURL() {
        if (this._changelogURL != null && this._changelogURL.length() != 0) {
            try {
                return new URL(this._changelogURL);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getChangelog() {
        URL changelog = this.getChangelogURL();
        if (this._changelog == null && changelog != null) {
            this._changelog = StringTools.cat(changelog);
        }
        return this._changelog;
    }

    public static void main(String[] args) {
        UpdaterEntry ue = new UpdaterEntry("JBidwatcher".toLowerCase(), "http://www.jbidwatcher.com/jbidwatcher2.xml");
        System.out.println("Available version is: " + ue.getVersion());
        System.out.println("How strongly encouraged: " + ue.getSeverity());
        System.out.println("What is new/necessary: " + ue.getDescription());
        System.out.println("The URL to get that version at is: " + ue.getURL());
        System.out.println("Changelog URL: " + ue.getChangelogURL().toString());
        System.out.println("The changelog is: " + ue.getChangelog());
    }

    public boolean hasConfigurationUpdates() {
        return this.mConfigChanges != null;
    }

    public void applyConfigurationUpdates() {
        StringBuffer alert = null;
        boolean cfgChanged = false;
        long lastStamp = Long.parseLong(JConfig.queryConfiguration("updates.lastConfig", "0"));
        for (XMLInterface cfg : this.mConfigChanges) {
            long stamp;
            String strStamp;
            String oldCfg;
            String cfgVar;
            String type = cfg.getProperty("TYPE", "config");
            if (type.equals("message")) {
                if (alert == null) {
                    alert = new StringBuffer(cfg.getContents());
                } else {
                    alert.append('\n');
                    alert.append(cfg.getContents());
                }
            } else if (type.equals("config")) {
                cfgVar = cfg.getProperty("VARIABLE");
                if (cfgVar != null) {
                    if (JConfig.queryConfiguration(cfgVar) != null) {
                        JConfig.setConfiguration("saved." + cfgVar, JConfig.queryConfiguration(cfgVar));
                    }
                    JConfig.setConfiguration(cfgVar, cfg.getContents());
                    cfgChanged = true;
                }
            } else if (type.equals("string")) {
                cfgVar = cfg.getProperty("STRING");
                if (cfgVar != null) {
                    JConfig.setConfiguration("replace.2.99pre5." + cfgVar, cfg.getContents());
                    cfgChanged = true;
                }
            } else if (type.equals("restore")) {
                String oldCfg2;
                cfgVar = cfg.getContents();
                if (cfgVar != null && (oldCfg2 = JConfig.queryConfiguration("saved." + cfgVar)) != null) {
                    JConfig.setConfiguration(cfgVar, oldCfg2);
                    JConfig.kill("saved." + cfgVar);
                    cfgChanged = true;
                }
            } else if (type.equals("delete") && (oldCfg = JConfig.queryConfiguration(cfgVar = cfg.getContents())) != null) {
                JConfig.kill(cfgVar);
                cfgChanged = true;
            }
            if ((strStamp = cfg.getProperty("STAMP")) == null || (stamp = Long.parseLong(strStamp)) <= lastStamp) continue;
            lastStamp = stamp;
        }
        JConfig.setConfiguration("updates.lastConfig", Long.toString(lastStamp));
        if (cfgChanged) {
            JConfig.updateComplete();
        }
        if (alert != null) {
            OptionUI oui = new OptionUI();
            Dimension aboutBoxSize = new Dimension(495, 245);
            oui.showHTMLDisplay(alert, aboutBoxSize, "JBidwatcher News Alert...");
        }
    }
}

