/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher;

import com.jbidwatcher.util.HashBacked;
import com.jbidwatcher.util.Record;
import com.jbidwatcher.util.StringTools;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.db.Database;
import com.jbidwatcher.util.db.Table;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.List;

public class Upgrader {
    public static void upgrade() throws SQLException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        Database db = new Database(null);
        if (Upgrader.dbMake(db)) {
            db.commit();
            db.shutdown();
            db = Upgrader.dbMigrate();
        }
        db.commit();
        db.shutdown();
    }

    private static Database dbMigrate() throws IllegalAccessException, SQLException, ClassNotFoundException, InstantiationException {
        Record first;
        HashBacked record;
        int version;
        Table schemaInfo = new Table("schema_info");
        List<Record> info = schemaInfo.findAll();
        if (info != null && (version = (record = new HashBacked(first = info.get(0))).getInteger("version", -1).intValue()) != -1) {
            int last_version = version++;
            NumberFormat nf = NumberFormat.getIntegerInstance();
            nf.setMinimumIntegerDigits(3);
            Statement s = schemaInfo.getDB().getStatement();
            while (Upgrader.runFile(schemaInfo.getDB(), s, "/db/" + nf.format(version) + ".sql")) {
                record.setInteger("version", version);
                schemaInfo.updateMap("schema_info", "version", Integer.toString(last_version), record.getBacking());
                last_version = version++;
            }
        }
        return schemaInfo.getDB();
    }

    private static boolean tableExists(Statement s, String tableName) throws SQLException {
        ResultSet rs = s.getConnection().getMetaData().getTables(null, null, tableName, null);
        boolean result = rs.next();
        rs.close();
        return result;
    }

    private static boolean dbMake(Database db) {
        try {
            Statement mS = db.getStatement();
            boolean schema_info_exists = Upgrader.tableExists(mS, "schema_info");
            if (!schema_info_exists) {
                schema_info_exists = Upgrader.tableExists(mS, "SCHEMA_INFO");
            }
            if (!schema_info_exists) {
                Upgrader.runFile(db, mS, "/jbidwatcher.sql");
                JConfig.setConfiguration("jbidwatcher.created_db", "true");
            } else {
                JConfig.log().logDebug("Auction information database already exists.");
            }
        }
        catch (SQLException se) {
            System.err.println(se);
            return false;
        }
        return true;
    }

    private static boolean runFile(Database db, Statement mS, String filename) throws SQLException {
        String sql = StringTools.cat(JConfig.getResource(filename));
        if (sql != null && sql.length() != 0) {
            String[] statements;
            for (String statement : statements = sql.split("(?m)^$")) {
                db.executeCanonicalizedSQL(mS, statement);
            }
            JConfig.log().logDebug("Executed " + filename + ".");
            JConfig.log().logDebug("Created database and various tables.");
            return true;
        }
        return false;
    }
}

