/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.app;

import com.cyberfox.util.config.Base64;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.AuctionInfo;
import com.jbidwatcher.auction.AuctionServerInterface;
import com.jbidwatcher.auction.EntryCorral;
import com.jbidwatcher.auction.EntryFactory;
import com.jbidwatcher.auction.EntryManager;
import com.jbidwatcher.auction.Resolver;
import com.jbidwatcher.auction.server.AuctionServer;
import com.jbidwatcher.auction.server.AuctionServerFactory;
import com.jbidwatcher.auction.server.AuctionServerManager;
import com.jbidwatcher.auction.server.ebay.ebayServer;
import com.jbidwatcher.my.MyJBidwatcher;
import com.jbidwatcher.scripting.JRubyPreloader;
import com.jbidwatcher.scripting.Scripting;
import com.jbidwatcher.search.SearchManager;
import com.jbidwatcher.search.Searcher;
import com.jbidwatcher.ui.AuctionListHolder;
import com.jbidwatcher.ui.AuctionListHolderFactory;
import com.jbidwatcher.ui.AuctionsManager;
import com.jbidwatcher.util.Constants;
import com.jbidwatcher.util.Observer;
import com.jbidwatcher.util.Record;
import com.jbidwatcher.util.StringTools;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.db.ActiveRecord;
import com.jbidwatcher.util.html.JHTML;
import com.jbidwatcher.util.queue.AuctionQObject;
import com.jbidwatcher.util.queue.MQFactory;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JBTool {
    @Inject
    private AuctionServerFactory serverFactory;
    private final EntryFactory entryFactory;
    private final SearchManager searchManager;
    private final AuctionServerManager auctionServerManager;
    private final MyJBidwatcher myJBidwatcher;
    private boolean mLogin = false;
    private String mUsername = null;
    private String mPassword = null;
    private boolean mJustMyeBay = false;
    private List<String> mParams;
    private ebayServer mEbay;
    private String mCountry = "ebay.com";
    private String mParseFile = null;
    private boolean mCompare = false;
    private boolean mMultiFiles = false;

    private void testBasicAuthentication(String user, String key) throws Exception {
        URL retrievalURL = JConfig.getURL("http://localhost:9909/services/sqsurl");
        HttpURLConnection huc = (HttpURLConnection)retrievalURL.openConnection();
        huc.setRequestProperty("Authorization", "Basic " + Base64.encodeString(user + ":" + key));
        String url = StringTools.cat(huc.getInputStream());
        System.out.println("URL == " + url);
    }

    private void testBidHistory(String file) {
        StringBuffer sb = new StringBuffer(StringTools.cat(file));
        JHTML hDoc = new JHTML(sb);
        List<JHTML.Table> tableList = hDoc.extractTables();
        System.err.println("There were " + tableList.size() + " tables.");
        for (JHTML.Table t : tableList) {
            if (!t.rowCellMatches(0, "Bidder")) continue;
            for (int i = 1; i < t.getRowCount() - 1; ++i) {
                System.err.println("Bidder #" + i + ": " + t.getCell(0, i));
            }
        }
    }

    private Map testMicroformats(String file) {
        StringBuffer sb = new StringBuffer(StringTools.cat(file));
        JHTML hDoc = new JHTML(sb);
        return hDoc.extractMicroformat();
    }

    private void testSearching() {
        Searcher sm = this.searchManager.addSearch("Title", "zarf", "zarf", "ebay", -1, 12345678L);
        sm.execute();
    }

    private void testDateFormatting() {
        try {
            String siteDateFormat = "dd.MM.yy HH:mm:ss z";
            String testTime = "10.11.08 13:54:28 MET";
            SimpleDateFormat sdf = new SimpleDateFormat(siteDateFormat, Locale.US);
            Date endingDate = sdf.parse(testTime);
            TimeZone tz = sdf.getCalendar().getTimeZone();
            System.out.println("EndingDate: " + endingDate + "\nTZ: " + tz);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void execute() {
        this.setupAuctionResolver();
        if (this.mLogin) {
            this.mEbay.forceLogin();
        }
        if (this.mJustMyeBay) {
            MQFactory.getConcrete(this.mEbay.getFriendlyName()).enqueueBean(new AuctionQObject(3, null, null));
            try {
                Thread.sleep(120000L);
            }
            catch (Exception exception) {}
        } else if (this.mParseFile != null) {
            JConfig.setHomeDirectory("./");
            if (this.mCompare) {
                this.comparative(this.mParseFile);
            } else {
                this.buildAuctionEntryFromFile(this.mParseFile);
            }
        } else if (this.mMultiFiles) {
            for (String file : this.mParams) {
                this.comparative(file);
            }
        } else {
            this.retrieveAndVerifyAuctions(this.mParams);
        }
    }

    @Inject
    public JBTool(EntryFactory eFactory, final EntryCorral corral, SearchManager searchManager, AuctionServerManager serverManager, MyJBidwatcher myJBidwatcher) {
        this.entryFactory = eFactory;
        this.searchManager = searchManager;
        this.auctionServerManager = serverManager;
        this.myJBidwatcher = myJBidwatcher;
        ActiveRecord.disableDatabase();
        AuctionEntry.addObserver(this.entryFactory);
        AuctionEntry.addObserver(new Observer<AuctionEntry>(){

            @Override
            public void afterCreate(AuctionEntry o) {
                corral.putWeakly(o);
            }
        });
    }

    public static void main(String[] args) {
        AbstractModule guiceModule = new AbstractModule(){

            protected void configure() {
                this.bind(EntryManager.class).to(AuctionsManager.class);
                this.install(new FactoryModuleBuilder().implement(AuctionServer.class, ebayServer.class).build(AuctionServerFactory.class));
                this.install(new FactoryModuleBuilder().implement(AuctionListHolder.class, AuctionListHolder.class).build(AuctionListHolderFactory.class));
            }
        };
        Injector inject = Guice.createInjector((Module[])new Module[]{guiceModule});
        JBTool tool = (JBTool)inject.getInstance(JBTool.class);
        tool.mParams = tool.parseOptions(args);
        tool.execute();
        System.exit(0);
    }

    private void buildAuctionEntryFromFile(String fname) {
        StringBuffer sb = new StringBuffer(StringTools.cat(fname));
        try {
            long start = System.currentTimeMillis();
            AuctionInfo ai = this.mEbay.doParse(sb);
            AuctionEntry ae = this.entryFactory.constructEntry();
            ae.setAuctionInfo(ai);
            System.out.println("Took: " + (System.currentTimeMillis() - start));
            System.out.println(JSONObject.toJSONString((Map)ai.getBacking()));
        }
        catch (Exception e) {
            JConfig.log().handleException("Failed to load auction from file: " + fname, e);
        }
    }

    private void comparative(String fname) {
        JRubyPreloader preloader = new JRubyPreloader(new Object());
        preloader.run();
        StringBuffer sb = new StringBuffer(StringTools.cat(fname));
        try {
            Record jResults = this.mEbay.doParse(sb).getBacking();
            Record rResults = this.mEbay.tryRuby(sb);
            System.out.println("Java:");
            this.dumpMap(jResults);
            System.out.println("\n\nRuby:");
            this.dumpMap(rResults);
            System.out.println();
        }
        catch (Exception e) {
            JConfig.log().handleException("Failed to load auction from file: " + fname, e);
        }
    }

    private void retrieveAndVerifyAuctions(List<String> params) {
        if (params.size() == 0) {
            return;
        }
        try {
            JSONArray ary = new JSONArray();
            for (String id : params) {
                JSONObject element = new JSONObject();
                element.putAll((Map)this.mEbay.create(id).getBacking());
                ary.add((Object)element);
            }
            System.out.println(ary.toJSONString());
        }
        catch (Exception dumpMe) {
            JConfig.log().handleException("Failure during serialization or deserialization of an auction", dumpMe);
        }
    }

    private void setupAuctionResolver() {
        this.mEbay = (ebayServer)this.serverFactory.create(this.mCountry, this.mUsername, this.mPassword);
        Resolver r = new Resolver(){

            @Override
            public AuctionServerInterface getServer() {
                return JBTool.this.mEbay;
            }
        };
        this.auctionServerManager.setServer(this.mEbay);
        this.entryFactory.setResolver(r);
    }

    private List<String> parseOptions(String[] args) {
        LinkedList<String> options = new LinkedList<String>();
        LinkedList<String> params = new LinkedList<String>();
        boolean append = false;
        for (String arg : args) {
            if (append) {
                String last = (String)options.get(options.size() - 1);
                last = last.substring(0, last.length() - 1) + ' ' + arg;
                options.set(options.size() - 1, last);
                continue;
            }
            if (arg.charAt(0) == '-') {
                int skip = 1;
                if (arg.charAt(1) == '-') {
                    skip = 2;
                }
                options.add(arg.substring(skip));
                if (arg.charAt(arg.length() - 1) != '\\') continue;
                append = true;
                continue;
            }
            params.add(arg);
        }
        for (String option : options) {
            if (option.equals("basicauth")) {
                try {
                    this.testBasicAuthentication("morgan", "schweers");
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
                return params;
            }
            if (option.equals("uk")) {
                option = "country=ebay.co.uk";
            }
            if (option.equals("accountinfo")) {
                this.testAccountInfo();
                return params;
            }
            if (option.equals("searching")) {
                this.testSearching();
                return params;
            }
            if (option.equals("logging")) {
                JConfig.setConfiguration("logging", "true");
            }
            if (option.equals("debug")) {
                JConfig.setConfiguration("debugging", "true");
            }
            if (option.equals("timetest")) {
                this.testDateFormatting();
            }
            if (option.equals("logconfig")) {
                JConfig.setConfiguration("config.logging", "true");
            }
            if (option.equals("logurls")) {
                JConfig.setConfiguration("debug.urls", "true");
            }
            if (option.equals("myebay")) {
                this.mJustMyeBay = true;
            }
            if (option.equals("sandbox")) {
                JConfig.setConfiguration("replace.2.99pre5.ebayServer.viewHost", "cgi.sandbox.ebay.com");
            }
            if (option.startsWith("country=")) {
                this.mCountry = option.substring(8);
                if (JBTool.getSiteNumber(this.mCountry) == -1) {
                    System.out.println("That country is not recognized by JBidwatcher's eBay Server.");
                }
            }
            if (option.equals("login")) {
                this.mLogin = true;
            }
            if (option.startsWith("username=")) {
                this.mUsername = option.substring(9);
            }
            if (option.startsWith("password=")) {
                this.mPassword = option.substring(9);
            }
            if (option.startsWith("mfparse=")) {
                long start = System.currentTimeMillis();
                this.dumpMap(this.testMicroformats(option.substring(8)));
                System.out.println("Took: " + (System.currentTimeMillis() - start));
            }
            if (option.startsWith("file=")) {
                this.mParseFile = option.substring(5);
            }
            if (option.startsWith("compare=")) {
                this.mParseFile = option.substring(8);
                this.mCompare = true;
            }
            if (option.startsWith("bulk")) {
                this.mCompare = true;
                this.mMultiFiles = true;
            }
            if (option.startsWith("bidfile=")) {
                this.testBidHistory(option.substring(8));
            }
            if (option.startsWith("adult")) {
                JConfig.setConfiguration("ebay.mature", "true");
            }
            if (!option.startsWith("upload=")) continue;
            this.myJBidwatcher.sendFile(new File(option.substring(7)), "http://my.jbidwatcher.com/upload/log", "cyberfox@jbidwatcher.com", "This is a <test> of descriptions & stuff.");
        }
        if (!this.mLogin) {
            this.mUsername = "default";
            this.mPassword = "default";
        }
        return params;
    }

    private void testAccountInfo() {
    }

    public static int getSiteNumber(String site) {
        for (int i = 0; i < Constants.SITE_CHOICES.length; ++i) {
            if (!site.equals(Constants.SITE_CHOICES[i])) continue;
            return i;
        }
        return -1;
    }

    private void dumpMap(Map m) {
        Scripting.rubyMethod("dump_hash", m);
    }
}

