/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.app;

import com.cyberfox.util.platform.Platform;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jbidwatcher.UpdateManager;
import com.jbidwatcher.UpdaterEntry;
import com.jbidwatcher.app.MacFriendlyFrame;
import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.EntryCorral;
import com.jbidwatcher.auction.server.AuctionServer;
import com.jbidwatcher.auction.server.AuctionServerManager;
import com.jbidwatcher.auction.server.AuctionStats;
import com.jbidwatcher.search.SearchManager;
import com.jbidwatcher.ui.AuctionsManager;
import com.jbidwatcher.ui.JBidToolBar;
import com.jbidwatcher.ui.JTabManager;
import com.jbidwatcher.ui.MyActionListener;
import com.jbidwatcher.ui.SwingMessageQueue;
import com.jbidwatcher.ui.UISnapshot;
import com.jbidwatcher.ui.util.OptionUI;
import com.jbidwatcher.util.Constants;
import com.jbidwatcher.util.PauseManager;
import com.jbidwatcher.util.UIConstants;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.html.JHTMLOutput;
import com.jbidwatcher.util.queue.AuctionQObject;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.MessageQueue;
import com.jbidwatcher.util.queue.SuperQueue;
import com.jbidwatcher.util.queue.TimerHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

@Singleton
public final class UIBackbone
implements MessageQueue.Listener {
    private boolean _userValid;
    private Date mNow = new Date();
    private Calendar mCal = new GregorianCalendar();
    private MacFriendlyFrame mFrame;
    private boolean mSmall;
    private final AuctionServerManager serverManager;
    private final AuctionsManager auctionsManager;
    private final SearchManager searcher;
    private final JTabManager tabs;
    private final EntryCorral entryCorral;
    private final PauseManager pauseManager;
    private final JBidToolBar toolBar;
    private boolean _linkUp = true;
    private static final int ONEK = 1024;
    private static final int UPDATE_FRAME_WIDTH = 640;
    private static final int UPDATE_FRAME_HEIGHT = 450;
    private static long lastTime;

    @Inject
    public UIBackbone(AuctionServerManager serverManager, AuctionsManager auctionsManager, SearchManager searcher, JTabManager tabs, EntryCorral entryCorral, PauseManager pauseManager, JBidToolBar toolBar) {
        this.serverManager = serverManager;
        this.auctionsManager = auctionsManager;
        this.searcher = searcher;
        this.tabs = tabs;
        this.entryCorral = entryCorral;
        this.pauseManager = pauseManager;
        this.toolBar = toolBar;
        TimerHandler clockTimer = new TimerHandler(new TimerHandler.WakeupProcess(){

            @Override
            public boolean check() {
                UIBackbone.this.checkClock();
                return true;
            }
        });
        clockTimer.setName("Clock");
        clockTimer.start();
        MQFactory.addQueue("Swing", new SwingMessageQueue());
        MQFactory.getConcrete("Swing").registerListener(this);
    }

    public void setLinkUp(boolean linkIsUp) {
        this._linkUp = linkIsUp;
    }

    public boolean getLinkUp() {
        return this._linkUp;
    }

    @Override
    public void messageAction(Object deQ) {
        String[] cmdMessage = ((String)deQ).split(" ", 2);
        switch (cmdMessage[0]) {
            case "QUIT": {
                this.logActivity("Shutting down.");
                this.mFrame.shutdown();
                break;
            }
            case "HIDE": {
                this.hideUI();
                break;
            }
            case "RESTORE": {
                this.showUI();
                break;
            }
            case "VISIBILITY": {
                this.toggleVisibility();
                break;
            }
            case "SNIPECHANGED": {
                this.alterSnipeStatus();
                break;
            }
            case "NEWVERSION": {
                this.logActivity("New version found!");
                UIBackbone.announceNewVersion();
                break;
            }
            case "TOGGLE_SMALL": {
                this.mSmall = !this.mSmall;
                break;
            }
            case "ALLOW_UPDATES": {
                this.startUpdating();
                break;
            }
            case "VALID_LOGIN": {
                this.handleValidLogin();
                break;
            }
            case "NO_NEWVERSION": {
                JOptionPane.showMessageDialog(null, "No new version available yet.\nKeep checking back!", "No new version", -1);
                break;
            }
            case "BAD_NEWVERSION": {
                JOptionPane.showMessageDialog(null, "Failed to check for a new version\nProbably a temporary network issue; try again in a little while.", "Version check failed", -1);
                break;
            }
            case "TOOLBAR": {
                this.toolBar.togglePanel();
                break;
            }
            case "HEADER": {
                String headerMsg = cmdMessage[1];
                this.handleHeader(headerMsg);
                break;
            }
            case "LOGINSTATUS": {
                this.handleLoginStatus(cmdMessage[1]);
                break;
            }
            case "LINK": {
                String linkMsg = cmdMessage[1];
                this.handleLinkStatus(linkMsg);
                break;
            }
            case "SECURITY": {
                String code = cmdMessage[1];
                JOptionPane.showMessageDialog(null, "Enter the following code on your device: " + code, "Set up Synchronization", -1);
                break;
            }
            case "ALERT": {
                String alertMsg = cmdMessage[1];
                this.logActivity("Alert: " + alertMsg);
                if (this.duplicateDialog(alertMsg)) break;
                JOptionPane.showMessageDialog(null, alertMsg, "Alert", -1);
                break;
            }
            case "NOACCOUNT": {
                String noAcctMsg = cmdMessage[1];
                this.logActivity("Alert: " + noAcctMsg);
                JOptionPane.showMessageDialog(null, noAcctMsg, "No auction account", -1);
                break;
            }
            case "NOTIFY": {
                String notifyMsg = cmdMessage[1];
                this.logActivity("Notify: " + notifyMsg);
                this.handleNotify(notifyMsg);
                break;
            }
            case "IGNORE": {
                String configstr = cmdMessage[1];
                this.handleIgnorable(configstr);
                break;
            }
            case "ERROR": {
                String errorMsg = cmdMessage[1];
                this.logActivity("Error: " + errorMsg);
                JOptionPane.showMessageDialog(null, errorMsg, "An error occurred", -1);
                break;
            }
            case "INVALID_LOGIN": {
                String rest = cmdMessage[1];
                this.handleInvalidLogin(rest);
                break;
            }
            case "PRICE": {
                if (this.mFrame == null) break;
                this.mFrame.setPrice(cmdMessage[1]);
                break;
            }
            default: {
                String msg = (String)deQ;
                this.logActivity(msg);
                this.setStatus(msg);
            }
        }
    }

    public void setMainFrame(MacFriendlyFrame frame) {
        this.mFrame = frame;
    }

    private void setStatus(String newStatus) {
        TimeZone tz;
        this.mNow.setTime(System.currentTimeMillis());
        String defaultServerTime = this.serverManager.getDefaultServerTime();
        String bracketed = " [" + defaultServerTime + ']';
        if (JConfig.queryConfiguration("timesync.enabled", "true").equals("false") && (tz = this.serverManager.getServer().getOfficialServerTimeZone()) != null && tz.hasSameRules(this.mCal.getTimeZone())) {
            bracketed = " [" + Constants.localClockFormat.format(this.mNow) + ']';
        }
        String statusToDisplay = newStatus + bracketed;
        if (this.mFrame != null) {
            this.mFrame.setStatus(statusToDisplay);
        } else {
            JConfig.log().logDebug(newStatus + bracketed);
        }
    }

    private void logActivity(String action) {
        MQFactory.getConcrete("activity").enqueue(action);
    }

    private boolean duplicateDialog(String alertMsg) {
        Window[] rval;
        for (Window w : rval = JDialog.getWindows()) {
            Component[] components;
            JDialog jd;
            if (!(w instanceof JDialog) || !(jd = (JDialog)w).isVisible()) continue;
            for (Component c : components = jd.getContentPane().getComponents()) {
                if (!(c instanceof JOptionPane) || !((JOptionPane)c).getMessage().equals(alertMsg)) continue;
                return true;
            }
        }
        return false;
    }

    private void handleLoginStatus(String status) {
        if (status.startsWith("FAILED")) {
            this.toolBar.setToolTipText("Login failed.");
            this.toolBar.setTextIcon(UIConstants.redStatus, UIConstants.redStatus16);
            JConfig.getMetrics().trackEvent("login", "fail");
            this.notifyAlert(status.substring("FAILED ".length()));
        } else if (status.startsWith("CAPTCHA")) {
            this.toolBar.setToolTipText("Login failed due to CAPTCHA.");
            this.toolBar.setTextIcon(UIConstants.redStatus, UIConstants.redStatus16);
            JConfig.getMetrics().trackEvent("login", "captcha");
        } else if (status.startsWith("SUCCESSFUL")) {
            String additionTooltip = "";
            if (!status.equals("SUCCESSFUL")) {
                String successMessage = status.substring("SUCCESSFUL ".length());
                additionTooltip = "\n " + successMessage;
                this.notifyAlert(successMessage);
            }
            this.toolBar.setToolTipText("Last login was successful." + additionTooltip);
            this.toolBar.setTextIcon(UIConstants.greenStatus, UIConstants.greenStatus16);
            JConfig.getMetrics().trackEvent("login", "success");
        } else {
            this.toolBar.setToolTipText("Last login did not clearly fail, but no valid cookies were received.");
            this.toolBar.setTextIcon(UIConstants.yellowStatus, UIConstants.yellowStatus16);
            JConfig.getMetrics().trackEvent("login", "neutral");
        }
    }

    private void handleValidLogin() {
        MQFactory.getConcrete("Swing").enqueue("SNIPECHANGED");
        this.auctionsManager.start();
        this.searcher.start();
        this.toolBar.setToolTipExtra(null);
        this._userValid = true;
    }

    private void startUpdating() {
        MQFactory.getConcrete("Swing").enqueue("SNIPECHANGED");
        this.auctionsManager.start();
        this.searcher.start();
        if (!this._userValid) {
            this.notifyAlert("Not yet logged in.  Snipes will not fire until logging in\nis successful.  Item updating has been enabled, but any\nfeatures that rely on being logged in will not work.");
        }
    }

    private void notifyAlert(String alertMessage) {
        String msgType = "ALERT";
        String destination = "Swing";
        if (Platform.isTrayEnabled()) {
            msgType = "NOTIFY";
            destination = "tray";
        }
        MQFactory.getConcrete(destination).enqueue(msgType + alertMessage);
    }

    private void handleInvalidLogin(String rest) {
        this._userValid = false;
        if (rest.length() != 0) {
            rest = rest.substring(1);
            this.toolBar.setToolTipExtra(rest);
            this.logActivity(rest);
        } else {
            this.logActivity("Invalid login.");
        }
    }

    private void handleIgnorable(String configstr) {
        int configLen = configstr.indexOf(32);
        String realMsg = configstr.substring(configLen + 1);
        configstr = configstr.substring(0, configLen);
        OptionUI oui = new OptionUI();
        oui.promptWithCheckbox(null, realMsg, "Alert", configstr, -1, 0);
    }

    private void handleNotify(String notifyMsg) {
        if (Platform.isTrayEnabled()) {
            MQFactory.getConcrete("tray").enqueue("NOTIFY " + notifyMsg);
        } else {
            MQFactory.getConcrete("Swing").enqueue(notifyMsg);
        }
    }

    private void alterSnipeStatus() {
        AuctionStats as;
        if (Platform.isTrayEnabled() && (as = this.serverManager.getStats()) != null) {
            StringBuilder snipeText = new StringBuilder("TOOLTIP ");
            if (as.getSnipes() != 0) {
                snipeText.append("Next Snipe at: ").append(Constants.remoteClockFormat.format(as.getNextSnipe().getSnipeDate())).append('\n');
                snipeText.append(as.getSnipes()).append(" snipes outstanding\n");
            }
            if (as.getCompleted() != 0) {
                snipeText.append(as.getCompleted()).append(" auctions completed\n");
            }
            snipeText.append(as.getCount()).append(" auctions total");
            MQFactory.getConcrete("tray").enqueue(snipeText.toString());
        }
    }

    private void showUI() {
        this.mFrame.setVisible(true);
        if (Platform.isTrayEnabled()) {
            MQFactory.getConcrete("tray").enqueue("RESTORED");
        }
        this.mFrame.setState(0);
    }

    private void hideUI() {
        if (this.mFrame.isVisible()) {
            UISnapshot.recordLocation(this.mFrame);
        }
        this.mFrame.setVisible(false);
        if (Platform.isTrayEnabled()) {
            MQFactory.getConcrete("tray").enqueue("HIDDEN");
        }
    }

    private void toggleVisibility() {
        this.mFrame.setVisible(!this.mFrame.isVisible());
        MQFactory.getConcrete("tray").enqueue(this.mFrame.isVisible() ? "RESTORED" : "HIDDEN");
        if (this.mFrame.isVisible()) {
            this.mFrame.setState(0);
        }
    }

    private void handleLinkStatus(String linkStat) {
        this.setLinkUp(linkStat.startsWith("UP"));
        String rest = linkStat.substring(linkStat.startsWith("UP") ? 2 : 4);
        if (rest.length() == 0) {
            if (this._userValid) {
                this.toolBar.setToolTipExtra(null);
            }
        } else {
            rest = rest.substring(1);
            this.logActivity("Link issues:");
            this.logActivity(rest);
            if (this._userValid) {
                this.toolBar.setToolTipExtra(rest);
            }
        }
    }

    private void handleHeader(String headerMsg) {
        this.toolBar.setText(headerMsg);
        this.tabs.updateTime();
    }

    private static void announceNewVersion() {
        ArrayList<String> buttons = new ArrayList<String>();
        buttons.add("Download");
        buttons.add("Ignore");
        final UpdaterEntry ue = UpdateManager.getInstance().getUpdateInfo();
        StringBuffer fullMsg = new StringBuffer(4096);
        String icon = JConfig.getResource("/jbidwatch64.jpg").toString();
        fullMsg.append("<html><body><table><tr><td><img src=\"").append(icon).append("\"></td>");
        fullMsg.append("<td valign=\"top\"><span class=\"banner\"><b>A new version of JBidwatcher is available!</b></span><br>");
        fullMsg.append("<span class=\"smaller\">JBidwatcher <b>").append(ue.getVersion());
        fullMsg.append("</b> is now available. Would you like to <a href=\"").append(ue.getURL()).append("\">download it now?</a><br><br>");
        fullMsg.append("Upgrading is <em>").append(ue.getSeverity()).append("</em></span></td></tr></table>");
        fullMsg.append("<p><b>Release Notes:</b></p><div class=\"changelog\">");
        String changelog = ue.getChangelog();
        if (changelog == null) {
            fullMsg.append(ue.getDescription());
        } else {
            fullMsg.append(changelog);
        }
        fullMsg.append("</div></body></html>");
        MyActionListener mal = new MyActionListener(){
            private final String go_to;
            {
                this.go_to = ue.getURL();
            }

            @Override
            public void actionPerformed(ActionEvent listen_ae) {
                String actionString = listen_ae.getActionCommand();
                if (actionString.equals("Download")) {
                    MQFactory.getConcrete("browse").enqueue(this.go_to);
                }
                this.m_within.dispose();
                this.m_within = null;
            }
        };
        OptionUI oui = new OptionUI();
        JFrame newFrame = oui.showChoiceTextDisplay(new JHTMLOutput("Version " + ue.getVersion() + " available!", fullMsg).getStringBuffer(), new Dimension(640, 450), "Version " + ue.getVersion() + " available!", buttons, "Upgrade information", mal);
        mal.setFrame(newFrame);
    }

    private void checkClock() {
        String headerLine;
        long now = System.currentTimeMillis();
        if (lastTime != 0L && lastTime + 60000L < now) {
            this.handleSleepDeprivation(now - lastTime);
        }
        lastTime = now;
        String defaultServerTime = this.serverManager.getDefaultServerTime();
        if (JConfig.queryConfiguration("display.toolbar", "true").equals("true")) {
            defaultServerTime = "<b>" + defaultServerTime.replace("@", "</b><br>");
        }
        if (!this._userValid) {
            defaultServerTime = "Not logged in...";
        }
        String string = headerLine = this.getLinkUp() ? defaultServerTime : "<strike>" + defaultServerTime + "</strike>";
        if (this.mSmall) {
            headerLine = "<small>" + headerLine + "</small>";
        }
        headerLine = "<html><body>" + headerLine + "</body></html>";
        MQFactory.getConcrete("Swing").enqueue("HEADER " + headerLine);
    }

    private void handleSleepDeprivation(long delta) {
        Date now = new Date();
        String status = "We appear to be waking from sleep; networking may not be up yet.";
        JConfig.log().logDebug(status);
        JConfig.getMetrics().trackEventTimed("sleep", "sleep", (int)delta, true);
        List<AuctionEntry> sniped = this.entryCorral.findAllSniped();
        if (sniped != null && !sniped.isEmpty()) {
            boolean foundSnipe = false;
            for (AuctionEntry entry : sniped) {
                entry.setLastStatus(status);
                if (!now.after(entry.getEndDate())) continue;
                entry.setLastStatus("The computer may have slept through the snipe time!");
                foundSnipe = true;
            }
            if (foundSnipe) {
                status = status + "  One or more snipes may not have been fired.";
                JConfig.getMetrics().trackEvent("sleep", "snipe_missed");
            }
            MQFactory.getConcrete("Swing").enqueue("NOTIFY" + status);
        }
        this.pauseManager.pause(20);
        AuctionServer mainServer = this.serverManager.getServer();
        long wakeUp = System.currentTimeMillis() + 25000L;
        AuctionQObject updateEvent = new AuctionQObject(4, "Update login cookie", null);
        SuperQueue.getInstance().getQueue().add(updateEvent, mainServer.getFriendlyName(), wakeUp);
    }
}

