/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction;

import com.jbidwatcher.auction.AuctionActionImpl;
import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.util.Currency;

public class AuctionBuy
extends AuctionActionImpl {
    public AuctionBuy(AuctionEntry ae, Currency amount, int quantity) {
        super(ae.getIdentifier(), amount.fullCurrency(), quantity);
    }

    @Override
    protected int execute(AuctionEntry ae, Currency curr, int quant) {
        return ae.buy(quant);
    }

    @Override
    public String getBidResult(Currency bidAmount, int bidResult) {
        String bidResultString;
        switch (bidResult) {
            case -1: {
                bidResultString = "Purchasing apparently failed for an unknown reason.  Check the auction in the browser, to see if it went through anyway.";
                break;
            }
            case 1: 
            case 9: {
                bidResultString = "Purchasing apparently failed, as the auction cannot be bought from anymore (probably ended)!";
                break;
            }
            case 10: {
                bidResultString = "Your purchase failed, as you are disallowed from buying this seller's items.";
                break;
            }
            case 12: {
                bidResultString = "Purchase failed due to connection problem.  Probably a timeout trying to reach eBay.";
                break;
            }
            case 14: {
                bidResultString = "Your purchase failed because the item was removed from JBidwatcher before it executed.";
                break;
            }
            case 15: {
                bidResultString = "You cannot purchase this item, it is not a Buy It Now item.";
                break;
            }
            case 16: {
                bidResultString = "Congratulations!  You successfully bought it!";
                break;
            }
            default: {
                return super.getBidResult(bidAmount, bidResult);
            }
        }
        return bidResultString;
    }
}

