/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction;

import com.jbidwatcher.util.HashBacked;
import com.jbidwatcher.util.db.ActiveRecord;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

abstract class EntryCorralTemplate<T extends ActiveRecord> {
    private Map<String, Reference<T>> mEntryList = new HashMap<String, Reference<T>>();
    private final Map<String, Lock> mLockList = new HashMap<String, Lock>();

    protected EntryCorralTemplate() {
    }

    private T get(String identifier) {
        Reference<T> r = this.mEntryList.get(identifier);
        if (r != null) {
            return (T)((ActiveRecord)r.get());
        }
        return null;
    }

    public abstract T getItem(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveRecord takeForWrite(String identifier) {
        T result = this.get(identifier);
        if (result == null) {
            result = this.getItem(identifier);
        }
        if (result != null) {
            Lock l = this.mLockList.get(identifier);
            if (l == null) {
                l = new ReentrantLock(true);
                Map<String, Lock> map = this.mLockList;
                synchronized (map) {
                    this.mLockList.put(identifier, l);
                }
            }
            l.lock();
        }
        return result;
    }

    public void release(String identifier) {
        Lock l = this.mLockList.get(identifier);
        if (l != null) {
            l.unlock();
        }
    }

    public T takeForRead(String identifier) {
        T result = this.get(identifier);
        if (result == null && (result = this.getItem(identifier)) != null) {
            this.mEntryList.put(identifier, new WeakReference<T>(result));
        }
        return result;
    }

    public T put(T ae) {
        T result = this.chooseLatest(ae, ((ActiveRecord)ae).getUnique());
        this.mEntryList.put(((ActiveRecord)ae).getUnique(), new SoftReference<T>(result));
        return result;
    }

    public T putWeakly(T ae) {
        return this.chooseLatest(ae, ((ActiveRecord)ae).getUnique());
    }

    protected T chooseLatest(T ae, String identifier) {
        T chosen;
        Date existingDate;
        T existing = this.get(identifier);
        Date inputDate = ((HashBacked)ae).getDate("updated_at");
        Date date = existingDate = existing == null ? null : ((HashBacked)existing).getDate("updated_at");
        if (existing == null || inputDate != null && existingDate == null || inputDate != null && inputDate.after(existingDate)) {
            if (this.mEntryList.get(identifier) instanceof SoftReference) {
                this.mEntryList.put(identifier, new SoftReference<T>(ae));
            } else {
                this.mEntryList.put(identifier, new WeakReference<T>(ae));
            }
            chosen = ae;
        } else {
            chosen = existing;
        }
        return chosen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T erase(String identifier) {
        Map<String, Lock> map = this.mLockList;
        synchronized (map) {
            Lock l = this.mLockList.remove(identifier);
            Reference<T> rval = this.mEntryList.remove(identifier);
            if (l != null) {
                l.unlock();
            }
            if (rval == null) {
                return null;
            }
            return (T)((ActiveRecord)rval.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, Lock> map = this.mLockList;
        synchronized (map) {
            for (String s : this.mLockList.keySet()) {
                this.erase(s);
            }
            this.mEntryList.clear();
        }
    }
}

