/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction;

import com.jbidwatcher.auction.AuctionInfo;
import com.jbidwatcher.auction.Thumbnail;
import com.jbidwatcher.util.ByteBuffer;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.http.Http;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.MessageQueue;
import java.net.URL;

public class ThumbnailLoader
implements MessageQueue.Listener {
    private static ThumbnailLoader sInstance = null;

    private ThumbnailLoader() {
    }

    @Override
    public void messageAction(Object deQ) {
        ByteBuffer thumbnailImage;
        AuctionInfo ai = (AuctionInfo)deQ;
        String thumbnail = ai.getThumbnailURL();
        if (thumbnail == null) {
            thumbnail = ai.getAlternateSiteThumbnail();
        }
        if ((thumbnailImage = this.getThumbnailByURL(thumbnail)) != null && thumbnailImage.getLength() == 0) {
            thumbnailImage = null;
        }
        String imgPath = Thumbnail.getValidImagePath(ai.getIdentifier(), thumbnailImage);
        ai.setThumbnail(imgPath);
        MQFactory.getConcrete("redraw").enqueue(ai.getIdentifier());
    }

    private ByteBuffer getThumbnailByURL(String url) {
        ByteBuffer tmpThumb;
        try {
            tmpThumb = ThumbnailLoader.downloadThumbnail(JConfig.getURL(url));
        }
        catch (Exception ignored) {
            tmpThumb = null;
        }
        return tmpThumb;
    }

    public static ByteBuffer downloadThumbnail(URL img) {
        ByteBuffer tmpThumb = Http.net().getURL(img);
        if (tmpThumb.getCRC() == -1359354073 || tmpThumb.getCRC() == 1031533902 || tmpThumb.getCRC() == 124447227 || tmpThumb.getCRC() == 236643081 || (long)tmpThumb.getCRC() == Long.parseLong(JConfig.queryConfiguration("thumbnail.crc", "0"), 16) || tmpThumb.getCRC() == 1571510559) {
            tmpThumb = null;
        }
        return tmpThumb;
    }

    public static void start() {
        if (sInstance == null) {
            sInstance = new ThumbnailLoader();
            MQFactory.getConcrete("thumbnail").registerListener(sInstance);
        }
    }
}

