/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction.server;

import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.AuctionInfo;
import com.jbidwatcher.auction.AuctionServerInterface;
import com.jbidwatcher.auction.EntryCorral;
import com.jbidwatcher.auction.ItemParser;
import com.jbidwatcher.auction.SpecificAuction;
import com.jbidwatcher.auction.server.ServerMenu;
import com.jbidwatcher.scripting.Scripting;
import com.jbidwatcher.search.SearchManager;
import com.jbidwatcher.search.SearchManagerInterface;
import com.jbidwatcher.util.Currency;
import com.jbidwatcher.util.Pair;
import com.jbidwatcher.util.Record;
import com.jbidwatcher.util.StringTools;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.http.CookieJar;
import com.jbidwatcher.util.http.Http;
import com.jbidwatcher.util.queue.AuctionQObject;
import com.jbidwatcher.util.queue.MQFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Map;

public abstract class AuctionServer
implements AuctionServerInterface {
    private static long sLastUpdated = 0L;
    protected EntryCorral entryCorral;
    protected SearchManager searcher;

    public abstract CookieJar getNecessaryCookie(boolean var1);

    public abstract ServerMenu establishMenu();

    public abstract void cancelSearches();

    public abstract void addSearches(SearchManagerInterface var1);

    @Override
    public abstract void updateHighBid(String var1);

    @Override
    public abstract void setSnipe(String var1);

    @Override
    public abstract void cancelSnipe(String var1);

    @Override
    public abstract String getStringURLFromItem(String var1);

    public abstract SpecificAuction getNewSpecificAuction();

    protected abstract Date getOfficialTime();

    protected abstract StringBuffer getAuction(String var1) throws FileNotFoundException;

    protected abstract ItemParser getItemParser(StringBuffer var1, AuctionEntry var2, String var3);

    protected abstract String getUserId();

    @Override
    public void reloadTime() {
        if (this.getOfficialTime() != null) {
            MQFactory.getConcrete("Swing").enqueue("Successfully synchronized time with " + this.getFriendlyName() + '.');
            JConfig.log().logMessage("Time delta with " + this.getFriendlyName() + " is " + this.getServerTimeDelta());
        } else {
            MQFactory.getConcrete("Swing").enqueue("Failed to synchronize time with " + this.getFriendlyName() + '!');
        }
    }

    @Override
    public AuctionInfo create(String itemId) {
        return this.load(itemId, null);
    }

    @Override
    public StringBuffer getAuction(URL auctionURL) throws FileNotFoundException {
        StringBuffer loadedPage;
        if (auctionURL == null) {
            return null;
        }
        try {
            CookieJar curCook = this.getNecessaryCookie(false);
            URLConnection uc = curCook != null ? curCook.connect(auctionURL.toString()) : Http.net().makeRequest(auctionURL, null);
            loadedPage = Http.net().receivePage(uc);
            if (loadedPage != null && loadedPage.length() == 0) {
                loadedPage = null;
            }
        }
        catch (FileNotFoundException fnfe) {
            JConfig.log().logDebug("Item not found: " + auctionURL.toString());
            throw fnfe;
        }
        catch (IOException e) {
            JConfig.log().handleException("Error loading URL (" + auctionURL.toString() + ')', e);
            loadedPage = null;
        }
        return loadedPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuctionInfo reload(String auctionId) {
        AuctionEntry ae = (AuctionEntry)this.entryCorral.takeForWrite(auctionId);
        try {
            AuctionInfo ai = ae.getAuction();
            Map<String, Object> r = this.rubyUpdate(auctionId, ae.getLastUpdated());
            if (r != null && !r.isEmpty()) {
                ai.setMonetary("curBid", Currency.getCurrency((String)r.get("current_price")));
                ai.setBoolean("ended", (Boolean)r.get("ended"));
                ai.setNumBids(((Long)r.get("bid_count")).intValue());
                ai.setDate("end", new Date((Long)r.get("end_date")));
                ai.saveDB();
                ae.setAuctionInfo(ai);
                ae.clearInvalid();
                MQFactory.getConcrete("Swing").enqueue("LINK UP");
                AuctionInfo auctionInfo = ai;
                return auctionInfo;
            }
            AuctionInfo curAuction = this.load(auctionId, ae);
            if (curAuction != null) {
                curAuction.saveDB();
                ae.setAuctionInfo(curAuction);
                ae.clearInvalid();
                MQFactory.getConcrete("Swing").enqueue("LINK UP");
                AuctionInfo auctionInfo = curAuction;
                return auctionInfo;
            }
            if (!ae.isDeleted() && !ae.getLastStatus().contains("Seller away - item unavailable.")) {
                ae.setLastStatus("Failed to load from server!");
                ae.setInvalid();
            }
            AuctionInfo auctionInfo = null;
            return auctionInfo;
        }
        finally {
            this.entryCorral.release(auctionId);
        }
    }

    public ParseResults parseAuction(ItemParser itemParser, AuctionEntry ae) {
        Record parse;
        ItemParser.ParseErrors setResult;
        String sellerName = null;
        SpecificAuction auction = this.getNewSpecificAuction();
        AuctionInfo output = auction;
        if (ae != null) {
            output = ae.getAuction();
            sellerName = ae.getSellerName();
        }
        if ((setResult = auction.setFields(parse = itemParser.parseItemDetails(), sellerName)) == ItemParser.ParseErrors.SELLER_AWAY && ae != null) {
            ae.setLastStatus("Seller away - item unavailable.");
        }
        if (setResult == ItemParser.ParseErrors.SUCCESS && output != auction) {
            Record newBacking = auction.getBacking();
            for (String key : newBacking.keySet()) {
                output.set(key, (String)newBacking.get(key));
            }
        }
        return new ParseResults(output, setResult);
    }

    public AuctionInfo doParse(StringBuffer sb) throws ReloadItemException {
        return this.doParse(sb, null, null);
    }

    public Map<String, Object> rubyUpdate(String auctionId, Date lastUpdatedAt) {
        long before = System.currentTimeMillis();
        try {
            Map maps = (Map)Scripting.rubyMethod("get_update", auctionId, lastUpdatedAt);
            if (maps != null) {
                String timerLog = "Ruby took " + (System.currentTimeMillis() - before) + "ms";
                JConfig.log().logMessage(timerLog);
                return maps;
            }
        }
        catch (Exception e) {
            JConfig.log().logMessage("Could not parse easy-update.  Using complex update.");
        }
        String timerLog = "Ruby took " + (System.currentTimeMillis() - before) + "ms, and failed.";
        JConfig.log().logMessage(timerLog);
        return null;
    }

    public Record tryRuby(StringBuffer sb) {
        long before = System.currentTimeMillis();
        Record rubyResults = null;
        try {
            Map maps = (Map)Scripting.rubyMethod("parse", sb.toString());
            if (maps != null) {
                rubyResults = new Record();
                rubyResults.putAll(maps);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Ruby took " + (System.currentTimeMillis() - before));
        return rubyResults;
    }

    @Override
    public boolean isCurrentUser(String username) {
        return username != null && !this.isDefaultUser() && this.getUserId().trim().equalsIgnoreCase(username.trim());
    }

    protected URL getURLFromItem(String itemID) {
        return StringTools.getURLFromString(this.getStringURLFromItem(itemID));
    }

    private AuctionInfo load(String item_id, AuctionEntry ae) {
        StringBuffer sb = null;
        AuctionInfo curAuction = null;
        for (int runCount = 0; sb == null && runCount < 2; ++runCount) {
            sb = this.retrieveAuction(item_id, ae);
            if (sb == null && (ae == null || ae.isDeleted())) {
                if (ae != null) {
                    ae.saveDB();
                }
                return null;
            }
            try {
                curAuction = this.doParse(sb, ae, item_id);
                continue;
            }
            catch (ReloadItemException e) {
                sb = null;
            }
        }
        if (curAuction == null) {
            JConfig.log().logMessage("Multiple failures attempting to load item " + item_id + ", giving up.");
            JConfig.getMetrics().trackEventValue("item", "loadfailure", item_id);
            if (ae != null && ae.getLastStatus().contains("Seller away - item unavailable.")) {
                ae.setInvalid();
            } else if (ae == null || !ae.isDeleted()) {
                this.noteRetrieveError(ae);
            }
        }
        return curAuction;
    }

    private StringBuffer retrieveAuction(String item_id, AuctionEntry ae) {
        StringBuffer sb;
        block4: {
            sb = null;
            try {
                sb = this.getAuction(item_id);
                if (sb != null && ae != null) {
                    ae.clearDeleted();
                }
            }
            catch (FileNotFoundException ignored) {
                this.markAuctionDeleted(ae);
            }
            catch (Exception catchall) {
                if (!JConfig.debugging()) break block4;
                JConfig.log().handleException("Some unexpected error occurred during loading the auction.", catchall);
            }
        }
        return sb;
    }

    private AuctionInfo doParse(StringBuffer sb, AuctionEntry ae, String item_id) throws ReloadItemException {
        ItemParser itemParser = this.getItemParser(sb, ae, item_id);
        ParseResults parse = this.parseAuction(itemParser, ae);
        AuctionInfo curAuction = (AuctionInfo)parse.getFirst();
        if (parse.getLast() == ItemParser.ParseErrors.SUCCESS) {
            if (item_id != null) {
                curAuction.setIdentifier(item_id);
            } else if (ae != null && ae.getIdentifier() != null) {
                curAuction.setIdentifier(ae.getIdentifier());
            }
            curAuction.setContent(sb, false);
            curAuction.save();
        } else {
            String error = this.checkParseError(ae, (ItemParser.ParseErrors)((Object)parse.getLast()));
            JConfig.log().logMessage(error);
            if (ae == null || !ae.isDeleted() && parse.getLast() != ItemParser.ParseErrors.SELLER_AWAY) {
                this.checkLogError(ae);
            }
            curAuction = null;
        }
        return curAuction;
    }

    private String checkParseError(AuctionEntry ae, ItemParser.ParseErrors result) throws ReloadItemException {
        String error = null;
        switch (result) {
            case WRONG_SITE: {
                JConfig.log().logMessage("Attempted to read an auction that is not available on the default site; check eBay's non-US configuration.");
                error = "Auction is not available on the used site.";
                break;
            }
            case CAPTCHA: {
                JConfig.log().logDebug("Failed to load (likely adult) item, captcha intervened.");
                if (ae != null) {
                    ae.setLastStatus("Couldn't access auction on server; captcha blocked.");
                }
                error = "Couldn't access auction on server; captcha blocked.";
                break;
            }
            case NOT_ADULT: {
                boolean isAdult = JConfig.queryConfiguration(this.getName() + ".mature", "false").equals("true");
                if (isAdult) {
                    this.getNecessaryCookie(true);
                    throw new ReloadItemException();
                }
                JConfig.log().logDebug("Failed to load adult item, user possibly not marked for Mature Items access.  Check your eBay configuration.");
                error = "Failed to load mature audiences item.";
                break;
            }
            case DELETED: {
                error = this.markAuctionDeleted(ae);
                break;
            }
            case SELLER_AWAY: {
                error = "Seller away - item unavailable.";
                break;
            }
            case BAD_TITLE: {
                error = "There was a problem parsing the title.";
            }
        }
        if (result != ItemParser.ParseErrors.SUCCESS && error == null) {
            error = "Bad Parse!";
        }
        return error;
    }

    private String markAuctionDeleted(AuctionEntry ae) {
        String error = "Auction appears to have been removed from the site.";
        if (ae != null) {
            ae.setDeleted();
            error = "Auction " + ae.getIdentifier() + " appears to have been removed from the site.";
            ae.setLastStatus(error);
        }
        return error;
    }

    private void noteRetrieveError(AuctionEntry ae) {
        this.checkLogError(ae);
        JConfig.log().logDebug("Failed to parse auction!  Bad return result from auction server.");
        if (sLastUpdated + 600000L > System.currentTimeMillis()) {
            sLastUpdated = System.currentTimeMillis();
            MQFactory.getConcrete(this.getFriendlyName()).enqueueBean(new AuctionQObject(4, "Update login cookie", null));
        }
    }

    private void checkLogError(AuctionEntry ae) {
        if (ae != null) {
            ae.logError();
        } else {
            MQFactory.getConcrete("Swing").enqueue("LINK DOWN Communications failure talking to the server");
        }
    }

    @Override
    public String stripId(String source) {
        String strippedId = source;
        if (source.startsWith("http")) {
            strippedId = this.extractIdentifierFromURLString(source);
        }
        return strippedId;
    }

    private class ParseResults
    extends Pair<AuctionInfo, ItemParser.ParseErrors> {
        private ParseResults(AuctionInfo info, ItemParser.ParseErrors parseErrors) {
            super(info, parseErrors);
        }
    }

    private static class ReloadItemException
    extends Exception {
        private ReloadItemException() {
        }
    }
}

