/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.platform;

import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.MessageQueue;
import java.awt.AWTException;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class Tray
implements ItemListener,
MessageQueue.Listener {
    private JMenuItem hideRestore;
    private SystemTray systemTray = null;
    private TrayIcon trayIcon = null;
    private TrayIcon.MessageType infoMessageType = null;

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    private Tray() {
        TrayMenuAction tma = new TrayMenuAction();
        System.setProperty("javax.swing.adjustPopupLocationToFit", "false");
        JPopupMenu menu = new JPopupMenu("JBidwatcher Tray Menu");
        this.hideRestore = new JMenuItem("Hide");
        this.hideRestore.getAccessibleContext().setAccessibleDescription("Restores JBidwatcher window to the display.");
        this.hideRestore.addActionListener(tma);
        this.hideRestore.setActionCommand("HIDE");
        menu.add(this.hideRestore);
        menu.addSeparator();
        JMenuItem searchMenuItem = new JMenuItem("Search...");
        searchMenuItem.addActionListener(tma);
        searchMenuItem.setActionCommand("SEARCH");
        menu.add(searchMenuItem);
        JMenuItem configMenuItem = new JMenuItem("Configure...");
        configMenuItem.addActionListener(tma);
        configMenuItem.setActionCommand("CONFIGURE");
        menu.add(configMenuItem);
        menu.addSeparator();
        JMenuItem quitMenuItem = new JMenuItem("Quit", 81);
        quitMenuItem.setActionCommand("QUIT");
        quitMenuItem.getAccessibleContext().setAccessibleDescription("Close JBidwatcher.");
        quitMenuItem.addActionListener(tma);
        menu.add(quitMenuItem);
        URL iconURL = JConfig.getResource(JConfig.queryConfiguration("icon", "/jbidwatch64.jpg"));
        ImageIcon jbw_icon = new ImageIcon(iconURL);
        this.setSystemTray(menu, jbw_icon);
    }

    private boolean setSystemTray(final JPopupMenu menu, ImageIcon jbw_icon) {
        if (!SystemTray.isSupported()) {
            return false;
        }
        this.systemTray = SystemTray.getSystemTray();
        this.trayIcon = new TrayIcon(jbw_icon.getImage(), "JBidwatcher", null);
        this.trayIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    menu.setLocation(e.getX(), e.getY());
                    menu.setInvoker(menu);
                    menu.setVisible(true);
                }
            }
        });
        this.trayIcon.setImageAutoSize(true);
        this.trayIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MQFactory.getConcrete("Swing").enqueue("VISIBILITY");
            }
        });
        this.infoMessageType = TrayIcon.MessageType.INFO;
        return true;
    }

    @Override
    public void messageAction(Object deQ) {
        String msg = (String)deQ;
        if (msg.startsWith("TOOLTIP ")) {
            String msgText = "JBidwatcher 2.99pre5\n" + msg.substring(8);
            this.trayIcon.setToolTip(msgText);
        } else if (msg.startsWith("NOTIFY ")) {
            this.trayIcon.displayMessage("JBidwatcher Alert", msg.substring(7), this.infoMessageType);
        } else if (msg.startsWith("HIDDEN")) {
            this.hideRestore.setText("Restore");
            this.hideRestore.setActionCommand("RESTORE");
        } else if (msg.startsWith("RESTORED")) {
            this.hideRestore.setText("Hide");
            this.hideRestore.setActionCommand("HIDE");
        } else if (msg.startsWith("TRAY")) {
            String onOff = msg.substring(5);
            if (onOff.equals("on")) {
                try {
                    this.systemTray.add(this.trayIcon);
                }
                catch (AWTException noTray) {
                    JConfig.log().logMessage("Could not add the system tray; it's not currently visible: " + noTray.getMessage());
                }
            } else {
                this.systemTray.remove(this.trayIcon);
            }
        }
    }

    public static void start() {
        MQFactory.getConcrete("tray").registerListener(new Tray());
    }

    private class TrayMenuAction
    implements ActionListener {
        private TrayMenuAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.startsWith("SEARCH")) {
                MQFactory.getConcrete("user").enqueue("SEARCH");
                return;
            }
            if (cmd.startsWith("CONFIGURE")) {
                MQFactory.getConcrete("user").enqueue("Configure");
                return;
            }
            if (cmd.indexOf(32) == -1) {
                MQFactory.getConcrete("Swing").enqueue(cmd);
            } else {
                String s = "Action event detected.\n    Event source: " + e.getSource() + " (an instance of " + e.getSource().getClass().getCanonicalName() + ")\n    ActionCommand: " + e.getActionCommand();
                JConfig.log().logDebug(s);
            }
        }
    }
}

