/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.scripting;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jbidwatcher.scripting.Scripting;
import com.jbidwatcher.util.config.JConfig;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

@Singleton
public class JRubyPreloader
implements Runnable {
    private final Object syncObject;

    @Inject
    public JRubyPreloader(Object scriptSync) {
        this.syncObject = scriptSync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.syncObject;
        synchronized (object) {
            try {
                this.preloadLibrary();
                Scripting.initialize();
                JConfig.enableScripting();
                JConfig.log().logMessage("Scripting is enabled.");
            }
            catch (NoClassDefFoundError ncdfe) {
                JConfig.log().logMessage("Scripting is not enabled.");
            }
            catch (Throwable e) {
                JConfig.log().logMessage("Error setting up scripting: " + e.toString());
                JConfig.disableScripting();
            }
        }
    }

    private void preloadLibrary() {
        String jrubyFile = JConfig.queryConfiguration("platform.path") + File.separator + "jruby-incomplete.jar";
        File fp = new File(jrubyFile);
        if (fp.exists()) {
            try {
                URLClassLoader myCL;
                URL srcJar = fp.toURI().toURL();
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    myCL = cl instanceof URLClassLoader ? (URLClassLoader)cl : (URLClassLoader)cl.getParent();
                }
                catch (ClassCastException cce) {
                    throw new RuntimeException("Can't locate a valid class loader to bring in the scripting library.");
                }
                Class<URLClassLoader> sysClass = URLClassLoader.class;
                Method sysMethod = sysClass.getDeclaredMethod("addURL", URL.class);
                sysMethod.setAccessible(true);
                sysMethod.invoke((Object)myCL, srcJar);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

