/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.cyberfox.util.platform.Path;
import com.jbidwatcher.search.SearchManager;
import com.jbidwatcher.search.Searcher;
import com.jbidwatcher.ui.JBidTableContext;
import com.jbidwatcher.ui.JTabManager;
import com.jbidwatcher.ui.ListManager;
import com.jbidwatcher.ui.SearchInfoDialog;
import com.jbidwatcher.ui.util.JPasteListener;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.MQFactory;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class JSearchContext
extends JBidTableContext {
    private static SearchInfoDialog _searchDetail = null;
    private final SearchManager searchManager;
    private final ListManager listManager;
    private final JPasteListener pasteListener;
    private static final int EXECUTE = 0;
    private static final int ENABLE = 1;
    private static final int DISABLE = 2;
    private static final int EDIT = 3;
    private static final int NEW = 4;

    private void addMenu(JPopupMenu p, String name, String cmd) {
        p.add(this.makeMenuItem(name, cmd)).addActionListener(this);
    }

    private void addMenu(JPopupMenu p, String name) {
        p.add(this.makeMenuItem(name)).addActionListener(this);
    }

    @Override
    protected void internalDoubleClick(MouseEvent e) {
        if (!(e.getComponent() instanceof JComponent)) {
            return;
        }
        JComponent inComponent = (JComponent)e.getComponent();
        if (inComponent instanceof JTable) {
            JTable thisTable = (JTable)inComponent;
            int rowPoint = thisTable.rowAtPoint(new Point(e.getX(), e.getY()));
            Searcher whichSearch = (Searcher)thisTable.getValueAt(rowPoint, -1);
            whichSearch.execute();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String actionString = ae.getActionCommand();
        Searcher whichSearch = null;
        if (actionString.startsWith("NC-")) {
            actionString = actionString.substring("NC-".length());
        } else if (this._inTable != null) {
            int rowPoint = this._inTable.rowAtPoint(new Point(this.getPopupX(), this.getPopupY()));
            whichSearch = (Searcher)this._inTable.getValueAt(rowPoint, -1);
        }
        this.DoAction(actionString, whichSearch);
    }

    protected final JPopupMenu constructTablePopup() {
        JPopupMenu pop = new JPopupMenu();
        this.addMenu(pop, "Do Search", "Execute");
        this.addMenu(pop, "Load Searches");
        this.addMenu(pop, "Edit Search");
        pop.add(new JPopupMenu.Separator());
        this.addMenu(pop, "Enable");
        this.addMenu(pop, "Disable");
        pop.add(new JPopupMenu.Separator());
        this.addMenu(pop, "Delete");
        return pop;
    }

    private void changeTable() {
        TableModel tm = this._inTable.getModel();
        this._inTable.tableChanged(new TableModelEvent(tm));
    }

    private void handleSave(boolean success) {
        if (success) {
            JOptionPane.showMessageDialog(null, "Searches Saved!", "Save Complete", 1);
        } else {
            String saveFile = JConfig.queryConfiguration("search.savefile", "searches.xml");
            saveFile = Path.getCanonicalFile(saveFile, "jbidwatcher", false);
            MQFactory.getConcrete("Swing").enqueue("ERROR Failed to save searches.  Check that the directory for\n" + saveFile + " exists, and is writable.");
        }
    }

    private void showEdit(Searcher s) {
        if (_searchDetail == null) {
            _searchDetail = new SearchInfoDialog(this.searchManager, this.listManager, this.pasteListener);
        }
        _searchDetail.prepare(s);
        _searchDetail.pack();
        _searchDetail.setVisible(true);
        this.changeTable();
    }

    private void doSingle(Searcher s, int cmd) {
        switch (cmd) {
            case 0: {
                s.execute();
                break;
            }
            case 1: {
                s.enable();
                break;
            }
            case 2: {
                s.disable();
                break;
            }
            case 3: {
                this.showEdit(s);
                break;
            }
            case 4: {
                this.showEdit(s);
                break;
            }
        }
    }

    private void doCommand(Searcher s, int cmd, String no_items_msg) {
        int[] rows = this.getPossibleRows();
        if (rows.length == 0 && s != null) {
            this.doSingle(s, cmd);
        } else if (rows.length == 0) {
            JOptionPane.showMessageDialog(this._inTable, no_items_msg, "No search(es) chosen", 1);
        } else {
            for (int row : rows) {
                this.doSingle((Searcher)this._inTable.getValueAt(row, -1), cmd);
            }
        }
        this.changeTable();
    }

    private void DoExecute(Searcher s) {
        this.doCommand(s, 0, "You must select at least one search to execute first.");
    }

    private void DoEnable(Searcher s) {
        this.doCommand(s, 1, "You must select at least one search to enable first.");
    }

    private void DoDisable(Searcher s) {
        this.doCommand(s, 2, "You must select at least one search to disable first.");
    }

    private void DoEdit(Searcher s) {
        this.doCommand(s, 3, "You must select at least one search to edit first.");
    }

    private void DoNew() {
        this.doSingle(null, 4);
    }

    protected boolean confirmDeletion(Component src, String prompt) {
        int endResult = JOptionPane.showOptionDialog(src, prompt, "Confirm", 2, -1, null, null, null);
        return endResult != 2 && endResult != -1;
    }

    private void DoDelete(Searcher chosenSearch) {
        Searcher s = chosenSearch;
        int[] rows = this.getPossibleRows();
        if (rows.length <= 1 && s != null) {
            String prompt;
            if (rows.length == 1) {
                s = (Searcher)this._inTable.getValueAt(rows[0], -1);
            }
            if (this.confirmDeletion(null, prompt = "<HTML><BODY>Are you sure you want to remove this search?<br><b>" + s.getName() + "</b></body></html>")) {
                this.searchManager.deleteSearch(s);
            }
        } else if (rows.length == 0) {
            JOptionPane.showMessageDialog(this._inTable, "You must select what searches to delete first.", "No search", 1);
        } else {
            String prompt = "Are you sure you want to remove all selected searches?";
            if (this.confirmDeletion(null, prompt)) {
                ArrayList<Searcher> delList = new ArrayList<Searcher>();
                for (int row : rows) {
                    s = (Searcher)this._inTable.getValueAt(row, -1);
                    delList.add(s);
                }
                Object object = delList.iterator();
                while (object.hasNext()) {
                    Searcher del = (Searcher)object.next();
                    this.searchManager.deleteSearch(del);
                }
            }
        }
        this.changeTable();
    }

    public void DoAction(String cmd, Object param) {
        Searcher search = (Searcher)param;
        if (cmd.equals("Execute")) {
            this.DoExecute(search);
        } else if (cmd.equals("Edit Search")) {
            this.DoEdit(search);
        } else if (cmd.equals("New")) {
            this.DoNew();
        } else if (cmd.equals("Delete")) {
            this.DoDelete(search);
        } else if (cmd.equals("Enable")) {
            this.DoEnable(search);
        } else if (cmd.equals("Disable")) {
            this.DoDisable(search);
        } else if (cmd.equals("Save All")) {
            this.handleSave(this.searchManager.saveSearches());
        } else if (cmd.equals("Load Searches")) {
            this.searchManager.loadSearches();
            this.changeTable();
        } else {
            System.out.println("Cannot figure out what '" + cmd + "'.");
        }
    }

    public JSearchContext(SearchManager searchManager, JTabManager tabManager, ListManager listManager, JPasteListener pasteListener) {
        super(tabManager, listManager);
        this.searchManager = searchManager;
        this.listManager = listManager;
        this.pasteListener = pasteListener;
        this.localPopup = this.constructTablePopup();
    }

    @Override
    protected void DoAction(Object src, String actionString, Object whichEntry) {
        this.DoAction(actionString, whichEntry);
    }
}

