/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.jbidwatcher.ui.FilterManager;
import com.jbidwatcher.ui.JTabProperties;
import com.jbidwatcher.ui.ListManager;
import com.jbidwatcher.ui.config.JConfigFrame;
import com.jbidwatcher.ui.table.TableColumnController;
import com.jbidwatcher.ui.util.JBidFrame;
import com.jbidwatcher.ui.util.JContext;
import com.jbidwatcher.ui.util.OptionUI;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.MessageQueue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JTabPopupMenu
extends JContext
implements MessageQueue.Listener {
    private JTabbedPane mTabs = null;
    private JMenu customize = null;
    private JMenuItem _print = null;
    private JMenu _deleteSubmenu = null;
    private Map<String, JCheckBoxMenuItem> menuItemMap = new TreeMap<String, JCheckBoxMenuItem>();
    private FilterManager mFilter;
    private final ListManager listManager;
    protected JFrame propFrame = null;
    private TreeMap<String, JTabProperties> tabToProperties = null;

    @Inject
    public JTabPopupMenu(ListManager listManager, FilterManager filters, @Assisted JTabbedPane inTabs, @Nullable @Assisted JPopupMenu popup) {
        this.listManager = listManager;
        this.mFilter = filters;
        this.mTabs = inTabs;
        if (popup != null) {
            this.localPopup = popup;
            this.makeTabMenu(this.localPopup);
        } else {
            this.localPopup = new JPopupMenu();
            this.makeTabMenu(this.localPopup);
            inTabs.addMouseListener(this);
        }
    }

    public void makeTabMenu(JPopupMenu myPopup) {
        this.customize = new JMenu("Custom Columns");
        this.customize.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                JTabPopupMenu.this.prepCustomColumnMenu(null);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                JTabPopupMenu.this.customize.getPopupMenu().setInvoker(JTabPopupMenu.this.customize);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        myPopup.add(this.makeMenuItem("Add Tab")).addActionListener(this);
        this._deleteSubmenu = new JMenu("Delete");
        this._deleteSubmenu.add(this.makeMenuItem("Just Tab")).addActionListener(this);
        this._deleteSubmenu.add(this.makeMenuItem("Tab & All Entries")).addActionListener(this);
        myPopup.add(this._deleteSubmenu);
        myPopup.add(this.customize).addActionListener(this);
        this._print = this.makeMenuItem("Print");
        myPopup.add(this._print).addActionListener(this);
        myPopup.add(this.makeMenuItem("Export")).addActionListener(this);
        myPopup.add(this.makeMenuItem("Properties")).addActionListener(this);
    }

    @Override
    protected void beforePopup(JPopupMenu inPopup, MouseEvent e) {
        super.beforePopup(inPopup, e);
        int curIndex = this.mTabs.indexAtLocation(e.getX(), e.getY());
        if (curIndex == -1) {
            int tabCount = this.mTabs.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                Rectangle tabBounds = this.mTabs.getBoundsAt(i);
                if (tabBounds == null || !tabBounds.contains(e.getPoint())) continue;
                curIndex = i;
            }
        }
        this.preparePopup(curIndex);
    }

    public void preparePopup(int curIndex) {
        if (curIndex == -1) {
            this.customize.setEnabled(false);
            this._deleteSubmenu.setEnabled(false);
            this._print.setEnabled(false);
            JConfig.log().logDebug("Whoops!  Click-point not found!");
        } else {
            this._print.setEnabled(true);
            this.prepCustomColumnMenu(curIndex);
            if (curIndex < 3) {
                this._deleteSubmenu.setEnabled(false);
            } else {
                this._deleteSubmenu.setEnabled(true);
            }
        }
    }

    public void prepCustomColumnMenu(Integer tabIndex) {
        this.customize.removeAll();
        Collection<String> nameCollection = TableColumnController.getInstance().getColumnNames();
        ArrayList<String> sortedNames = new ArrayList<String>(nameCollection);
        Collections.sort(sortedNames);
        for (String s : sortedNames) {
            JCheckBoxMenuItem colMenuItem = new JCheckBoxMenuItem(s);
            colMenuItem.setActionCommand('~' + s);
            this.customize.add(colMenuItem).addActionListener(this);
            this.menuItemMap.put(s, colMenuItem);
        }
        if (tabIndex == null) {
            tabIndex = this.mTabs.getSelectedIndex();
        }
        this.customize.setEnabled(true);
        String tabName = this.mTabs.getTitleAt(tabIndex);
        this.uncheckAll();
        this.setColumnChecks(tabName);
    }

    public JMenu getCustomizeMenu() {
        return this.customize;
    }

    private void setColumnChecks(String tabName) {
        List<String> columns = this.listManager.getColumns(tabName);
        for (String colName : columns) {
            JCheckBoxMenuItem jch = this.menuItemMap.get(colName);
            jch.setState(true);
        }
    }

    private void uncheckAll() {
        for (JCheckBoxMenuItem jch : this.menuItemMap.values()) {
            jch.setState(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        super.actionPerformed(ae);
        this.DoAction(ae.getActionCommand(), this.mTabs.getSelectedIndex());
    }

    protected JFrame getFrame(String tabName) {
        JTabProperties properties;
        if (this.propFrame == null) {
            this.propFrame = new JBidFrame("Tab Properties");
        }
        if (this.tabToProperties == null) {
            this.tabToProperties = new TreeMap();
        }
        if ((properties = this.tabToProperties.get(tabName)) == null) {
            properties = new JTabProperties(this.listManager, tabName);
            this.tabToProperties.put(tabName, properties);
        }
        properties.updateValues();
        Container content = this.propFrame.getContentPane();
        content.removeAll();
        content.setLayout(new BorderLayout());
        content.add((Component)properties, "Center");
        JPanel tmp = new JPanel();
        JButton ok = new JButton("OK");
        ok.addActionListener(properties);
        tmp.add((Component)ok, "Center");
        content.add((Component)tmp, "South");
        this.propFrame.addWindowListener(new JConfigFrame.IconifyingWindowAdapter(this.propFrame));
        this.propFrame.pack();
        this.propFrame.setResizable(false);
        properties.setFrame(this.propFrame);
        return this.propFrame;
    }

    @Override
    public void messageAction(Object deQ) {
        this.DoAction(deQ.toString(), -1);
    }

    protected void DoAction(String actionString, int tabIndex) {
        if (actionString.equals("Add Tab")) {
            OptionUI oui = new OptionUI();
            String result = oui.promptString(this.mTabs.getComponentAt(tabIndex >= 0 ? tabIndex : 0), "Enter the name of the tab to add.  Prefer brevity.", "Add New Tab", "");
            if (result == null) {
                return;
            }
            if ((result = result.trim()).length() == 0) {
                return;
            }
            this.mFilter.addTab(result);
            return;
        }
        String tabName = this.mTabs.getTitleAt(tabIndex);
        if (actionString.charAt(0) == '~') {
            JTabProperties properties;
            boolean result = this.listManager.toggleField(tabName, actionString.substring(1));
            if (this.tabToProperties != null && (properties = this.tabToProperties.get(tabName)) != null) {
                properties.setColumnStatus(actionString.substring(1), result);
            }
        }
        if (actionString.equals("Properties")) {
            JFrame jf = this.getFrame(tabName);
            jf.setState(0);
            jf.setVisible(true);
        }
        if (actionString.equals("Export")) {
            JFileChooser jfc = new JFileChooser();
            jfc.setApproveButtonText("Export");
            int result = jfc.showSaveDialog(null);
            switch (result) {
                case 0: {
                    String fname = jfc.getSelectedFile().getAbsolutePath();
                    if (!this.listManager.exportTab(tabName, fname)) {
                        JOptionPane.showMessageDialog(null, "Could not export tab [" + tabName + "].", "Export error", -1);
                    }
                    return;
                }
            }
            return;
        }
        if (actionString.equals("Print")) {
            if (tabIndex == -1) {
                JConfig.log().logDebug("Can't print unknown tab, must prompt...");
            } else if (!this.listManager.printTab(tabName)) {
                JOptionPane.showMessageDialog(null, "Could not print tab [" + tabName + "].", "Print error", -1);
            }
        }
        boolean eraseEntries = false;
        if (actionString.equals("Tab & All Entries")) {
            eraseEntries = true;
            actionString = "Just Tab";
        }
        if (actionString.equals("Just Tab")) {
            if (tabIndex == -1) {
                JConfig.log().logDebug("Prompting for Delete...\n");
            } else {
                JConfig.log().logDebug("Deleting tab [" + tabName + "]...\n");
                Component removed = this.listManager.deleteTab(tabName, eraseEntries);
                if (removed == null) {
                    JOptionPane.showMessageDialog(null, "Could not delete tab [" + tabName + "].", "Tab deletion error", -1);
                } else {
                    this.mTabs.remove(removed);
                }
            }
        }
    }
}

