/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.jbidwatcher.my.MyJBidwatcher;
import com.jbidwatcher.ui.util.JBidFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class SubmitLogDialog
extends JDialog {
    private final MyJBidwatcher myJBidwatcher;
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField mEmailAddressTextField;
    private JTextArea mProblemTextArea;

    public SubmitLogDialog(MyJBidwatcher myJBidwatcher) {
        this.$$$setupUI$$$();
        this.myJBidwatcher = myJBidwatcher;
        this.setContentPane(this.contentPane);
        if (JBidFrame.getDefaultMenuBar() != null) {
            this.setJMenuBar(JBidFrame.getDefaultMenuBar());
        }
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubmitLogDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubmitLogDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SubmitLogDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubmitLogDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    public void showDialog() {
        this.pack();
        this.mProblemTextArea.setText("");
        String email = this.mEmailAddressTextField.getText();
        this.setVisible(true);
        if (email != null && email.length() != 0) {
            this.mProblemTextArea.requestFocusInWindow();
        }
    }

    private void onOK() {
        String email = this.mEmailAddressTextField.getText();
        if (email == null || email.length() == 0) {
            JOptionPane.showMessageDialog(null, "Email Address Required", "An email address is necessary so I can contact you if I need more information.", 0);
        } else {
            this.myJBidwatcher.sendLogFile(email, this.mProblemTextArea.getText());
            this.dispose();
        }
    }

    private void onCancel() {
        this.dispose();
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridBagLayout());
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.contentPane.add((Component)panel1, gbc);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel1.add((Component)panel2, gbc);
        this.buttonOK = new JButton();
        this.buttonOK.setText("Send Error Log");
        this.buttonOK.setMnemonic('S');
        this.buttonOK.setDisplayedMnemonicIndex(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        panel2.add((Component)this.buttonOK, gbc);
        this.buttonCancel = new JButton();
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.setMnemonic('C');
        this.buttonCancel.setDisplayedMnemonicIndex(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        panel2.add((Component)this.buttonCancel, gbc);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.contentPane.add((Component)panel3, gbc);
        JLabel label1 = new JLabel();
        label1.setText("Email Address:");
        label1.setDisplayedMnemonic('E');
        label1.setDisplayedMnemonicIndex(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 2, 0, 0);
        panel3.add((Component)label1, gbc);
        this.mEmailAddressTextField = new JTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        panel3.add((Component)this.mEmailAddressTextField, gbc);
        JLabel label2 = new JLabel();
        label2.setText("Describe what went wrong:");
        label2.setDisplayedMnemonic('D');
        label2.setDisplayedMnemonicIndex(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        panel3.add((Component)label2, gbc);
        JScrollPane scrollPane1 = new JScrollPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel3.add((Component)scrollPane1, gbc);
        this.mProblemTextArea = new JTextArea();
        this.mProblemTextArea.setColumns(28);
        this.mProblemTextArea.setRows(10);
        scrollPane1.setViewportView(this.mProblemTextArea);
        label1.setLabelFor(this.mEmailAddressTextField);
        label2.setLabelFor(this.mProblemTextArea);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

