/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.jbidwatcher.ui.ImageDropResolver;
import com.jbidwatcher.ui.util.JDropHandler;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.html.JHTML;
import com.jbidwatcher.util.queue.DropQObject;
import com.jbidwatcher.util.queue.MQFactory;
import java.awt.Point;
import java.util.List;

public class TargetDrop
implements JDropHandler {
    private static boolean sUberDebug = false;
    private String mTargetName;
    private ImageDropResolver imageResolver;

    public TargetDrop(String tableName, ImageDropResolver imageResolver) {
        this.mTargetName = tableName;
        this.imageResolver = imageResolver;
    }

    public TargetDrop() {
        this.mTargetName = null;
    }

    private StringBuffer cleanString(StringBuffer instr) {
        int len = instr.length();
        StringBuffer s = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = instr.charAt(i);
            if (c == '\u0000' || c == '\n') continue;
            s.append(c);
        }
        return s;
    }

    @Override
    public void receiveDropString(StringBuffer dropped, Point location) {
        if (dropped == null) {
            JConfig.log().logDebug("Dropped is (null)");
            return;
        }
        dropped = new StringBuffer(this.cleanString(dropped));
        if (sUberDebug) {
            JConfig.log().logDebug("Dropping :" + dropped + ":");
        }
        if (dropped.charAt(0) == '<') {
            JHTML tinyDocument = new JHTML(dropped);
            List<String> allItemsOnPage = tinyDocument.getAllURLsOnPage(true);
            if (allItemsOnPage == null) {
                tinyDocument.reset();
                List<String> allImagesOnPage = tinyDocument.getAllImages();
                if (allImagesOnPage.isEmpty()) {
                    return;
                }
                String img = allImagesOnPage.get(0);
                this.imageResolver.handle(img, location);
                return;
            }
            for (String auctionURL : allItemsOnPage) {
                if (auctionURL == null) continue;
                JConfig.log().logDebug("Adding: " + auctionURL.trim());
                MQFactory.getConcrete("drop").enqueueBean(new DropQObject(auctionURL.trim(), this.mTargetName, true));
            }
        } else {
            String newEntry = dropped.toString();
            if (newEntry.matches("^.*(\\.(jpg|png|jpeg|gif|bmp))$")) {
                this.imageResolver.handle(newEntry, location);
            } else {
                MQFactory.getConcrete("drop").enqueueBean(new DropQObject(newEntry.trim(), this.mTargetName, true));
            }
        }
    }
}

