/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.config;

import com.cyberfox.util.platform.Platform;
import com.jbidwatcher.ui.config.JConfigTab;
import com.jbidwatcher.ui.config.LoginTestListener;
import com.jbidwatcher.ui.util.JBEditorPane;
import com.jbidwatcher.ui.util.JPasteListener;
import com.jbidwatcher.ui.util.OptionUI;
import com.jbidwatcher.util.Constants;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.AuctionQObject;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.SuperQueue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class JConfigEbayTab
extends JConfigTab {
    boolean quickConfig = false;
    JTextField username;
    JTextField password;
    JComboBox siteSelect;
    JCheckBox homeSite;
    JEditorPane siteWarning;
    private String mDisplayName;
    private String mSitename = "ebay";
    private String friendlyName;

    @Override
    public String getTabName() {
        return this.mDisplayName;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void apply() {
        int selectedSite;
        if (JConfig.queryConfiguration("config.level", "quick").equals("quick") != this.quickConfig) {
            return;
        }
        String old_user = JConfig.queryConfiguration(this.mSitename + ".user");
        JConfig.setConfiguration(this.mSitename + ".user", this.username.getText());
        String new_user = JConfig.queryConfiguration(this.mSitename + ".user");
        String old_pass = JConfig.queryConfiguration(this.mSitename + ".password");
        JConfig.setConfiguration(this.mSitename + ".password", this.password.getText());
        String new_pass = JConfig.queryConfiguration(this.mSitename + ".password");
        if (old_pass == null || !new_pass.equals(old_pass) || old_user == null || !new_user.equals(old_user)) {
            MQFactory.getConcrete(this.friendlyName).enqueueBean(new AuctionQObject(4, "Update login cookie", null));
        }
        if (this.homeSite != null) {
            boolean usOnly = this.homeSite.isSelected();
            JConfig.setConfiguration(this.mSitename + ".non_us", Boolean.toString(usOnly));
        }
        if (this.siteSelect != null && (selectedSite = this.siteSelect.getSelectedIndex()) != -1) {
            JConfig.setConfiguration(this.mSitename + ".browse.site", Integer.toString(selectedSite));
        }
        if (JConfig.queryConfiguration("first.run", "false").equals("true")) {
            SuperQueue.getInstance().preQueue("My eBay", "user", System.currentTimeMillis() + 15000L, 0L);
        }
    }

    @Override
    public void updateValues() {
        this.username.setText(JConfig.queryConfiguration(this.mSitename + ".user", "default"));
        this.password.setText(JConfig.queryConfiguration(this.mSitename + ".password", "default"));
        if (this.homeSite != null) {
            this.homeSite.setSelected(JConfig.queryConfiguration(this.mSitename + ".non_us", Boolean.toString(!Platform.isUSBased())).equals("true"));
        }
    }

    private JPanel buildUsernamePanel(JPasteListener pasteListener) {
        JPanel tp = new JPanel();
        tp.setBorder(BorderFactory.createTitledBorder("eBay User ID"));
        tp.setLayout(new BorderLayout());
        this.username = new JTextField();
        this.username.addMouseListener(pasteListener);
        this.username.setText(JConfig.queryConfiguration(this.mSitename + ".user", "default"));
        this.username.setEditable(true);
        this.username.getAccessibleContext().setAccessibleName("User name to log into eBay");
        this.password = new JPasswordField(JConfig.queryConfiguration(this.mSitename + ".password"));
        this.password.addMouseListener(pasteListener);
        this.password.setEditable(true);
        this.password.getAccessibleContext().setAccessibleName("eBay Password");
        this.password.getAccessibleContext().setAccessibleDescription("This is the user password to log into eBay.");
        Box userBox = Box.createVerticalBox();
        userBox.add(JConfigEbayTab.makeLine(new JLabel("Username: "), this.username));
        userBox.add(JConfigEbayTab.makeLine(new JLabel("Password:  "), this.password));
        JButton testButton = new JButton("Test Login");
        testButton.addActionListener(new LoginTestListener(this.mSitename, this.username, this.password));
        tp.add((Component)testButton, "East");
        tp.add(userBox);
        return tp;
    }

    private JPanel buildCheckboxPanel() {
        JPanel tp = new JPanel();
        tp.setBorder(BorderFactory.createTitledBorder("General eBay Options"));
        tp.setLayout(new BoxLayout(tp, 1));
        this.homeSite = new JCheckBox("Prefer non-US auction server?");
        Box siteBox = Box.createHorizontalBox();
        siteBox.add(this.homeSite);
        siteBox.add(Box.createHorizontalGlue());
        tp.add(siteBox);
        String nonUSNotice = "<html><body><div style=\"margin-left: 7px; font-size: 0.96em;\"<i>If this is checked, JBidwatcher will use <b>ebay.co.uk</b> as the source of auctions<br>and destination for placing bids. Otherwise, <b>ebay.com</b> will be used.";
        JBEditorPane jep = OptionUI.getHTMLLabel(nonUSNotice);
        tp.add(jep);
        return tp;
    }

    private JPanel buildBrowseTargetPanel() {
        int realCurrentSite;
        JPanel tp = new JPanel();
        tp.setBorder(BorderFactory.createTitledBorder("Browse target"));
        tp.setLayout(new BorderLayout());
        String curSite = JConfig.queryConfiguration(this.mSitename + ".browse.site", "0");
        try {
            realCurrentSite = Integer.parseInt(curSite);
        }
        catch (Exception ignore) {
            realCurrentSite = 0;
        }
        this.siteSelect = new JComboBox<String>(Constants.SITE_CHOICES);
        this.siteSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int selectedSite = JConfigEbayTab.this.siteSelect.getSelectedIndex();
                if (Constants.SITE_CHOICES[selectedSite].equals("ebay.com")) {
                    JConfigEbayTab.this.siteWarning.setVisible(false);
                    JConfigEbayTab.this.siteWarning.setText("");
                } else if (Constants.SITE_CHOICES[selectedSite].equals("ebay.co.uk")) {
                    String ukSiteWarning = "<html><body><div style=\"font-size: 0.96em;\"><i>Bidding happens on ebay.com preferentially, or ebay.co.uk if the item is not visible on ebay.com.<br>If you have a seller dispute, it may need to be made on ebay.com.</i></div></body></html>";
                    JConfigEbayTab.this.siteWarning.setText(ukSiteWarning);
                    JConfigEbayTab.this.siteWarning.setVisible(true);
                } else {
                    String generalSiteWarning = "<html><body><div style=\"font-size: 0.96em;\"><i>Bidding happens on ebay.com or ebay.co.uk, even if neither is your local site.<br>If you have a seller dispute, it will need to be made on one of those sites.</i></div></body></html>";
                    JConfigEbayTab.this.siteWarning.setText(generalSiteWarning);
                    JConfigEbayTab.this.siteWarning.setVisible(true);
                }
            }
        });
        tp.add((Component)JConfigEbayTab.makeLine(new JLabel("Country site: "), this.siteSelect), "North");
        this.siteWarning = OptionUI.getHTMLLabel("");
        this.siteSelect.setSelectedIndex(realCurrentSite);
        tp.add((Component)this.siteWarning, "East");
        return tp;
    }

    public JConfigEbayTab(boolean isQuickConfig, JPasteListener pasteListener, String friendlyName) {
        this.friendlyName = friendlyName;
        this.quickConfig = isQuickConfig;
        this.mDisplayName = "eBay";
        this.setLayout(new BorderLayout());
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.add((Component)JConfigEbayTab.panelPack(this.buildUsernamePanel(pasteListener)), "North");
        if (!this.quickConfig) {
            jp.add((Component)JConfigEbayTab.panelPack(this.buildBrowseTargetPanel()), "Center");
            this.add((Component)jp, "North");
            this.add((Component)JConfigEbayTab.panelPack(this.buildCheckboxPanel()), "Center");
            String searchNotice = "<html><body><div style=\"margin-left: 10px; font-size: 0.96em;\"><i>To have JBidwatcher regularly retrieve auctions listed on your My eBay page,<br>go to the <a href=\"/SEARCH\">Search Manager</a> and enable the search also named 'My eBay'.</i></div></body></html>";
            JBEditorPane jep = OptionUI.getHTMLLabel(searchNotice);
            this.add((Component)jep, "South");
        } else {
            this.mDisplayName = this.mDisplayName + " (quick)";
            this.add((Component)jp, "North");
            JPanel welcomeMessage = new JPanel();
            welcomeMessage.setLayout(new BoxLayout(welcomeMessage, 1));
            String prefix = "<html><body><center><em>";
            String suffix = "</em></center></body></html>";
            welcomeMessage.add(OptionUI.getHTMLLabel(prefix + "Enter your username and password and click the <code>Save</code> button to get started!" + suffix));
            this.add((Component)welcomeMessage, "Center");
        }
    }
}

