/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.config;

import com.jbidwatcher.auction.server.ebay.ebayLoginManager;
import com.jbidwatcher.util.TT;
import com.jbidwatcher.util.http.CookieJar;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.MessageQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

class LoginTestListener
implements ActionListener,
MessageQueue.Listener {
    CookieJar cj = null;
    private String mSitename;
    private JTextField mUsernameField;
    private JTextField mPasswordField;
    private MessageQueue.Listener mOldLoginListener;
    private final String FAILED = "FAILED";
    private final String NEUTRAL = "NEUTRAL";

    public LoginTestListener(String siteName, JTextField usernameField, JTextField passwordField) {
        this.mSitename = siteName;
        this.mUsernameField = usernameField;
        this.mPasswordField = passwordField;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("Test Login")) {
            TT T = new TT("ebay.com");
            this.mOldLoginListener = MQFactory.getConcrete("login").registerListener(this);
            ebayLoginManager login = new ebayLoginManager(T, this.mSitename, this.mPasswordField.getText(), this.mUsernameField.getText(), false);
            this.cj = login.getNecessaryCookie(true);
        }
    }

    @Override
    public void messageAction(Object deQ) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String result = (String)deQ;
        String loginMessage = "An unrecognized result occurred (" + result + "); please report this.";
        if (result.startsWith("FAILED")) {
            loginMessage = "Login failed.";
            if (result.length() > "FAILED".length()) {
                loginMessage = loginMessage + "\n" + result.substring("FAILED".length() + 1);
            }
        } else if (result.startsWith("NEUTRAL")) {
            loginMessage = this.cj == null ? "The login did not cause any errors but found no\ncookies.  It probably failed." : "The login did not cause any errors and delivered\ncookies, but was not clearly recognized as successful.";
            if (result.length() > "NEUTRAL".length()) {
                loginMessage = loginMessage + "\n" + result.substring("NEUTRAL".length() + 1);
            }
        } else if (result.startsWith("CAPTCHA")) {
            loginMessage = "eBay put up a 'captcha', to prevent programs from logging into your account.  Login failed.";
        } else if (result.startsWith("SUCCESSFUL")) {
            loginMessage = "Successfully logged in.";
        }
        JOptionPane.showMessageDialog(null, loginMessage, "Login Test", 1);
        MQFactory.getConcrete("login").removeListener(this);
        MQFactory.getConcrete("login").registerListener(this.mOldLoginListener);
    }
}

